/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import com.oracle.truffle.regex.tregex.dfa.DFACaptureGroupTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.NFATransitionSet;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DFAStateNodeBuilder
implements JsonConvertible {
    private static final byte FLAG_INITIAL_STATE = 1;
    private static final byte FLAG_OVERRIDE_FINAL_STATE = 2;
    private static final byte FLAG_FINAL_STATE_SUCCESSOR = 4;
    private static final byte FLAG_BACKWARD_PREFIX_STATE = 8;
    private static final List<DFACaptureGroupTransitionBuilder> NODE_SPLIT_TAINTED = new ArrayList<DFACaptureGroupTransitionBuilder>();
    private static final String NODE_SPLIT_UNINITIALIZED_PRECEDING_TRANSITIONS_ERROR_MSG = "this state node builder was altered by the node splitter and does not have valid information about preceding transitions!";
    private final short id;
    private byte flags;
    private NFATransitionSet nfaTransitionSet;
    private short backwardPrefixState = (short)-1;
    private DFAStateTransitionBuilder[] transitions;
    private List<DFACaptureGroupTransitionBuilder> precedingTransitions;
    private NFAStateTransition anchoredFinalStateTransition;
    private NFAStateTransition unAnchoredFinalStateTransition;
    private byte preCalculatedUnAnchoredResult = (byte)-1;
    private byte preCalculatedAnchoredResult = (byte)-1;

    DFAStateNodeBuilder(short id, NFATransitionSet nfaStateSet, boolean isBackwardPrefixState, boolean isInitialState) {
        this.id = id;
        this.nfaTransitionSet = nfaStateSet;
        this.setFlag((byte)8, isBackwardPrefixState);
        this.setFlag((byte)1, isInitialState);
        if (isBackwardPrefixState) {
            this.backwardPrefixState = this.id;
        }
    }

    private DFAStateNodeBuilder(DFAStateNodeBuilder copy, short copyID) {
        this.id = copyID;
        this.flags = copy.flags;
        this.nfaTransitionSet = copy.nfaTransitionSet;
        this.backwardPrefixState = copy.backwardPrefixState;
        this.transitions = new DFAStateTransitionBuilder[copy.transitions.length];
        for (int i = 0; i < this.transitions.length; ++i) {
            this.transitions[i] = copy.transitions[i].createNodeSplitCopy();
        }
        this.precedingTransitions = NODE_SPLIT_TAINTED;
        this.anchoredFinalStateTransition = copy.anchoredFinalStateTransition;
        this.unAnchoredFinalStateTransition = copy.unAnchoredFinalStateTransition;
        this.preCalculatedAnchoredResult = copy.preCalculatedAnchoredResult;
        this.preCalculatedUnAnchoredResult = copy.preCalculatedUnAnchoredResult;
    }

    public DFAStateNodeBuilder createNodeSplitCopy(short copyID) {
        return new DFAStateNodeBuilder(this, copyID);
    }

    public void nodeSplitUpdateSuccessors(short[] newSuccessors, DFAStateNodeBuilder[] stateIndexMap) {
        for (int i = 0; i < this.transitions.length; ++i) {
            DFAStateNodeBuilder successor = stateIndexMap[newSuccessors[i]];
            assert (successor != null);
            successor.precedingTransitions = NODE_SPLIT_TAINTED;
            this.transitions[i].setTarget(successor);
        }
        if (this.hasBackwardPrefixState()) {
            assert (newSuccessors.length == this.transitions.length + 1);
            this.backwardPrefixState = newSuccessors[newSuccessors.length - 1];
        }
    }

    public short getId() {
        return this.id;
    }

    public void setNfaTransitionSet(NFATransitionSet nfaTransitionSet) {
        this.nfaTransitionSet = nfaTransitionSet;
    }

    public NFATransitionSet getNfaTransitionSet() {
        return this.nfaTransitionSet;
    }

    public void setInitialState(boolean initialState) {
        this.setFlag((byte)1, initialState);
    }

    public boolean isInitialState() {
        return this.isFlagSet((byte)1);
    }

    public void setOverrideFinalState(boolean overrideFinalState) {
        this.setFlag((byte)2, overrideFinalState);
    }

    public boolean isFinalStateSuccessor() {
        return this.isFlagSet((byte)4);
    }

    public void setFinalStateSuccessor() {
        this.setFlag((byte)4);
    }

    public boolean isBackwardPrefixState() {
        return this.isFlagSet((byte)8);
    }

    public void setIsBackwardPrefixState(boolean backwardPrefixState) {
        this.setFlag((byte)8, backwardPrefixState);
    }

    public boolean isFinalState() {
        return this.unAnchoredFinalStateTransition != null || this.isFlagSet((byte)2);
    }

    public boolean isAnchoredFinalState() {
        return this.anchoredFinalStateTransition != null;
    }

    public int getNumberOfSuccessors() {
        return this.transitions.length + (this.hasBackwardPrefixState() ? 1 : 0);
    }

    public DFAStateTransitionBuilder[] getTransitions() {
        return this.transitions;
    }

    public void setTransitions(DFAStateTransitionBuilder[] transitions) {
        this.transitions = transitions;
    }

    private boolean isFlagSet(byte flag) {
        return (this.flags & flag) != 0;
    }

    private void setFlag(byte flag) {
        this.setFlag(flag, true);
    }

    private void setFlag(byte flag, boolean value) {
        this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
    }

    public boolean coversFullCharSpace(CompilationBuffer compilationBuffer) {
        IntRangesBuffer indicesBuf = compilationBuffer.getIntRangesBuffer1();
        indicesBuf.ensureCapacity(this.transitions.length);
        int[] indices = indicesBuf.getBuffer();
        Arrays.fill(indices, 0, this.transitions.length, 0);
        int nextLo = 0;
        int i;
        while ((i = this.findNextLo(indices, nextLo)) >= 0) {
            CharSet mb = this.transitions[i].getMatcherBuilder();
            if (mb.getHi(indices[i]) == 65535) {
                return true;
            }
            nextLo = mb.getHi(indices[i]) + 1;
            int n = i;
            indices[n] = indices[n] + 1;
        }
        return false;
    }

    private int findNextLo(int[] indices, int findLo) {
        for (int i = 0; i < this.transitions.length; ++i) {
            CharSet mb = this.transitions[i].getMatcherBuilder();
            if (indices[i] == mb.size() || mb.getLo(indices[i]) != findLo) continue;
            return i;
        }
        return -1;
    }

    public void addPrecedingTransition(DFACaptureGroupTransitionBuilder transitionBuilder) {
        if (this.precedingTransitions == NODE_SPLIT_TAINTED) {
            throw new IllegalStateException(NODE_SPLIT_UNINITIALIZED_PRECEDING_TRANSITIONS_ERROR_MSG);
        }
        if (this.precedingTransitions == null) {
            this.precedingTransitions = new ArrayList<DFACaptureGroupTransitionBuilder>();
        }
        this.precedingTransitions.add(transitionBuilder);
    }

    public List<DFACaptureGroupTransitionBuilder> getPrecedingTransitions() {
        if (this.precedingTransitions == NODE_SPLIT_TAINTED) {
            throw new IllegalStateException(NODE_SPLIT_UNINITIALIZED_PRECEDING_TRANSITIONS_ERROR_MSG);
        }
        if (this.precedingTransitions == null) {
            return Collections.emptyList();
        }
        return this.precedingTransitions;
    }

    public boolean hasBackwardPrefixState() {
        return this.backwardPrefixState >= 0;
    }

    public short getBackwardPrefixState() {
        return this.backwardPrefixState;
    }

    public void setBackwardPrefixState(short backwardPrefixState) {
        this.backwardPrefixState = backwardPrefixState;
    }

    public void setAnchoredFinalStateTransition(NFAStateTransition anchoredFinalStateTransition) {
        this.anchoredFinalStateTransition = anchoredFinalStateTransition;
    }

    public NFAStateTransition getAnchoredFinalStateTransition() {
        return this.anchoredFinalStateTransition;
    }

    public void setUnAnchoredFinalStateTransition(NFAStateTransition unAnchoredFinalStateTransition) {
        this.unAnchoredFinalStateTransition = unAnchoredFinalStateTransition;
    }

    public NFAStateTransition getUnAnchoredFinalStateTransition() {
        return this.unAnchoredFinalStateTransition;
    }

    public byte getPreCalculatedUnAnchoredResult() {
        return this.preCalculatedUnAnchoredResult;
    }

    public byte getPreCalculatedAnchoredResult() {
        return this.preCalculatedAnchoredResult;
    }

    void updatePreCalcUnAnchoredResult(int newResult) {
        if (newResult >= 0 && (this.preCalculatedUnAnchoredResult == -1 || Byte.toUnsignedInt(this.preCalculatedUnAnchoredResult) > newResult)) {
            this.preCalculatedUnAnchoredResult = (byte)newResult;
        }
    }

    private void updatePreCalcAnchoredResult(int newResult) {
        if (newResult >= 0 && (this.preCalculatedAnchoredResult == -1 || Byte.toUnsignedInt(this.preCalculatedAnchoredResult) > newResult)) {
            this.preCalculatedAnchoredResult = (byte)newResult;
        }
    }

    public void clearPreCalculatedResults() {
        this.preCalculatedUnAnchoredResult = (byte)-1;
        this.preCalculatedAnchoredResult = (byte)-1;
    }

    public void updateFinalStateData(DFAGenerator dfaGenerator) {
        boolean forward = this.nfaTransitionSet.isForward();
        for (NFAStateTransition t : this.nfaTransitionSet) {
            NFAState target = t.getTarget(forward);
            if (target.hasTransitionToAnchoredFinalState(forward) && this.anchoredFinalStateTransition == null) {
                this.setAnchoredFinalStateTransition(target.getTransitionToAnchoredFinalState(forward));
            }
            if (target.hasTransitionToUnAnchoredFinalState(forward)) {
                this.setUnAnchoredFinalStateTransition(target.getTransitionToUnAnchoredFinalState(forward));
                if (forward) {
                    return;
                }
            }
            if (!dfaGenerator.getNfa().isTraceFinderNFA()) continue;
            for (NFAStateTransition t2 : target.getNext(forward)) {
                NFAState target2 = t2.getTarget(forward);
                if (target2.isAnchoredFinalState(forward)) {
                    assert (target2.hasPossibleResults() && target2.getPossibleResults().size() == 1);
                    this.updatePreCalcAnchoredResult(target2.getPossibleResults().get(0));
                }
                if (!target2.isUnAnchoredFinalState(forward)) continue;
                assert (target2.hasPossibleResults() && target2.getPossibleResults().size() == 1);
                this.updatePreCalcUnAnchoredResult(target2.getPossibleResults().get(0));
            }
        }
    }

    public String stateSetToString() {
        StringBuilder sb = new StringBuilder(this.nfaTransitionSet.toString());
        if (this.preCalculatedUnAnchoredResult != -1) {
            sb.append("_r").append(this.preCalculatedUnAnchoredResult);
        }
        if (this.preCalculatedAnchoredResult != -1) {
            sb.append("_rA").append(this.preCalculatedAnchoredResult);
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = this.nfaTransitionSet.hashCode();
        if (this.isBackwardPrefixState()) {
            hashCode *= 31;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DFAStateNodeBuilder)) {
            return false;
        }
        DFAStateNodeBuilder o = (DFAStateNodeBuilder)obj;
        return this.nfaTransitionSet.equals(o.nfaTransitionSet) && this.isBackwardPrefixState() == o.isBackwardPrefixState();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder();
        return DebugUtil.appendNodeId(sb, this.id).append(": ").append(this.stateSetToString()).toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("id", this.id), Json.prop("stateSet", Json.array(this.nfaTransitionSet.stream().map(x -> Json.val(x.getTarget().getId())))), Json.prop("finalState", this.isFinalState()), Json.prop("anchoredFinalState", this.isAnchoredFinalState()), Json.prop("transitions", Arrays.stream(this.transitions).map(x -> Json.val(x.getId()))));
    }
}

