/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.nfa.ASTStep;
import com.oracle.truffle.regex.tregex.nfa.ASTTransition;
import com.oracle.truffle.regex.tregex.nfa.ASTTransitionCanonicalizer;
import com.oracle.truffle.regex.tregex.nfa.ASTTransitionSet;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

final class ASTSuccessor
implements JsonConvertible {
    private ArrayList<TransitionBuilder<ASTTransitionSet>> mergedStates = new ArrayList();
    private boolean lookAroundsMerged = false;
    private List<ASTStep> lookAheads = Collections.emptyList();
    private List<ASTStep> lookBehinds = Collections.emptyList();
    private final CompilationBuffer compilationBuffer;

    ASTSuccessor(CompilationBuffer compilationBuffer) {
        this.compilationBuffer = compilationBuffer;
    }

    ASTSuccessor(CompilationBuffer compilationBuffer, ASTTransition initialTransition) {
        this.compilationBuffer = compilationBuffer;
        this.addInitialTransition(initialTransition);
    }

    public void addInitialTransition(ASTTransition transition) {
        CharSet charSet = CharSet.getFull();
        if (transition.getTarget() instanceof CharacterClass) {
            charSet = ((CharacterClass)transition.getTarget()).getCharSet();
        }
        this.mergedStates.add(new TransitionBuilder<ASTTransitionSet>(new ASTTransitionSet(transition), charSet));
    }

    public void setLookAheads(ArrayList<ASTStep> lookAheads) {
        this.lookAheads = lookAheads;
    }

    public void setLookBehinds(ArrayList<ASTStep> lookBehinds) {
        this.lookBehinds = lookBehinds;
    }

    public void addLookBehinds(Collection<ASTStep> addLookBehinds) {
        if (this.lookBehinds.isEmpty()) {
            this.lookBehinds = new ArrayList<ASTStep>();
        }
        this.lookBehinds.addAll(addLookBehinds);
    }

    public ArrayList<TransitionBuilder<ASTTransitionSet>> getMergedStates(ASTTransitionCanonicalizer canonicalizer) {
        if (!this.lookAroundsMerged) {
            this.mergeLookArounds(canonicalizer);
            this.lookAroundsMerged = true;
        }
        return this.mergedStates;
    }

    private void mergeLookArounds(ASTTransitionCanonicalizer canonicalizer) {
        assert (this.mergedStates.size() == 1);
        TransitionBuilder<ASTTransitionSet> successor = this.mergedStates.get(0);
        for (ASTStep lookBehind : this.lookBehinds) {
            this.addAllIntersecting(canonicalizer, successor, lookBehind, this.mergedStates);
        }
        TransitionBuilder[] mergedLookBehinds = canonicalizer.run(this.mergedStates, this.compilationBuffer);
        this.mergedStates.clear();
        Collections.addAll(this.mergedStates, mergedLookBehinds);
        ArrayList<TransitionBuilder<ASTTransitionSet>> newMergedStates = new ArrayList();
        for (ASTStep lookAhead : this.lookAheads) {
            for (TransitionBuilder<ASTTransitionSet> state : this.mergedStates) {
                this.addAllIntersecting(canonicalizer, state, lookAhead, newMergedStates);
            }
            ArrayList<TransitionBuilder<ASTTransitionSet>> tmp = this.mergedStates;
            this.mergedStates = newMergedStates;
            newMergedStates = tmp;
            newMergedStates.clear();
        }
    }

    private void addAllIntersecting(ASTTransitionCanonicalizer canonicalizer, TransitionBuilder<ASTTransitionSet> state, ASTStep lookAround, ArrayList<TransitionBuilder<ASTTransitionSet>> result) {
        for (ASTSuccessor successor : lookAround.getSuccessors()) {
            for (TransitionBuilder<ASTTransitionSet> lookAroundState : successor.getMergedStates(canonicalizer)) {
                CharSet intersection = state.getMatcherBuilder().createIntersection(lookAroundState.getMatcherBuilder(), this.compilationBuffer);
                if (!intersection.matchesSomething()) continue;
                result.add(state.createMerged(lookAroundState, intersection));
            }
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        this.getMergedStates(new ASTTransitionCanonicalizer());
        return Json.obj(Json.prop("lookAheads", this.lookAheads.stream().map(x -> Json.val(x.getRoot().getId())).collect(Collectors.toList())), Json.prop("lookBehinds", this.lookBehinds.stream().map(x -> Json.val(x.getRoot().getId())).collect(Collectors.toList())), Json.prop("mergedStates", this.mergedStates));
    }
}

