/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputIndexOfStringNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;

public final class DFAFindInnerLiteralStateNode
extends DFAAbstractStateNode {
    private final String literal;
    private final String mask;
    @Node.Child
    private InputIndexOfStringNode indexOfNode = InputIndexOfStringNode.create();
    @Node.Child
    private TRegexDFAExecutorNode prefixMatcher;

    public DFAFindInnerLiteralStateNode(short id, short[] successors, String literal, String mask, TRegexDFAExecutorNode prefixMatcher) {
        super(id, successors);
        assert (successors.length == 1);
        this.literal = literal;
        this.mask = mask;
        this.prefixMatcher = prefixMatcher;
    }

    @Override
    public DFAAbstractStateNode createNodeSplitCopy(short copyID) {
        return new DFAFindInnerLiteralStateNode(copyID, Arrays.copyOf(this.getSuccessors(), this.getSuccessors().length), this.literal, this.mask, this.prefixMatcher);
    }

    @Override
    public void executeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        while (true) {
            if (!executor.hasNext(locals)) {
                locals.setSuccessorIndex(-1);
                return;
            }
            locals.setIndex(this.indexOfNode.execute(locals.getInput(), locals.getIndex(), locals.getCurMaxIndex(), this.literal, this.mask));
            if (locals.getIndex() < 0) {
                locals.setSuccessorIndex(-1);
                return;
            }
            if (this.prefixMatcher == null || this.prefixMatcherMatches(locals, executor, compactString)) {
                if (this.prefixMatcher == null && executor.isSimpleCG()) {
                    locals.getCGData().results[0] = locals.getIndex();
                }
                locals.setIndex(locals.getIndex() + this.literal.length());
                locals.setSuccessorIndex(0);
                return;
            }
            executor.advance(locals);
        }
    }

    private boolean prefixMatcherMatches(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean compactString) {
        Object result = this.prefixMatcher.execute(locals.toInnerLiteralBackwardLocals(executor.getPrefixLength()), compactString);
        return this.prefixMatcher.isSimpleCG() ? result != null : (Integer)result != -2;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("id", this.getId()), Json.prop("anchoredFinalState", false), Json.prop("finalState", false), Json.prop("loopToSelf", false), Json.prop("transitions", Json.array(Json.obj(Json.prop("matcher", "innerLiteral(" + this.literal + ")"), Json.prop("target", this.successors[0])))));
    }
}

