/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast.visitors;

import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;

public class CalcMinPathsVisitor
extends DepthFirstTraversalRegexASTVisitor {
    @Override
    protected void init(RegexASTNode runRoot) {
        runRoot.setMinPath(0);
        runRoot.setMaxPath(0);
    }

    @Override
    protected void visit(BackReference backReference) {
    }

    @Override
    protected void visit(Group group) {
        if (group.getParent() instanceof Sequence) {
            group.setMinPath(group.getParent().getMinPath());
            group.setMaxPath(group.getParent().getMaxPath());
        } else {
            assert (group.getParent() instanceof RegexASTSubtreeRootNode);
            group.setMinPath(0);
            group.setMaxPath(0);
        }
    }

    @Override
    protected void leave(Group group) {
        if (group.isDead()) {
            return;
        }
        int minPath = Short.MAX_VALUE;
        int maxPath = 0;
        boolean caret = true;
        boolean dollar = true;
        boolean hasLoops = group.isLoop();
        boolean isDead = true;
        for (Sequence s : group.getAlternatives()) {
            isDead &= s.isDead();
            if (s.isDead()) continue;
            caret &= s.startsWithCaret();
            dollar &= s.endsWithDollar();
            hasLoops |= s.hasLoops();
            minPath = Math.min(minPath, s.getMinPath());
            maxPath = Math.max(maxPath, s.getMaxPath());
        }
        if (group.hasQuantifier()) {
            if (group.getQuantifier().getMin() == 0) {
                caret = false;
                dollar = false;
            }
            minPath = group.getMinPath() + (minPath - group.getMinPath()) * group.getQuantifier().getMin();
            if (group.getQuantifier().isInfiniteLoop()) {
                hasLoops = true;
            } else {
                maxPath = group.getMaxPath() + (maxPath - group.getMaxPath()) * group.getQuantifier().getMax();
            }
        }
        group.setStartsWithCaret(caret);
        group.setEndsWithDollar(dollar);
        group.setHasLoops(hasLoops);
        if (isDead) {
            group.markAsDead();
        }
        group.setMinPath(minPath);
        group.setMaxPath(maxPath);
        if (group.getParent() instanceof Sequence) {
            group.getParent().setMinPath(minPath);
            group.getParent().setMaxPath(maxPath);
        }
        if (group.getParent() != null) {
            if (caret) {
                group.getParent().setStartsWithCaret();
            }
            if (dollar) {
                group.getParent().setEndsWithDollar();
            }
            if (hasLoops) {
                group.getParent().setHasLoops();
            }
            if (isDead) {
                group.getParent().markAsDead();
            }
        }
    }

    @Override
    protected void visit(Sequence sequence) {
        sequence.setMinPath(sequence.getParent().getMinPath());
        sequence.setMaxPath(sequence.getParent().getMaxPath());
    }

    @Override
    protected void visit(PositionAssertion assertion) {
        switch (assertion.type) {
            case CARET: {
                if (this.isReverse()) break;
                if (assertion.getParent().getMinPath() > 0) {
                    assertion.markAsDead();
                    assertion.getParent().markAsDead();
                    break;
                }
                assertion.getParent().setStartsWithCaret();
                break;
            }
            case DOLLAR: {
                if (!this.isReverse()) break;
                if (assertion.getParent().getMinPath() > 0) {
                    assertion.markAsDead();
                    assertion.getParent().markAsDead();
                    break;
                }
                assertion.getParent().setEndsWithDollar();
            }
        }
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        assertion.setMinPath(assertion.getParent().getMinPath());
        assertion.setMaxPath(assertion.getParent().getMaxPath());
    }

    @Override
    protected void leave(LookBehindAssertion assertion) {
        this.leaveLookAroundAssertion(assertion);
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        assertion.setMinPath(assertion.getParent().getMinPath());
        assertion.setMaxPath(assertion.getParent().getMaxPath());
    }

    @Override
    protected void leave(LookAheadAssertion assertion) {
        this.leaveLookAroundAssertion(assertion);
    }

    public void leaveLookAroundAssertion(LookAroundAssertion assertion) {
        if (assertion.startsWithCaret()) {
            assertion.getParent().setStartsWithCaret();
        }
        if (assertion.endsWithDollar()) {
            assertion.getParent().setEndsWithDollar();
        }
        if (assertion.hasLoops()) {
            assertion.getParent().setHasLoops();
        }
        if (assertion.isDead()) {
            assertion.getParent().markAsDead();
        }
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        if (characterClass.hasQuantifier()) {
            characterClass.getParent().incMinPath(characterClass.getQuantifier().getMin());
            if (characterClass.getQuantifier().isInfiniteLoop()) {
                characterClass.setHasLoops();
                characterClass.getParent().setHasLoops();
            } else {
                characterClass.getParent().incMaxPath(characterClass.getQuantifier().getMax());
            }
        } else {
            characterClass.getParent().incMinPath();
            characterClass.getParent().incMaxPath();
        }
        characterClass.setMinPath(characterClass.getParent().getMinPath());
        characterClass.setMaxPath(characterClass.getParent().getMaxPath());
        if (characterClass.getCharSet().matchesNothing()) {
            characterClass.markAsDead();
            characterClass.getParent().markAsDead();
        }
    }

    @Override
    protected void visit(MatchFound matchFound) {
        throw new IllegalStateException();
    }
}

