/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.agentscript.impl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.tools.agentscript.impl.AgentException;
import com.oracle.truffle.tools.agentscript.impl.ArrayObject;
import java.util.Set;
import java.util.TreeSet;

@ExportLibrary(value=InteropLibrary.class)
final class VariablesObject
implements TruffleObject {
    private final TruffleInstrument.Env env;
    private final Node where;
    private final Frame frame;

    VariablesObject(TruffleInstrument.Env env, Node where, Frame frame) {
        this.env = env;
        this.where = where;
        this.frame = frame.materialize();
    }

    @ExportMessage
    static boolean hasMembers(VariablesObject obj) {
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Object getMembers(boolean includeInternal) {
        TreeSet<String> names = new TreeSet<String>();
        InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        for (Scope scope : this.env.findLocalScopes(this.where, this.frame)) {
            try {
                if (scope == null) continue;
                String receiverName = scope.getReceiverName();
                if (receiverName != null) {
                    names.add(receiverName);
                }
                VariablesObject.readMemberNames(names, scope.getVariables(), iop);
                VariablesObject.readMemberNames(names, scope.getArguments(), iop);
            }
            catch (InteropException ex) {
                throw AgentException.raise((Exception)((Object)ex));
            }
        }
        return ArrayObject.wrap(names);
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Object readMember(String member) throws UnknownIdentifierException {
        InteropLibrary iop = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        for (Scope scope : this.env.findLocalScopes(this.where, this.frame)) {
            if (scope == null) continue;
            if (member.equals(scope.getReceiverName())) {
                return scope.getReceiver();
            }
            Object variable = VariablesObject.readMemberImpl(member, scope.getVariables(), iop);
            if (variable != null) {
                return variable;
            }
            Object argument = VariablesObject.readMemberImpl(member, scope.getArguments(), iop);
            if (argument == null) continue;
            return argument;
        }
        throw UnknownIdentifierException.create((String)member);
    }

    static Object readMemberImpl(String name, Object map, InteropLibrary iop) {
        if (map != null && iop.hasMembers(map)) {
            try {
                return iop.readMember(map, name);
            }
            catch (InteropException e) {
                return null;
            }
        }
        return null;
    }

    private static void readMemberNames(Set<String> names, Object map, InteropLibrary iop) throws InteropException {
        if (iop.hasMembers(map)) {
            Object members = iop.getMembers(map);
            long size = iop.getArraySize(members);
            for (long i = 0L; i < size; ++i) {
                Object at = iop.readArrayElement(members, i);
                if (!(at instanceof String)) continue;
                names.add((String)at);
            }
        }
    }

    @ExportMessage
    static boolean isMemberReadable(VariablesObject obj, String member) {
        return true;
    }
}

