/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSConstructTypedArrayNodeGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeFromConstructorNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;

@ImportStatic(value={JSArrayBuffer.class, JSRuntime.class})
public abstract class JSConstructTypedArrayNode
extends JSBuiltinNode {
    @Node.Child
    private JSToIndexNode toIndexNode;
    @Node.Child
    private GetPrototypeFromConstructorNode getPrototypeFromConstructorViewNode;
    @Node.Child
    private GetPrototypeFromConstructorNode getPrototypeFromConstructorBufferNode;
    @Node.Child
    private IntegerIndexedObjectCreateNode integerIndexObjectCreateNode;
    @Node.Child
    private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode arraySpeciesConstructorNode;
    private final BranchProfile errorBranch = BranchProfile.create();
    private final TypedArrayFactory factory;

    public JSConstructTypedArrayNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
        this.factory = JSConstructTypedArrayNode.findTypedArrayFactory(builtin.getName(), context);
    }

    private static TypedArrayFactory findTypedArrayFactory(String name, JSContext context) {
        for (TypedArrayFactory typedArrayFactory : TypedArray.factories(context)) {
            if (!typedArrayFactory.getName().equals(name)) continue;
            return typedArrayFactory;
        }
        throw new NoSuchElementException(name);
    }

    private long toIndex(Object target) {
        if (this.toIndexNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toIndexNode = (JSToIndexNode)this.insert(JSToIndexNode.create());
        }
        return this.toIndexNode.executeLong(target);
    }

    private DynamicObject getPrototypeFromConstructorView(DynamicObject newTarget) {
        if (this.getPrototypeFromConstructorViewNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getPrototypeFromConstructorViewNode = (GetPrototypeFromConstructorNode)this.insert(GetPrototypeFromConstructorNode.create(this.getContext(), null, realm -> realm.getArrayBufferViewPrototype(this.factory)));
        }
        return this.getPrototypeFromConstructorViewNode.executeWithConstructor(newTarget);
    }

    private DynamicObject getPrototypeFromConstructorBuffer(DynamicObject newTarget) {
        if (this.getPrototypeFromConstructorBufferNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getPrototypeFromConstructorBufferNode = (GetPrototypeFromConstructorNode)this.insert(GetPrototypeFromConstructorNode.create(this.getContext(), null, JSRealm::getArrayBufferPrototype));
        }
        return this.getPrototypeFromConstructorBufferNode.executeWithConstructor(newTarget);
    }

    private DynamicObject integerIndexObjectCreate(DynamicObject arrayBuffer, TypedArray typedArray, int offset, int length, DynamicObject proto) {
        if (this.integerIndexObjectCreateNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.integerIndexObjectCreateNode = (IntegerIndexedObjectCreateNode)this.insert(JSConstructTypedArrayNodeGen.IntegerIndexedObjectCreateNodeGen.create(this.getContext(), this.factory));
        }
        return this.integerIndexObjectCreateNode.execute(arrayBuffer, typedArray, offset, length, proto);
    }

    protected final ReadElementNode createReadNode() {
        return ReadElementNode.create(this.getContext());
    }

    private void checkDetachedBuffer(DynamicObject buffer) {
        if (!this.getContext().getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(buffer)) {
            throw Errors.createTypeErrorDetachedBuffer();
        }
    }

    @Specialization(guards={"isJSFunction(newTarget)", "isJSHeapArrayBuffer(arrayBuffer)"})
    protected DynamicObject doArrayBuffer(DynamicObject newTarget, DynamicObject arrayBuffer, Object byteOffset0, Object length0, @Cached(value="createBinaryProfile()") ConditionProfile lengthIsUndefined) {
        this.checkDetachedBuffer(arrayBuffer);
        byte[] byteArray = JSArrayBuffer.getByteArray(arrayBuffer);
        int arrayBufferLength = byteArray.length;
        return this.doArrayBufferImpl(arrayBuffer, byteOffset0, length0, newTarget, arrayBufferLength, false, lengthIsUndefined);
    }

    @Specialization(guards={"isJSFunction(newTarget)", "isJSDirectArrayBuffer(arrayBuffer)"})
    protected DynamicObject doDirectArrayBuffer(DynamicObject newTarget, DynamicObject arrayBuffer, Object byteOffset0, Object length0, @Cached(value="createBinaryProfile()") ConditionProfile lengthIsUndefined) {
        this.checkDetachedBuffer(arrayBuffer);
        ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer(arrayBuffer);
        int arrayBufferLength = byteBuffer.limit();
        return this.doArrayBufferImpl(arrayBuffer, byteOffset0, length0, newTarget, arrayBufferLength, true, lengthIsUndefined);
    }

    private DynamicObject doArrayBufferImpl(DynamicObject arrayBuffer, Object byteOffset0, Object length0, DynamicObject newTarget, int bufferByteLength, boolean direct, ConditionProfile lengthIsUndefinedProfile) {
        int elementSize = this.factory.getBytesPerElement();
        long byteOffset = this.toIndex(byteOffset0);
        this.rangeCheckIsMultipleOfElementSize(byteOffset % (long)elementSize == 0L, "start offset", this.factory.getName(), elementSize);
        long length = 0L;
        if (!lengthIsUndefinedProfile.profile(length0 == Undefined.instance)) {
            length = this.toIndex(length0);
            assert (length >= 0L);
        }
        this.checkDetachedBuffer(arrayBuffer);
        if (lengthIsUndefinedProfile.profile(length0 == Undefined.instance)) {
            this.rangeCheckIsMultipleOfElementSize(bufferByteLength % elementSize == 0, "buffer.byteLength", this.factory.getName(), elementSize);
            length = ((long)bufferByteLength - byteOffset) / (long)elementSize;
            this.rangeCheck(length >= 0L, "length < 0");
        }
        this.checkLengthLimit(length, elementSize);
        int byteLength = JSConstructTypedArrayNode.toByteLength((int)length, elementSize);
        this.rangeCheck(byteOffset + (long)byteLength <= (long)bufferByteLength, "length exceeds buffer bounds");
        assert (byteOffset <= Integer.MAX_VALUE && length <= Integer.MAX_VALUE);
        TypedArray typedArray = this.factory.createArrayType(direct, byteOffset != 0L);
        return this.createTypedArray(arrayBuffer, typedArray, (int)byteOffset, (int)length, newTarget);
    }

    @Specialization(guards={"isJSFunction(newTarget)", "isJSSharedArrayBuffer(arrayBuffer)"})
    protected DynamicObject doSharedArrayBuffer(DynamicObject newTarget, DynamicObject arrayBuffer, Object byteOffset0, Object length0, @Cached(value="createBinaryProfile()") ConditionProfile lengthCondition) {
        return this.doDirectArrayBuffer(newTarget, arrayBuffer, byteOffset0, length0, lengthCondition);
    }

    @Specialization(guards={"isJSFunction(newTarget)", "isJSArrayBufferView(arrayBufferView)"})
    protected DynamicObject doArrayBufferView(DynamicObject newTarget, DynamicObject arrayBufferView, Object byteOffset0, Object length0) {
        TypedArray sourceType = JSArrayBufferView.typedArrayGetArrayType(arrayBufferView);
        long length = sourceType.length(arrayBufferView);
        DynamicObject srcData = JSArrayBufferView.getArrayBuffer(arrayBufferView);
        DynamicObject defaultBufferConstructor = this.getContext().getRealm().getArrayBufferConstructor();
        DynamicObject bufferConstructor = JSSharedArrayBuffer.isJSSharedArrayBuffer(srcData) ? defaultBufferConstructor : this.getArraySpeciesConstructorNode().speciesConstructor(srcData, defaultBufferConstructor);
        DynamicObject arrayBuffer = this.createTypedArrayBuffer(length);
        JSObject.setPrototype(arrayBuffer, this.getPrototypeFromConstructorBuffer(bufferConstructor));
        this.checkDetachedBuffer(srcData);
        boolean elementTypeIsBig = JSRuntime.isTypedArrayBigIntFactory(this.factory);
        boolean sourceTypeIsBig = sourceType instanceof TypedArray.TypedBigIntArray;
        if (elementTypeIsBig != sourceTypeIsBig) {
            throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
        }
        TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer(), false);
        DynamicObject result = this.createTypedArray(arrayBuffer, typedArray, 0, (int)length, newTarget);
        assert (typedArray == JSArrayBufferView.typedArrayGetArrayType(result));
        for (long i = 0L; i < length; ++i) {
            Object element = sourceType.getElement(arrayBufferView, i);
            typedArray.setElement(result, i, element, false);
        }
        return result;
    }

    protected ArrayPrototypeBuiltins.ArraySpeciesConstructorNode getArraySpeciesConstructorNode() {
        if (this.arraySpeciesConstructorNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.arraySpeciesConstructorNode = (ArrayPrototypeBuiltins.ArraySpeciesConstructorNode)this.insert(ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(this.getContext(), true));
        }
        return this.arraySpeciesConstructorNode;
    }

    @Specialization(guards={"isJSFunction(newTarget)", "isJSArray(array)"})
    protected DynamicObject doArray(DynamicObject newTarget, DynamicObject array, Object byteOffset0, Object length0, @Cached(value="createReadNode()") ReadElementNode readElementNode) {
        long length = JSAbstractArray.arrayGetArrayType(array).length(array);
        DynamicObject result = this.createTypedArrayWithLength(length, newTarget);
        assert (length <= Integer.MAX_VALUE);
        TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer(), false);
        assert (typedArray == JSArrayBufferView.typedArrayGetArrayType(result));
        int i = 0;
        while ((long)i < length) {
            Object element = readElementNode.executeWithTargetAndIndex((Object)array, i);
            typedArray.setElement(result, i, element, false);
            ++i;
        }
        return result;
    }

    @Specialization(guards={"isJSFunction(newTarget)", "isUndefined(arg0)"})
    protected DynamicObject doEmpty(DynamicObject newTarget, DynamicObject arg0, Object byteOffset0, Object length0) {
        return this.createTypedArrayWithLength(0L, newTarget);
    }

    @Specialization(guards={"isJSFunction(newTarget)", "!isJSObject(arg0)"})
    protected DynamicObject doLength(DynamicObject newTarget, Object arg0, Object byteOffset0, Object length0) {
        return this.createTypedArrayWithLength(this.toIndex(arg0), newTarget);
    }

    @Specialization(guards={"isJSFunction(newTarget)", "isJSObject(object)", "!isJSAbstractBuffer(object)", "!isJSArrayBufferView(object)", "!isJSArray(object)"})
    protected DynamicObject doObject(DynamicObject newTarget, DynamicObject object, Object byteOffset0, Object length0, @Cached(value="createGetIteratorMethod()") GetMethodNode getIteratorMethodNode, @Cached(value="createBinaryProfile()") ConditionProfile isIterableProfile, @Cached(value="createWriteOwn()") WriteElementNode writeOwnNode, @Cached(value="createCall()") JSFunctionCallNode iteratorCallNode, @Cached(value="create()") IsJSObjectNode isObjectNode, @Cached(value="create(getContext())") IteratorStepNode iteratorStepNode, @Cached(value="create(getContext())") IteratorValueNode getIteratorValueNode, @Cached(value="createGetLength()") JSGetLengthNode getLengthNode, @Cached(value="create(getContext())") ReadElementNode readNode, @Cached(value="create(NEXT, getContext())") PropertyGetNode getNextMethodNode, @Cached(value="create()") BranchProfile growProfile) {
        assert (JSRuntime.isObject(object) && !JSArrayBufferView.isJSArrayBufferView(object) && !JSAbstractBuffer.isJSAbstractBuffer(object));
        DynamicObject proto = this.getPrototypeFromConstructorView(newTarget);
        assert (JSRuntime.isObject(proto));
        Object usingIterator = getIteratorMethodNode.executeWithTarget(object);
        if (isIterableProfile.profile(usingIterator != Undefined.instance)) {
            SimpleArrayList<Object> values = JSConstructTypedArrayNode.iterableToList(object, usingIterator, iteratorCallNode, isObjectNode, iteratorStepNode, getIteratorValueNode, getNextMethodNode, this, growProfile);
            int len = values.size();
            DynamicObject arrayBuffer = this.createTypedArrayBuffer(len);
            TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer(), false);
            DynamicObject obj = this.integerIndexObjectCreate(arrayBuffer, typedArray, 0, len, proto);
            for (int k = 0; k < len; ++k) {
                Object kValue = values.get(k);
                writeOwnNode.executeWithTargetAndIndexAndValue((Object)obj, k, kValue);
            }
            return obj;
        }
        long len = getLengthNode.executeLong(object);
        DynamicObject arrayBuffer = this.createTypedArrayBuffer(len);
        assert (len <= Integer.MAX_VALUE);
        TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer(), false);
        DynamicObject obj = this.integerIndexObjectCreate(arrayBuffer, typedArray, 0, (int)len, proto);
        int k = 0;
        while ((long)k < len) {
            Object kValue = readNode.executeWithTargetAndIndex((Object)object, k);
            writeOwnNode.executeWithTargetAndIndexAndValue((Object)obj, k, kValue);
            ++k;
        }
        return obj;
    }

    private static SimpleArrayList<Object> iterableToList(DynamicObject object, Object usingIterator, JSFunctionCallNode iteratorCallNode, IsJSObjectNode isObjectNode, IteratorStepNode iteratorStepNode, IteratorValueNode getIteratorValueNode, PropertyGetNode getNextMethodNode, JavaScriptBaseNode origin, BranchProfile growProfile) {
        Object next;
        SimpleArrayList<Object> values = new SimpleArrayList<Object>();
        IteratorRecord iterator = GetIteratorNode.getIterator(object, usingIterator, iteratorCallNode, isObjectNode, getNextMethodNode, origin);
        while ((next = iteratorStepNode.execute(iterator)) != Boolean.FALSE) {
            Object nextValue = getIteratorValueNode.execute((DynamicObject)next);
            values.add(nextValue, growProfile);
        }
        return values;
    }

    GetMethodNode createGetIteratorMethod() {
        return GetMethodNode.create(this.getContext(), null, Symbol.SYMBOL_ITERATOR);
    }

    WriteElementNode createWriteOwn() {
        return WriteElementNode.create(this.getContext(), true, true);
    }

    JSGetLengthNode createGetLength() {
        return JSGetLengthNode.create(this.getContext());
    }

    @Specialization(guards={"!isJSFunction(newTarget)"})
    protected DynamicObject doUndefinedNewTarget(Object newTarget, Object arg0, Object byteOffset0, Object length0) {
        throw Errors.createTypeError("newTarget is not a function");
    }

    private DynamicObject createTypedArrayBuffer(long length) {
        assert (length >= 0L);
        int elementSize = this.factory.getBytesPerElement();
        this.checkLengthLimit(length, elementSize);
        int byteLength = JSConstructTypedArrayNode.toByteLength((int)length, elementSize);
        assert (length <= Integer.MAX_VALUE && byteLength >= 0 && byteLength <= Integer.MAX_VALUE);
        if (this.getContext().isOptionDirectByteBuffer()) {
            return JSArrayBuffer.createDirectArrayBuffer(this.getContext(), byteLength);
        }
        return JSArrayBuffer.createArrayBuffer(this.getContext(), byteLength);
    }

    private DynamicObject createTypedArrayWithLength(long length, DynamicObject newTarget) {
        DynamicObject arrayBuffer = this.createTypedArrayBuffer(length);
        TypedArray typedArray = this.factory.createArrayType(this.getContext().isOptionDirectByteBuffer(), false);
        return this.createTypedArray(arrayBuffer, typedArray, 0, (int)length, newTarget);
    }

    private DynamicObject createTypedArray(DynamicObject arrayBuffer, TypedArray typedArray, int offset, int length, DynamicObject newTarget) {
        DynamicObject proto = this.getPrototypeFromConstructorView(newTarget);
        assert (JSRuntime.isObject(proto));
        return this.integerIndexObjectCreate(arrayBuffer, typedArray, offset, length, proto);
    }

    private int checkLengthLimit(long length, int elementSize) {
        if (length > (long)(JSTruffleOptions.MaxTypedArrayLength / elementSize)) {
            this.errorBranch.enter();
            throw this.throwInappropriateLengthError(length);
        }
        return (int)length;
    }

    private static int toByteLength(int length, int elementSize) {
        int byteLength = length * elementSize;
        assert (byteLength >= 0 && byteLength / elementSize == length);
        return byteLength;
    }

    @CompilerDirectives.TruffleBoundary
    private RuntimeException throwInappropriateLengthError(long length) {
        if (JSTruffleOptions.NashornCompatibilityMode) {
            throw Errors.createRangeError("inappropriate array buffer length: " + length);
        }
        if (this.getContext().isOptionV8CompatibilityMode()) {
            throw Errors.createRangeError("Invalid array buffer length");
        }
        throw Errors.createRangeError("Invalid typed array length: " + length);
    }

    private boolean rangeCheck(boolean condition, String message) {
        if (!condition) {
            this.errorBranch.enter();
            throw Errors.createRangeError(message);
        }
        return condition;
    }

    private boolean rangeCheckIsMultipleOfElementSize(boolean condition, String what, String name, int bytesPerElement) {
        if (!condition) {
            this.errorBranch.enter();
            throw JSConstructTypedArrayNode.createRangeErrorNotMultipleOfElementSize(what, name, bytesPerElement);
        }
        return condition;
    }

    @CompilerDirectives.TruffleBoundary
    private static RuntimeException createRangeErrorNotMultipleOfElementSize(String what, String name, int bytesPerElement) {
        return Errors.createRangeError(String.format("%s of %s should be a multiple of %d", what, name, bytesPerElement));
    }

    static abstract class IntegerIndexedObjectCreateNode
    extends JavaScriptBaseNode {
        private final JSContext context;
        private final TypedArrayFactory factory;

        IntegerIndexedObjectCreateNode(JSContext context, TypedArrayFactory factory) {
            this.context = context;
            this.factory = factory;
        }

        abstract DynamicObject execute(DynamicObject var1, TypedArray var2, int var3, int var4, DynamicObject var5);

        @Specialization(guards={"isDefaultPrototype(proto)"})
        DynamicObject doDefaultProto(DynamicObject arrayBuffer, TypedArray typedArray, int offset, int length, DynamicObject proto) {
            assert (!JSArrayBuffer.isDetachedBuffer(arrayBuffer));
            JSObjectFactory objectFactory = typedArray.isDirect() ? this.context.getDirectArrayBufferViewFactory(this.factory) : this.context.getArrayBufferViewFactory(this.factory);
            return JSArrayBufferView.createArrayBufferView(this.context, objectFactory, arrayBuffer, typedArray, offset, length);
        }

        @Specialization(guards={"!isDefaultPrototype(proto)", "proto == cachedProto"}, limit="1")
        DynamicObject doCachedProto(DynamicObject arrayBuffer, TypedArray typedArray, int offset, int length, DynamicObject proto, @Cached(value="proto") DynamicObject cachedProto, @Cached(value="makeObjectFactory(cachedProto, typedArray)") JSObjectFactory objectFactory) {
            return JSArrayBufferView.createArrayBufferView(this.context, objectFactory, arrayBuffer, typedArray, offset, length);
        }

        @Specialization(guards={"!isDefaultPrototype(proto)"}, replaces={"doCachedProto"})
        DynamicObject doUncachedProto(DynamicObject arrayBuffer, TypedArray typedArray, int offset, int length, DynamicObject proto) {
            return JSArrayBufferView.createArrayBufferView(this.context, this.makeObjectFactory(proto, typedArray), arrayBuffer, typedArray, offset, length);
        }

        boolean isDefaultPrototype(DynamicObject proto) {
            return proto == this.context.getRealm().getArrayBufferViewPrototype(this.factory);
        }

        @CompilerDirectives.TruffleBoundary
        JSObjectFactory makeObjectFactory(DynamicObject prototype, TypedArray typedArray) {
            return JSObjectFactory.createBound(this.context, prototype, JSArrayBufferView.makeInitialArrayBufferViewShape(this.context, prototype, typedArray.isDirect()).createFactory());
        }
    }
}

