/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class FloorNode
extends MathOperation {
    public FloorNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static int floor(int a) {
        return a;
    }

    @Specialization(rewriteOn={SlowPathException.class})
    protected int floorMightReturnInt(Object a, @Cached(value="createBinaryProfile()") ConditionProfile smaller) throws SlowPathException {
        double d = this.toDouble(a);
        if (Double.isNaN(d) || JSRuntime.isNegativeZero(d) || d < -2.147483648E9 || d > 2.147483647E9) {
            throw JSNodeUtil.slowPathException();
        }
        int i = (int)d;
        return smaller.profile(d < (double)i) ? i - 1 : i;
    }

    @Specialization
    protected double floorReturnsDouble(Object a, @Cached(value="createBinaryProfile()") ConditionProfile isNaN, @Cached(value="createBinaryProfile()") ConditionProfile isNegativeZero, @Cached(value="createBinaryProfile()") ConditionProfile fitsSafeLong, @Cached(value="createBinaryProfile()") ConditionProfile smaller) {
        double d = this.toDouble(a);
        if (isNaN.profile(Double.isNaN(d))) {
            return Double.NaN;
        }
        if (isNegativeZero.profile(JSRuntime.isNegativeZero(d))) {
            return -0.0;
        }
        if (fitsSafeLong.profile(JSRuntime.isSafeInteger(d))) {
            long i = (long)d;
            return smaller.profile(d < (double)i) ? (double)(i - 1L) : (double)i;
        }
        return FloorNode.mathFloor(d);
    }

    @CompilerDirectives.TruffleBoundary
    private static double mathFloor(double d) {
        return Math.floor(d);
    }
}

