/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.EnumerateNode;
import com.oracle.truffle.js.nodes.access.GetAsyncIteratorNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=GetAsyncIteratorNode.class)
public final class GetAsyncIteratorNodeGen
extends GetAsyncIteratorNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private EnumerateNode foreignIterable_enumerateNode_;
    @Node.Child
    private JSFunctionCallNode getIterator_methodCallNode_;
    @Node.Child
    private IsJSObjectNode getIterator_isObjectNode_;

    private GetAsyncIteratorNodeGen(JSContext context, JavaScriptNode objectNode) {
        super(context, objectNode);
    }

    @Override
    public IteratorRecord execute(Object objectNodeValue) {
        TruffleObject objectNodeValue_;
        int state = this.state_;
        if ((state & 1) != 0 && objectNodeValue instanceof TruffleObject && JSGuards.isForeignObject(objectNodeValue_ = (TruffleObject)objectNodeValue)) {
            return this.doForeignIterable(objectNodeValue_, this.foreignIterable_enumerateNode_);
        }
        if ((state & 2) != 0 && !JSGuards.isForeignObject(objectNodeValue)) {
            return this.doGetIterator(objectNodeValue, this.getIterator_methodCallNode_, this.getIterator_isObjectNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(objectNodeValue);
    }

    @Override
    public IteratorRecord execute(VirtualFrame frameValue) {
        TruffleObject objectNodeValue__;
        int state = this.state_;
        Object objectNodeValue_ = this.objectNode.execute(frameValue);
        if ((state & 1) != 0 && objectNodeValue_ instanceof TruffleObject && JSGuards.isForeignObject(objectNodeValue__ = (TruffleObject)objectNodeValue_)) {
            return this.doForeignIterable(objectNodeValue__, this.foreignIterable_enumerateNode_);
        }
        if ((state & 2) != 0 && !JSGuards.isForeignObject(objectNodeValue_)) {
            return this.doGetIterator(objectNodeValue_, this.getIterator_methodCallNode_, this.getIterator_isObjectNode_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(objectNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private IteratorRecord executeAndSpecialize(Object objectNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            TruffleObject objectNodeValue_;
            if (objectNodeValue instanceof TruffleObject && JSGuards.isForeignObject(objectNodeValue_ = (TruffleObject)objectNodeValue)) {
                this.foreignIterable_enumerateNode_ = (EnumerateNode)super.insert((Node)this.createEnumerateValues());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                IteratorRecord iteratorRecord = this.doForeignIterable(objectNodeValue_, this.foreignIterable_enumerateNode_);
                return iteratorRecord;
            }
            if (!JSGuards.isForeignObject(objectNodeValue)) {
                this.getIterator_methodCallNode_ = (JSFunctionCallNode)super.insert((Node)JSFunctionCallNode.createCall());
                this.getIterator_isObjectNode_ = (IsJSObjectNode)super.insert((Node)IsJSObjectNode.create());
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                IteratorRecord iteratorRecord = this.doGetIterator(objectNodeValue, this.getIterator_methodCallNode_, this.getIterator_isObjectNode_);
                return iteratorRecord;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.objectNode}, new Object[]{objectNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<JavaScriptBaseNode>> cached;
        Object[] data = new Object[3];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doForeignIterable";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<JavaScriptBaseNode>>();
            cached.add(Arrays.asList(this.foreignIterable_enumerateNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doGetIterator";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.getIterator_methodCallNode_, this.getIterator_isObjectNode_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static GetAsyncIteratorNode create(JSContext context, JavaScriptNode objectNode) {
        return new GetAsyncIteratorNodeGen(context, objectNode);
    }
}

