/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;

public abstract class JSToNumericNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSToNumberNode toNumberNode;
    @Node.Child
    private JSToPrimitiveNode toPrimitiveNode;

    public abstract Object execute(Object var1);

    protected JSToNumericNode() {
    }

    public static JSToNumericNode create() {
        return JSToNumericNodeGen.create();
    }

    public static JavaScriptNode create(JavaScriptNode child) {
        Object constantOperand;
        if (child.isResultAlwaysOfType(Number.class) || child.isResultAlwaysOfType(Integer.TYPE) || child.isResultAlwaysOfType(Double.TYPE)) {
            return child;
        }
        if (child instanceof JSConstantNode && (constantOperand = ((JSConstantNode)child).getValue()) != null && !(constantOperand instanceof Symbol) && JSRuntime.isJSPrimitive(constantOperand)) {
            if (constantOperand instanceof BigInt) {
                return JSConstantNode.createBigInt((BigInt)constantOperand);
            }
            return JSConstantNode.createInt(JSRuntime.toInt32(constantOperand));
        }
        return JSToNumericNodeGen.JSToNumericWrapperNodeGen.create(child);
    }

    @Specialization
    protected static int doInt(int value) {
        return value;
    }

    @Specialization
    protected static double doDouble(double value) {
        return value;
    }

    @Specialization
    protected Object doBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"isJSBigInt(value)"})
    protected Object doJSBigInt(Object value) {
        return this.toPrimitive(value);
    }

    @Specialization(guards={"!isJSBigInt(value)"})
    protected Object doOther(Object value) {
        Object primValue = this.toPrimitive(value);
        if (JSRuntime.isBigInt(primValue)) {
            return primValue;
        }
        return this.toNumber(primValue);
    }

    private Number toNumber(Object value) {
        if (this.toNumberNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toNumberNode = (JSToNumberNode)this.insert(JSToNumberNode.create());
        }
        return this.toNumberNode.executeNumber(value);
    }

    private Object toPrimitive(Object value) {
        if (this.toPrimitiveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toPrimitiveNode = (JSToPrimitiveNode)this.insert(JSToPrimitiveNode.createHintNumber());
        }
        return this.toPrimitiveNode.execute(value);
    }

    public static abstract class JSToNumericWrapperNode
    extends JSUnaryNode {
        @Node.Child
        private JSToNumericNode toNumericNode;

        protected JSToNumericWrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        @Specialization
        protected Object doDefault(Object value) {
            if (this.toNumericNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumericNode = (JSToNumericNode)this.insert(JSToNumericNode.create());
            }
            return this.toNumericNode.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized() {
            return JSToNumericNode.create(JSToNumericWrapperNode.cloneUninitialized(this.getOperand()));
        }

        @Override
        public String expressionToString() {
            return this.getOperand().expressionToString();
        }
    }
}

