/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.control.ResumableNode;
import com.oracle.truffle.js.nodes.control.StatementNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Undefined;

@NodeInfo(shortName="try-finally")
public class TryFinallyNode
extends StatementNode
implements ResumableNode {
    @Node.Child
    private JavaScriptNode tryBlock;
    @Node.Child
    private JavaScriptNode finallyBlock;
    private final BranchProfile catchBranch = BranchProfile.create();
    private final ValueProfile typeProfile = ValueProfile.createClassProfile();

    TryFinallyNode(JavaScriptNode tryBlock, JavaScriptNode finallyBlock) {
        this.tryBlock = tryBlock;
        this.finallyBlock = finallyBlock;
    }

    public static JavaScriptNode create(JavaScriptNode tryBlock, JavaScriptNode finallyBlock) {
        return new TryFinallyNode(tryBlock, finallyBlock);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return TryFinallyNode.create(TryFinallyNode.cloneUninitialized(this.tryBlock), TryFinallyNode.cloneUninitialized(this.finallyBlock));
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result;
        boolean abort = false;
        try {
            result = this.tryBlock.execute(frame);
        }
        catch (ControlFlowException cfe) {
            throw cfe;
        }
        catch (Throwable ex) {
            this.catchBranch.enter();
            if (!TryCatchNode.shouldCatch(ex, this.typeProfile)) {
                abort = true;
            }
            throw ex;
        }
        finally {
            if (!abort) {
                this.finallyBlock.execute(frame);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object resume(VirtualFrame frame) {
        Object state = this.getStateAndReset(frame);
        if (state == Undefined.instance) {
            Object result;
            boolean yieldedInTry = false;
            boolean abort = false;
            Throwable ex = null;
            try {
                try {
                    result = this.tryBlock.execute(frame);
                }
                catch (YieldException e) {
                    yieldedInTry = true;
                    throw e;
                }
                catch (ControlFlowException cfe) {
                    ex = cfe;
                    throw cfe;
                }
                catch (Throwable ex2) {
                    this.catchBranch.enter();
                    if (!TryCatchNode.shouldCatch(ex2, this.typeProfile)) {
                        abort = true;
                    }
                    ex = ex2;
                    throw ex2;
                }
            }
            finally {
                if (!abort && !yieldedInTry) {
                    try {
                        this.finallyBlock.execute(frame);
                    }
                    catch (YieldException e) {
                        this.setState(frame, ex);
                        throw e;
                    }
                }
            }
            return result;
        }
        try {
            this.finallyBlock.execute(frame);
        }
        catch (YieldException e) {
            this.setState(frame, state);
            throw e;
        }
        if (state != null) {
            JSRuntime.rethrow((Throwable)state);
        }
        return EMPTY;
    }
}

