/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.EcmaAgent;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class JSAgent
implements EcmaAgent {
    private static final AtomicInteger signifierGenerator = new AtomicInteger(0);
    private final int signifier = signifierGenerator.incrementAndGet();
    private final boolean canBlock;
    private boolean inAtomicSection;
    private boolean inCriticalSection;
    private final Deque<DynamicObject> promiseJobsQueue;
    private int interopCallStackDepth;

    public JSAgent(boolean canBlock) {
        this.canBlock = canBlock;
        this.promiseJobsQueue = new ArrayDeque<DynamicObject>(4);
    }

    public abstract void wakeAgent(int var1);

    public int getSignifier() {
        return this.signifier;
    }

    public boolean canBlock() {
        return this.canBlock;
    }

    public boolean inCriticalSection() {
        return this.inCriticalSection;
    }

    public void criticalSectionEnter(JSAgentWaiterList.JSAgentWaiterListEntry wl) {
        assert (!this.inCriticalSection);
        wl.lock();
        this.inCriticalSection = true;
    }

    public void criticalSectionLeave(JSAgentWaiterList.JSAgentWaiterListEntry wl) {
        assert (this.inCriticalSection);
        this.inCriticalSection = false;
        wl.unlock();
    }

    public void atomicSectionEnter(DynamicObject target) {
        assert (!this.inAtomicSection);
        assert (JSArrayBufferView.isJSArrayBufferView(target));
        DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer(target, JSArrayBufferView.isJSArrayBufferView(target));
        JSAgentWaiterList waiterList = JSSharedArrayBuffer.getWaiterList(arrayBuffer);
        waiterList.lock();
        this.inAtomicSection = true;
    }

    public void atomicSectionLeave(DynamicObject target) {
        assert (this.inAtomicSection);
        assert (JSArrayBufferView.isJSArrayBufferView(target));
        DynamicObject arrayBuffer = JSArrayBufferView.getArrayBuffer(target, JSArrayBufferView.isJSArrayBufferView(target));
        JSAgentWaiterList waiterList = JSSharedArrayBuffer.getWaiterList(arrayBuffer);
        this.inAtomicSection = false;
        waiterList.unlock();
    }

    @CompilerDirectives.TruffleBoundary
    public final void enqueuePromiseJob(DynamicObject job) {
        this.promiseJobsQueue.push(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public final void processAllPromises() {
        try {
            while (!this.promiseJobsQueue.isEmpty()) {
                DynamicObject nextJob = this.promiseJobsQueue.pollLast();
                if (!JSFunction.isJSFunction(nextJob)) continue;
                JSRealm functionRealm = JSFunction.getRealm(nextJob);
                Object prev = functionRealm.getTruffleContext().enter();
                try {
                    JSFunction.call(nextJob, Undefined.instance, JSArguments.EMPTY_ARGUMENTS_ARRAY);
                }
                finally {
                    functionRealm.getTruffleContext().leave(prev);
                }
            }
        }
        finally {
            this.promiseJobsQueue.clear();
        }
    }

    public final void interopBoundaryEnter() {
        ++this.interopCallStackDepth;
    }

    public final boolean interopBoundaryExit() {
        return --this.interopCallStackDepth == 0;
    }
}

