/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

public abstract class TypedArray
extends ScriptArray {
    private final boolean offset;
    private final int bytesPerElement;
    private final String name;
    private final TypedArrayFactory factory;
    static final int INT8_BYTES_PER_ELEMENT = 1;
    static final int UINT8_BYTES_PER_ELEMENT = 1;
    static final int INT16_BYTES_PER_ELEMENT = 2;
    static final int UINT16_BYTES_PER_ELEMENT = 2;
    static final int INT32_BYTES_PER_ELEMENT = 4;
    static final int UINT32_BYTES_PER_ELEMENT = 4;
    static final int BIGINT64_BYTES_PER_ELEMENT = 8;
    static final int BIGUINT64_BYTES_PER_ELEMENT = 8;
    static final int FLOAT32_BYTES_PER_ELEMENT = 4;
    static final int FLOAT64_BYTES_PER_ELEMENT = 8;
    static final BufferAccess NATIVE_ORDER = new SunMiscUnsafeNativeOrderBufferAccess();
    private static final BufferAccess LITTLE_ENDIAN_ORDER = new LittleEndianBufferAccess();
    private static final BufferAccess BIG_ENDIAN_ORDER = new BigEndianBufferAccess();

    protected TypedArray(TypedArrayFactory factory, boolean offset) {
        this.offset = offset;
        this.bytesPerElement = factory.getBytesPerElement();
        this.name = factory.getName();
        this.factory = factory;
    }

    @Override
    public final long length(DynamicObject object, boolean condition) {
        return this.lengthInt(object, condition);
    }

    @Override
    public final int lengthInt(DynamicObject object, boolean condition) {
        return JSArrayBufferView.typedArrayGetLength(object, condition);
    }

    @Override
    public final TypedArray setLengthImpl(DynamicObject object, long len, boolean condition, ScriptArray.ProfileHolder profile) {
        return this;
    }

    @Override
    public final long firstElementIndex(DynamicObject object, boolean condition) {
        return 0L;
    }

    @Override
    public final long lastElementIndex(DynamicObject object, boolean condition) {
        return this.length(object, condition) - 1L;
    }

    @Override
    public final long nextElementIndex(DynamicObject object, long index, boolean condition) {
        return index + 1L;
    }

    @Override
    public final long previousElementIndex(DynamicObject object, long index, boolean condition) {
        return index - 1L;
    }

    @Override
    public final Object[] toArray(DynamicObject object) {
        int length = this.lengthInt(object);
        Object[] result = new Object[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.getElement(object, i);
        }
        return result;
    }

    @Override
    public final ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this;
    }

    @Override
    public final boolean hasElement(DynamicObject object, long index, boolean condition) {
        return 0L <= index && index < this.length(object, condition);
    }

    protected static byte[] getByteArray(DynamicObject object, boolean condition) {
        return JSArrayBufferView.typedArrayGetByteArray(object, condition);
    }

    protected static ByteBuffer getByteBuffer(DynamicObject object, boolean condition) {
        return JSArrayBufferView.typedArrayGetByteBuffer(object, condition);
    }

    protected static ByteBuffer withNativeOrder(ByteBuffer buffer) {
        return buffer.duplicate().order(ByteOrder.nativeOrder());
    }

    public final Object getBufferFromTypedArray(DynamicObject object, boolean condition) {
        return this.isDirect() ? TypedArray.getByteBuffer(object, condition) : (Object)TypedArray.getByteArray(object, condition);
    }

    protected final int getOffset(DynamicObject object, boolean condition) {
        if (this.offset) {
            return JSArrayBufferView.typedArrayGetOffset(object, condition);
        }
        return 0;
    }

    public final TypedArrayFactory getFactory() {
        return this.factory;
    }

    public final int bytesPerElement() {
        return this.bytesPerElement;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isHolesType() {
        return false;
    }

    @Override
    public boolean hasHoles(DynamicObject object, boolean condition) {
        return false;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        throw Errors.unsupported("cannot removeRange() on TypedArray");
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long atOffset, int size) {
        throw Errors.unsupported("cannot addRange() on TypedArray");
    }

    @Override
    public boolean isSealed() {
        return false;
    }

    @Override
    public boolean isFrozen() {
        return false;
    }

    @Override
    public boolean isLengthNotWritable() {
        return false;
    }

    @Override
    public ScriptArray seal() {
        return this;
    }

    @Override
    public ScriptArray freeze() {
        return this;
    }

    @Override
    public ScriptArray setLengthNotWritable() {
        return this;
    }

    @Override
    public ScriptArray preventExtensions() {
        return this;
    }

    @Override
    public final boolean isStatelessType() {
        return true;
    }

    public boolean isDirect() {
        return false;
    }

    public final boolean hasOffset() {
        return this.offset;
    }

    protected static BufferAccess getBufferAccess(boolean littleEndian) {
        return littleEndian ? LITTLE_ENDIAN_ORDER : BIG_ENDIAN_ORDER;
    }

    protected static ByteBuffer getByteBufferFromBuffer(DynamicObject buffer, boolean littleEndian, boolean condition) {
        ByteBuffer byteBuffer = JSArrayBuffer.getDirectByteBuffer(buffer, condition);
        ByteOrder byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        return byteBuffer.duplicate().order(byteOrder);
    }

    public abstract Object getBufferElement(DynamicObject var1, int var2, boolean var3, boolean var4);

    public abstract void setBufferElement(DynamicObject var1, int var2, boolean var3, boolean var4, Object var5);

    public static TypedArrayFactory[] factories(JSContext context) {
        if (context.getContextOptions().isBigInt()) {
            return TypedArrayFactory.FACTORIES;
        }
        return TypedArrayFactory.getNoBigIntFactories();
    }

    protected static final class ByteBufferNativeOrderBufferAccess
    extends BufferAccess {
        protected ByteBufferNativeOrderBufferAccess() {
        }

        @Override
        public int getInt8(byte[] buffer, int offset, int index, int bytesPerElement) {
            return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).get(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement));
        }

        @Override
        public int getInt16(byte[] buffer, int offset, int index, int bytesPerElement) {
            return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getShort(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement));
        }

        @Override
        public int getInt32(byte[] buffer, int offset, int index, int bytesPerElement) {
            return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getInt(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement));
        }

        @Override
        public float getFloat(byte[] buffer, int offset, int index, int bytesPerElement) {
            return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getFloat(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement));
        }

        @Override
        public double getDouble(byte[] buffer, int offset, int index, int bytesPerElement) {
            return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getDouble(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement));
        }

        @Override
        public long getInt64(byte[] buffer, int offset, int index, int bytesPerElement) {
            return ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).getLong(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement));
        }

        @Override
        public void putInt8(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).put(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement), (byte)value);
        }

        @Override
        public void putInt16(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putShort(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement), (short)value);
        }

        @Override
        public void putInt32(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putInt(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement), value);
        }

        @Override
        public void putFloat(byte[] buffer, int offset, int index, int bytesPerElement, float value) {
            ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putFloat(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement), value);
        }

        @Override
        public void putDouble(byte[] buffer, int offset, int index, int bytesPerElement, double value) {
            ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putDouble(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement), value);
        }

        @Override
        public void putInt64(byte[] buffer, int offset, int index, int bytesPerElement, long value) {
            ByteBuffer.wrap(buffer).order(ByteOrder.nativeOrder()).putLong(ByteBufferNativeOrderBufferAccess.byteIndex(offset, index, bytesPerElement), value);
        }

        private static int byteIndex(int offset, int index, int bytesPerElement) {
            return offset + index * bytesPerElement;
        }
    }

    protected static final class SunMiscUnsafeNativeOrderBufferAccess
    extends BufferAccess {
        private static final Unsafe UNSAFE = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

            @Override
            public Unsafe run() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException securityException) {
                    try {
                        Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                        theUnsafeInstance.setAccessible(true);
                        return (Unsafe)theUnsafeInstance.get(Unsafe.class);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
                    }
                }
            }
        });

        protected SunMiscUnsafeNativeOrderBufferAccess() {
        }

        @Override
        public int getInt8(byte[] buffer, int offset, int index, int bytesPerElement) {
            return UNSAFE.getByte(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement));
        }

        @Override
        public int getInt16(byte[] buffer, int offset, int index, int bytesPerElement) {
            return UNSAFE.getShort(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement));
        }

        @Override
        public int getInt32(byte[] buffer, int offset, int index, int bytesPerElement) {
            return UNSAFE.getInt(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement));
        }

        @Override
        public long getInt64(byte[] buffer, int offset, int index, int bytesPerElement) {
            return UNSAFE.getLong(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement));
        }

        @Override
        public float getFloat(byte[] buffer, int offset, int index, int bytesPerElement) {
            return UNSAFE.getFloat(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement));
        }

        @Override
        public double getDouble(byte[] buffer, int offset, int index, int bytesPerElement) {
            return UNSAFE.getDouble(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement));
        }

        @Override
        public void putInt8(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            UNSAFE.putByte(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement), (byte)value);
        }

        @Override
        public void putInt16(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            UNSAFE.putShort(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement), (short)value);
        }

        @Override
        public void putInt32(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            UNSAFE.putInt(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement), value);
        }

        @Override
        public void putInt64(byte[] buffer, int offset, int index, int bytesPerElement, long value) {
            UNSAFE.putLong(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement), value);
        }

        @Override
        public void putFloat(byte[] buffer, int offset, int index, int bytesPerElement, float value) {
            UNSAFE.putFloat(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement), value);
        }

        @Override
        public void putDouble(byte[] buffer, int offset, int index, int bytesPerElement, double value) {
            UNSAFE.putDouble(buffer, SunMiscUnsafeNativeOrderBufferAccess.offset(offset, index, bytesPerElement), value);
        }

        private static long offset(int offset, int index, int bytesPerElement) {
            long byteIndex = (long)offset + (long)index * (long)bytesPerElement;
            return byteIndex * (long)Unsafe.ARRAY_BYTE_INDEX_SCALE + (long)Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
    }

    protected static final class BigEndianBufferAccess
    extends NormalBufferAccess {
        protected BigEndianBufferAccess() {
        }

        @Override
        protected int b(int bytePos, int size) {
            return size - 1 - bytePos;
        }
    }

    protected static final class LittleEndianBufferAccess
    extends NormalBufferAccess {
        protected LittleEndianBufferAccess() {
        }

        @Override
        protected int b(int bytePos, int size) {
            return bytePos;
        }
    }

    protected static abstract class NormalBufferAccess
    extends BufferAccess {
        protected NormalBufferAccess() {
        }

        private static int makeInt16(byte b0, byte b1) {
            return b1 << 8 | b0 & 0xFF;
        }

        private static int makeInt32(byte b0, byte b1, byte b2, byte b3) {
            return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
        }

        private static long makeInt64(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
            return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
        }

        @Override
        public final int getInt8(byte[] buffer, int offset, int index, int bytesPerElement) {
            int byteIndex = offset + index * bytesPerElement;
            return buffer[byteIndex];
        }

        @Override
        public final int getInt16(byte[] buffer, int offset, int index, int bytesPerElement) {
            int byteIndex = offset + index * bytesPerElement;
            return NormalBufferAccess.makeInt16(buffer[byteIndex + this.b(0, 2)], buffer[byteIndex + this.b(1, 2)]);
        }

        @Override
        public final int getInt32(byte[] buffer, int offset, int index, int bytesPerElement) {
            int byteIndex = offset + index * bytesPerElement;
            return NormalBufferAccess.makeInt32(buffer[byteIndex + this.b(0, 4)], buffer[byteIndex + this.b(1, 4)], buffer[byteIndex + this.b(2, 4)], buffer[byteIndex + this.b(3, 4)]);
        }

        @Override
        public final float getFloat(byte[] buffer, int offset, int index, int bytesPerElement) {
            return Float.intBitsToFloat(this.getInt32(buffer, offset, index, bytesPerElement));
        }

        @Override
        public final double getDouble(byte[] buffer, int offset, int index, int bytesPerElement) {
            int byteIndex = offset + index * bytesPerElement;
            return Double.longBitsToDouble(NormalBufferAccess.makeInt64(buffer[byteIndex + this.b(0, 8)], buffer[byteIndex + this.b(1, 8)], buffer[byteIndex + this.b(2, 8)], buffer[byteIndex + this.b(3, 8)], buffer[byteIndex + this.b(4, 8)], buffer[byteIndex + this.b(5, 8)], buffer[byteIndex + this.b(6, 8)], buffer[byteIndex + this.b(7, 8)]));
        }

        @Override
        public long getInt64(byte[] buffer, int offset, int index, int bytesPerElement) {
            int byteIndex = offset + index * bytesPerElement;
            return NormalBufferAccess.makeInt64(buffer[byteIndex + this.b(0, 8)], buffer[byteIndex + this.b(1, 8)], buffer[byteIndex + this.b(2, 8)], buffer[byteIndex + this.b(3, 8)], buffer[byteIndex + this.b(4, 8)], buffer[byteIndex + this.b(5, 8)], buffer[byteIndex + this.b(6, 8)], buffer[byteIndex + this.b(7, 8)]);
        }

        @Override
        public final void putInt8(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            int byteIndex = offset + index * bytesPerElement;
            buffer[byteIndex] = (byte)value;
        }

        @Override
        public final void putInt16(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            int byteIndex = offset + index * bytesPerElement;
            buffer[byteIndex + this.b((int)0, (int)2)] = (byte)value;
            buffer[byteIndex + this.b((int)1, (int)2)] = (byte)(value >> 8);
        }

        @Override
        public final void putInt32(byte[] buffer, int offset, int index, int bytesPerElement, int value) {
            int byteIndex = offset + index * bytesPerElement;
            buffer[byteIndex + this.b((int)0, (int)4)] = (byte)value;
            buffer[byteIndex + this.b((int)1, (int)4)] = (byte)(value >> 8);
            buffer[byteIndex + this.b((int)2, (int)4)] = (byte)(value >> 16);
            buffer[byteIndex + this.b((int)3, (int)4)] = (byte)(value >> 24);
        }

        @Override
        public final void putInt64(byte[] buffer, int offset, int index, int bytesPerElement, long value) {
            int byteIndex = offset + index * bytesPerElement;
            buffer[byteIndex + this.b((int)0, (int)8)] = (byte)value;
            buffer[byteIndex + this.b((int)1, (int)8)] = (byte)(value >> 8);
            buffer[byteIndex + this.b((int)2, (int)8)] = (byte)(value >> 16);
            buffer[byteIndex + this.b((int)3, (int)8)] = (byte)(value >> 24);
            buffer[byteIndex + this.b((int)4, (int)8)] = (byte)(value >> 32);
            buffer[byteIndex + this.b((int)5, (int)8)] = (byte)(value >> 40);
            buffer[byteIndex + this.b((int)6, (int)8)] = (byte)(value >> 48);
            buffer[byteIndex + this.b((int)7, (int)8)] = (byte)(value >> 56);
        }

        @Override
        public final void putFloat(byte[] buffer, int offset, int index, int bytesPerElement, float value) {
            this.putInt32(buffer, offset, index, bytesPerElement, Float.floatToIntBits(value));
        }

        @Override
        public final void putDouble(byte[] buffer, int offset, int index, int bytesPerElement, double value) {
            this.putInt64(buffer, offset, index, bytesPerElement, Double.doubleToRawLongBits(value));
        }

        protected abstract int b(int var1, int var2);
    }

    public static abstract class BufferAccess {
        public abstract int getInt8(byte[] var1, int var2, int var3, int var4);

        public final int getUint8(byte[] buffer, int offset, int index, int bytesPerElement) {
            return this.getInt8(buffer, offset, index, bytesPerElement) & 0xFF;
        }

        public abstract int getInt16(byte[] var1, int var2, int var3, int var4);

        public final int getUint16(byte[] buffer, int offset, int index, int bytesPerElement) {
            return this.getInt16(buffer, offset, index, bytesPerElement) & 0xFFFF;
        }

        public abstract int getInt32(byte[] var1, int var2, int var3, int var4);

        public final long getUint32(byte[] buffer, int offset, int index, int bytesPerElement) {
            return (long)this.getInt32(buffer, offset, index, bytesPerElement) & 0xFFFFFFFFL;
        }

        public abstract float getFloat(byte[] var1, int var2, int var3, int var4);

        public abstract double getDouble(byte[] var1, int var2, int var3, int var4);

        public abstract long getInt64(byte[] var1, int var2, int var3, int var4);

        public abstract void putInt8(byte[] var1, int var2, int var3, int var4, int var5);

        public abstract void putInt16(byte[] var1, int var2, int var3, int var4, int var5);

        public abstract void putInt32(byte[] var1, int var2, int var3, int var4, int var5);

        public abstract void putFloat(byte[] var1, int var2, int var3, int var4, float var5);

        public abstract void putDouble(byte[] var1, int var2, int var3, int var4, double var5);

        public abstract void putInt64(byte[] var1, int var2, int var3, int var4, long var5);
    }

    public static final class DirectFloat64Array
    extends TypedFloatArray<ByteBuffer> {
        DirectFloat64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public double getDoubleImpl(ByteBuffer buffer, int offset, int index) {
            return DirectFloat64Array.withNativeOrder(buffer).getDouble(offset + index * 8);
        }

        @Override
        public void setDoubleImpl(ByteBuffer buffer, int offset, int index, double value) {
            DirectFloat64Array.withNativeOrder(buffer).putDouble(offset + index * 8, value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return DirectFloat64Array.getByteBufferFromBuffer(buffer, littleEndian, condition).getDouble(index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectFloat64Array.getByteBufferFromBuffer(buffer, littleEndian, condition).putDouble(index, JSRuntime.doubleValue((Number)value));
        }
    }

    public static final class Float64Array
    extends TypedFloatArray<byte[]> {
        Float64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public double getDoubleImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getDouble(array, offset, index, 8);
        }

        @Override
        public void setDoubleImpl(byte[] array, int offset, int index, double value) {
            NATIVE_ORDER.putDouble(array, offset, index, 8, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return Float64Array.getBufferAccess(littleEndian).getDouble(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Float64Array.getBufferAccess(littleEndian).putDouble(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.doubleValue((Number)value));
        }
    }

    public static final class DirectFloat32Array
    extends TypedFloatArray<ByteBuffer> {
        DirectFloat32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public double getDoubleImpl(ByteBuffer buffer, int offset, int index) {
            return DirectFloat32Array.withNativeOrder(buffer).getFloat(offset + index * 4);
        }

        @Override
        public void setDoubleImpl(ByteBuffer buffer, int offset, int index, double value) {
            DirectFloat32Array.withNativeOrder(buffer).putFloat(offset + index * 4, (float)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return (double)DirectFloat32Array.getByteBufferFromBuffer(buffer, littleEndian, condition).getFloat(index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectFloat32Array.getByteBufferFromBuffer(buffer, littleEndian, condition).putFloat(index, JSRuntime.floatValue((Number)value));
        }
    }

    public static final class Float32Array
    extends TypedFloatArray<byte[]> {
        Float32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public double getDoubleImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getFloat(array, offset, index, 4);
        }

        @Override
        public void setDoubleImpl(byte[] array, int offset, int index, double value) {
            NATIVE_ORDER.putFloat(array, offset, index, 4, (float)value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return (double)Float32Array.getBufferAccess(littleEndian).getFloat(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Float32Array.getBufferAccess(littleEndian).putFloat(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.floatValue((Number)value));
        }
    }

    public static abstract class TypedFloatArray<T>
    extends TypedArray {
        protected TypedFloatArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public final Object getElement(DynamicObject object, long index, boolean condition) {
            if (this.hasElement(object, index, condition)) {
                return this.getDouble(object, (int)index, condition);
            }
            return Undefined.instance;
        }

        @Override
        public Object getElementInBounds(DynamicObject object, long index, boolean condition) {
            assert (this.hasElement(object, index, condition));
            return this.getDouble(object, (int)index, condition);
        }

        @Override
        public final TypedFloatArray<T> setElementImpl(DynamicObject object, long index, Object value, boolean strict, boolean condition) {
            if (this.hasElement(object, index, condition)) {
                this.setDouble(object, (int)index, JSRuntime.toDouble(value), condition);
            }
            return this;
        }

        private T getBufferFromTypedArrayT(DynamicObject object, boolean condition) {
            return (T)super.getBufferFromTypedArray(object, condition);
        }

        public final double getDouble(DynamicObject object, int index, boolean condition) {
            return this.getDoubleImpl(this.getBufferFromTypedArrayT(object, condition), this.getOffset(object, condition), index);
        }

        public final void setDouble(DynamicObject object, int index, double value, boolean condition) {
            this.setDoubleImpl(this.getBufferFromTypedArrayT(object, condition), this.getOffset(object, condition), index, value);
        }

        public abstract double getDoubleImpl(T var1, int var2, int var3);

        public abstract void setDoubleImpl(T var1, int var2, int var3, double var4);
    }

    public static final class DirectBigUint64Array
    extends TypedBigIntArray<ByteBuffer> {
        DirectBigUint64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public BigInt getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return BigInt.valueOfUnsigned(DirectBigUint64Array.getByteBufferFromBuffer(buffer, littleEndian, condition).getLong(index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectBigUint64Array.getByteBufferFromBuffer(buffer, littleEndian, condition).putLong(index, JSRuntime.toBigInt(value).longValue());
        }

        @Override
        public BigInt getBigIntImpl(ByteBuffer buffer, int offset, int index) {
            return BigInt.valueOfUnsigned(DirectBigUint64Array.withNativeOrder(buffer).getLong(offset + index * 8));
        }

        @Override
        public void setBigIntImpl(ByteBuffer buffer, int offset, int index, BigInt value) {
            DirectBigUint64Array.withNativeOrder(buffer).putLong(offset + index * 8, value.longValue());
        }
    }

    public static final class BigUint64Array
    extends TypedBigIntArray<byte[]> {
        BigUint64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public BigInt getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return BigInt.valueOfUnsigned(BigUint64Array.getBufferAccess(littleEndian).getInt64(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            BigUint64Array.getBufferAccess(littleEndian).putInt64(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.toBigInt(value).longValue());
        }

        @Override
        public BigInt getBigIntImpl(byte[] buffer, int offset, int index) {
            return BigInt.valueOfUnsigned(NATIVE_ORDER.getInt64(buffer, offset, index, 8));
        }

        @Override
        public void setBigIntImpl(byte[] buffer, int offset, int index, BigInt value) {
            NATIVE_ORDER.putInt64(buffer, offset, index, 8, value.longValue());
        }
    }

    public static final class DirectBigInt64Array
    extends TypedBigIntArray<ByteBuffer> {
        DirectBigInt64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public BigInt getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return BigInt.valueOf(DirectBigInt64Array.getByteBufferFromBuffer(buffer, littleEndian, condition).getLong(index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectBigInt64Array.getByteBufferFromBuffer(buffer, littleEndian, condition).putLong(index, JSRuntime.toBigInt(value).longValue());
        }

        @Override
        public BigInt getBigIntImpl(ByteBuffer buffer, int offset, int index) {
            return BigInt.valueOf(DirectBigInt64Array.withNativeOrder(buffer).getLong(offset + index * 8));
        }

        @Override
        public void setBigIntImpl(ByteBuffer buffer, int offset, int index, BigInt value) {
            DirectBigInt64Array.withNativeOrder(buffer).putLong(offset + index * 8, value.longValue());
        }
    }

    public static final class BigInt64Array
    extends TypedBigIntArray<byte[]> {
        BigInt64Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public BigInt getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return BigInt.valueOf(BigInt64Array.getBufferAccess(littleEndian).getInt64(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            BigInt64Array.getBufferAccess(littleEndian).putInt64(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.toBigInt(value).longValue());
        }

        @Override
        public BigInt getBigIntImpl(byte[] buffer, int offset, int index) {
            return BigInt.valueOf(NATIVE_ORDER.getInt64(buffer, offset, index, 8));
        }

        @Override
        public void setBigIntImpl(byte[] buffer, int offset, int index, BigInt value) {
            NATIVE_ORDER.putInt64(buffer, offset, index, 8, value.longValue());
        }
    }

    public static abstract class TypedBigIntArray<T>
    extends TypedArray {
        protected TypedBigIntArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public Object getElement(DynamicObject object, long index, boolean condition) {
            if (this.hasElement(object, index, condition)) {
                return this.getBigInt(object, (int)index, condition);
            }
            return Undefined.instance;
        }

        @Override
        public Object getElementInBounds(DynamicObject object, long index, boolean condition) {
            assert (this.hasElement(object, index, condition));
            return this.getBigInt(object, (int)index, condition);
        }

        @Override
        public TypedBigIntArray<T> setElementImpl(DynamicObject object, long index, Object value, boolean strict, boolean condition) {
            if (this.hasElement(object, index, condition)) {
                this.setBigInt(object, (int)index, JSRuntime.toBigInt(value), condition);
            }
            return this;
        }

        public final BigInt getBigInt(DynamicObject object, int index, boolean condition) {
            return this.getBigIntImpl(this.getBufferFromTypedArrayT(object, condition), this.getOffset(object, condition), index);
        }

        public final void setBigInt(DynamicObject object, int index, BigInt value, boolean condition) {
            this.setBigIntImpl(this.getBufferFromTypedArrayT(object, condition), this.getOffset(object, condition), index, value);
        }

        private T getBufferFromTypedArrayT(DynamicObject object, boolean condition) {
            return (T)super.getBufferFromTypedArray(object, condition);
        }

        public abstract BigInt getBigIntImpl(T var1, int var2, int var3);

        public abstract void setBigIntImpl(T var1, int var2, int var3, BigInt var4);
    }

    public static final class DirectUint32Array
    extends AbstractUint32Array<ByteBuffer> {
        DirectUint32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return DirectUint32Array.withNativeOrder(buffer).getInt(offset + index * 4);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            DirectUint32Array.withNativeOrder(buffer).putInt(offset + index * 4, value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return DirectUint32Array.toUint32(DirectUint32Array.getByteBufferFromBuffer(buffer, littleEndian, condition).getInt(index));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectUint32Array.getByteBufferFromBuffer(buffer, littleEndian, condition).putInt(index, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Uint32Array
    extends AbstractUint32Array<byte[]> {
        Uint32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getInt32(array, offset, index, 4);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            NATIVE_ORDER.putInt32(array, offset, index, 4, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return Uint32Array.toUint32((int)Uint32Array.getBufferAccess(littleEndian).getUint32(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1));
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Uint32Array.getBufferAccess(littleEndian).putInt32(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.toInt32((Number)value));
        }
    }

    public static abstract class AbstractUint32Array<T>
    extends TypedIntArray<T> {
        private AbstractUint32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public Object getElement(DynamicObject object, long index, boolean condition) {
            if (this.hasElement(object, index, condition)) {
                int value = this.getInt(object, (int)index, condition);
                return AbstractUint32Array.toUint32(value);
            }
            return Undefined.instance;
        }

        protected static Number toUint32(int value) {
            if (value >= 0) {
                return value;
            }
            return (double)((long)value & 0xFFFFFFFFL);
        }

        @Override
        public Object getElementInBounds(DynamicObject object, long index, boolean condition) {
            assert (this.hasElement(object, index, condition));
            return AbstractUint32Array.toUint32(this.getInt(object, (int)index, condition));
        }
    }

    public static final class DirectInt32Array
    extends TypedIntArray<ByteBuffer> {
        DirectInt32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return DirectInt32Array.withNativeOrder(buffer).getInt(offset + index * 4);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            DirectInt32Array.withNativeOrder(buffer).putInt(offset + index * 4, value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return DirectInt32Array.getByteBufferFromBuffer(buffer, littleEndian, condition).getInt(index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectInt32Array.getByteBufferFromBuffer(buffer, littleEndian, condition).putInt(index, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Int32Array
    extends TypedIntArray<byte[]> {
        Int32Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getInt32(array, offset, index, 4);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            NATIVE_ORDER.putInt32(array, offset, index, 4, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return Int32Array.getBufferAccess(littleEndian).getInt32(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Int32Array.getBufferAccess(littleEndian).putInt32(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class DirectUint16Array
    extends TypedIntArray<ByteBuffer> {
        DirectUint16Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return DirectUint16Array.withNativeOrder(buffer).getChar(offset + index * 2);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            DirectUint16Array.withNativeOrder(buffer).putChar(offset + index * 2, (char)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return (int)DirectUint16Array.getByteBufferFromBuffer(buffer, littleEndian, condition).getChar(index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectUint16Array.getByteBufferFromBuffer(buffer, littleEndian, condition).putChar(index, (char)JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Uint16Array
    extends TypedIntArray<byte[]> {
        Uint16Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getUint16(array, offset, index, 2);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            NATIVE_ORDER.putInt16(array, offset, index, 2, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return Uint16Array.getBufferAccess(littleEndian).getUint16(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Uint16Array.getBufferAccess(littleEndian).putInt16(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class DirectInt16Array
    extends TypedIntArray<ByteBuffer> {
        DirectInt16Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return DirectInt16Array.withNativeOrder(buffer).getShort(offset + index * 2);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            DirectInt16Array.withNativeOrder(buffer).putShort(offset + index * 2, (short)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return (int)DirectInt16Array.getByteBufferFromBuffer(buffer, littleEndian, condition).getShort(index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectInt16Array.getByteBufferFromBuffer(buffer, littleEndian, condition).putShort(index, (short)JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Int16Array
    extends TypedIntArray<byte[]> {
        Int16Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getInt16(array, offset, index, 2);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            NATIVE_ORDER.putInt16(array, offset, index, 2, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return Int16Array.getBufferAccess(littleEndian).getInt16(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Int16Array.getBufferAccess(littleEndian).putInt16(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class DirectUint8ClampedArray
    extends AbstractUint8ClampedArray<ByteBuffer> {
        DirectUint8ClampedArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return buffer.get(offset + index * 1) & 0xFF;
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            buffer.put(offset + index * 1, (byte)DirectUint8ClampedArray.uint8Clamp(value));
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return DirectUint8ClampedArray.getByteBufferFromBuffer(buffer, littleEndian, condition).get(index) & 0xFF;
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectUint8ClampedArray.getByteBufferFromBuffer(buffer, littleEndian, condition).put(index, (byte)DirectUint8ClampedArray.uint8Clamp(DirectUint8ClampedArray.toInt(JSRuntime.toDouble((Number)value))));
        }
    }

    public static final class Uint8ClampedArray
    extends AbstractUint8ClampedArray<byte[]> {
        Uint8ClampedArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getUint8(array, offset, index, 1);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            NATIVE_ORDER.putInt8(array, offset, index, 1, Uint8ClampedArray.uint8Clamp(value));
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return Uint8ClampedArray.getBufferAccess(littleEndian).getUint8(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Uint8ClampedArray.getBufferAccess(littleEndian).putInt8(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, Uint8ClampedArray.uint8Clamp(Uint8ClampedArray.toInt(JSRuntime.toDouble((Number)value))));
        }
    }

    public static abstract class AbstractUint8ClampedArray<T>
    extends TypedIntArray<T> {
        private AbstractUint8ClampedArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public TypedIntArray<T> setElementImpl(DynamicObject object, long index, Object value, boolean strict, boolean condition) {
            if (this.hasElement(object, index, condition)) {
                this.setInt(object, (int)index, AbstractUint8ClampedArray.toInt(JSRuntime.toDouble(value)), condition);
            }
            return this;
        }

        protected static int uint8Clamp(int value) {
            return value < 0 ? 0 : (value > 255 ? 255 : value);
        }

        public static int toInt(double value) {
            return (int)JSRuntime.mathRint(value);
        }
    }

    public static final class DirectUint8Array
    extends TypedIntArray<ByteBuffer> {
        DirectUint8Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return buffer.get(offset + index * 1) & 0xFF;
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            buffer.put(offset + index * 1, (byte)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return DirectUint8Array.getByteBufferFromBuffer(buffer, littleEndian, condition).get(index) & 0xFF;
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectUint8Array.getByteBufferFromBuffer(buffer, littleEndian, condition).put(index, (byte)JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Uint8Array
    extends TypedIntArray<byte[]> {
        Uint8Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getUint8(array, offset, index, 1);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            NATIVE_ORDER.putInt8(array, offset, index, 1, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return Uint8Array.getBufferAccess(littleEndian).getUint8(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Uint8Array.getBufferAccess(littleEndian).putInt8(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.toInt32((Number)value));
        }
    }

    public static final class DirectInt8Array
    extends TypedIntArray<ByteBuffer> {
        DirectInt8Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(ByteBuffer buffer, int offset, int index) {
            return buffer.get(offset + index * 1);
        }

        @Override
        public void setIntImpl(ByteBuffer buffer, int offset, int index, int value) {
            buffer.put(offset + index * 1, (byte)value);
        }

        @Override
        public boolean isDirect() {
            return true;
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return (int)DirectInt8Array.getByteBufferFromBuffer(buffer, littleEndian, condition).get(index);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            DirectInt8Array.getByteBufferFromBuffer(buffer, littleEndian, condition).put(index, (byte)JSRuntime.toInt32((Number)value));
        }
    }

    public static final class Int8Array
    extends TypedIntArray<byte[]> {
        Int8Array(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public int getIntImpl(byte[] array, int offset, int index) {
            return NATIVE_ORDER.getInt8(array, offset, index, 1);
        }

        @Override
        public void setIntImpl(byte[] array, int offset, int index, int value) {
            NATIVE_ORDER.putInt8(array, offset, index, 1, value);
        }

        @Override
        public Number getBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition) {
            return Int8Array.getBufferAccess(littleEndian).getInt8(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1);
        }

        @Override
        public void setBufferElement(DynamicObject buffer, int index, boolean littleEndian, boolean condition, Object value) {
            Int8Array.getBufferAccess(littleEndian).putInt8(JSArrayBuffer.getByteArray(buffer, condition), 0, index, 1, JSRuntime.toInt32((Number)value));
        }
    }

    public static abstract class TypedIntArray<T>
    extends TypedArray {
        protected TypedIntArray(TypedArrayFactory factory, boolean offset) {
            super(factory, offset);
        }

        @Override
        public Object getElement(DynamicObject object, long index, boolean condition) {
            if (this.hasElement(object, index, condition)) {
                return this.getInt(object, (int)index, condition);
            }
            return Undefined.instance;
        }

        @Override
        public Object getElementInBounds(DynamicObject object, long index, boolean condition) {
            assert (this.hasElement(object, index, condition));
            return this.getInt(object, (int)index, condition);
        }

        @Override
        public TypedIntArray<T> setElementImpl(DynamicObject object, long index, Object value, boolean strict, boolean condition) {
            if (this.hasElement(object, index, condition)) {
                this.setInt(object, (int)index, JSRuntime.toInt32(value), condition);
            }
            return this;
        }

        public final int getInt(DynamicObject object, int index, boolean condition) {
            return this.getIntImpl(this.getBufferFromTypedArrayT(object, condition), this.getOffset(object, condition), index);
        }

        public final void setInt(DynamicObject object, int index, int value, boolean condition) {
            this.setIntImpl(this.getBufferFromTypedArrayT(object, condition), this.getOffset(object, condition), index, value);
        }

        private T getBufferFromTypedArrayT(DynamicObject object, boolean condition) {
            return (T)super.getBufferFromTypedArray(object, condition);
        }

        public abstract int getIntImpl(T var1, int var2, int var3);

        public abstract void setIntImpl(T var1, int var2, int var3, int var4);
    }
}

