/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Objects;

public final class JavaAccess {
    private static final AccessControlContext NO_PERMISSIONS_CONTEXT = JavaAccess.createNoPermissionsContext();
    private static final String PERMISSION_JAVA_REFLECTION = "truffle.js.JavaReflection";

    private JavaAccess() {
    }

    private static AccessControlContext createNoPermissionsContext() {
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, new Permissions())});
    }

    private static void checkPackageAccessInner(final SecurityManager sm, final String pkgName) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                sm.checkPackageAccess(pkgName);
                return null;
            }
        }, NO_PERMISSIONS_CONTEXT);
    }

    public static void checkPackageAccess(SecurityManager sm, String fullName) {
        Objects.requireNonNull(sm);
        int index = fullName.lastIndexOf(46);
        if (index != -1) {
            String pkgName = fullName.substring(0, index);
            JavaAccess.checkPackageAccessInner(sm, pkgName);
        }
    }

    public static boolean isRestrictedClass(Class<?> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return true;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return false;
        }
        String name = clazz.getName();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return false;
        }
        String pkgName = name.substring(0, i);
        try {
            JavaAccess.checkPackageAccessInner(sm, pkgName);
        }
        catch (SecurityException e) {
            return true;
        }
        return false;
    }

    public static boolean isReflectionClass(Class<?> type) {
        if (type == Class.class || ClassLoader.class.isAssignableFrom(type)) {
            return true;
        }
        String name = type.getName();
        return name.startsWith("java.lang.reflect.") || name.startsWith("java.lang.invoke.") || name.startsWith("java.beans.");
    }

    public static void checkReflectionAccess(Class<?> clazz, boolean isStatic, boolean allowReflection) {
        if (!allowReflection && JavaAccess.isReflectiveCheckNeeded(clazz, isStatic)) {
            throw Errors.createTypeError("Java reflection not allowed");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && JavaAccess.isReflectiveCheckNeeded(clazz, isStatic)) {
            JavaAccess.checkReflectionPermission(sm);
        }
    }

    public static boolean isReflectiveCheckNeeded(Class<?> type, boolean isStatic) {
        if (Proxy.class.isAssignableFrom(type)) {
            if (Proxy.isProxyClass(type)) {
                return isStatic;
            }
            return true;
        }
        return JavaAccess.isReflectionClass(type);
    }

    private static void checkReflectionPermission(SecurityManager sm) {
        sm.checkPermission(new RuntimePermission(PERMISSION_JAVA_REFLECTION));
    }

    public static void checkPackageAccess(Class<?> clazz) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            Class<?> bottomClazz = clazz;
            while (bottomClazz.isArray()) {
                bottomClazz = bottomClazz.getComponentType();
            }
            JavaAccess.checkPackageAccess(sm, bottomClazz.getName());
        }
    }

    private static boolean isAccessiblePackage(Class<?> clazz) {
        try {
            JavaAccess.checkPackageAccess(clazz);
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean isAccessibleClass(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers()) && JavaAccess.isAccessiblePackage(clazz);
    }

    public static boolean isReflectionAllowed(JSContext context) {
        TruffleLanguage.Env env = context.getRealm().getEnv();
        if (env != null && env.isHostLookupAllowed()) {
            try {
                Object found = env.lookupHostSymbol(Class.class.getName());
                if (found != null) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static void checkAccess(Class<?>[] types, JSContext context) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            boolean allowReflection = JavaAccess.isReflectionAllowed(context);
            for (Class<?> type : types) {
                JavaAccess.checkPackageAccess(type);
                JavaAccess.checkReflectionAccess(type, true, allowReflection);
            }
        }
    }
}

