/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import java.util.Arrays;

@ExportLibrary(value=InteropLibrary.class)
public class TruffleReadOnlyKeysArray
implements TruffleObject {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final String[] keys;

    public TruffleReadOnlyKeysArray(String ... keys) {
        this.keys = keys;
        Arrays.sort(this.keys);
    }

    public boolean contains(String key) {
        return Arrays.binarySearch(this.keys, key) >= 0;
    }

    @ExportMessage
    boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.keys.length;
    }

    @ExportMessage
    long getArraySize() {
        return this.keys.length;
    }

    @ExportMessage
    String readArrayElement(long index) throws InvalidArrayIndexException {
        try {
            return this.keys[(int)index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CompilerDirectives.transferToInterpreter();
            throw InvalidArrayIndexException.create((long)index);
        }
    }
}

