/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.nashorn.regexp;

import com.oracle.truffle.regex.chardata.CharacterSet;
import com.oracle.truffle.regex.chardata.UnicodeCharacterProperties;
import com.oracle.truffle.regex.nashorn.parser.Scanner;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;

public final class RegExpScanner
extends Scanner {
    private final StringBuilder sb;
    private final Map<Character, Integer> expected = new HashMap<Character, Integer>();
    private final List<Capture> caps = new LinkedList<Capture>();
    private final Map<String, Integer> namedCaptureGroups = new HashMap<String, Integer>();
    private final Deque<ForwardReference> forwardReferences = new LinkedList<ForwardReference>();
    private int negLookaroundLevel;
    private int negLookaroundGroup;
    private boolean inCharClass = false;
    private boolean inNegativeClass = false;
    private boolean lastAssertionWasLookahead = false;
    private static final String NON_IDENT_ESCAPES = "$^*+(){}[]|\\.?-";
    private static final CharacterSet ID_START = UnicodeCharacterProperties.getUnicodeProperty((String)"ID_Start");
    private static final CharacterSet ID_CONTINUE = UnicodeCharacterProperties.getUnicodeProperty((String)"ID_Continue");

    private RegExpScanner(String string) {
        super(string);
        this.sb = new StringBuilder(this.limit);
        this.reset(0);
        this.expected.put(Character.valueOf(']'), 0);
        this.expected.put(Character.valueOf('}'), 0);
    }

    private void processForwardReferences() {
        while (!this.forwardReferences.isEmpty()) {
            ForwardReference fwdRef = this.forwardReferences.pop();
            int pos = fwdRef.outPos;
            if (fwdRef instanceof IndexedForwardReference) {
                int num = ((IndexedForwardReference)fwdRef).index;
                if (num <= this.caps.size()) continue;
                StringBuilder buffer = new StringBuilder();
                RegExpScanner.octalOrLiteral(Integer.toString(num), buffer);
                this.sb.insert(pos, buffer);
                continue;
            }
            if (!(fwdRef instanceof NamedForwardReference)) continue;
            NamedForwardReference namedFwdRef = (NamedForwardReference)fwdRef;
            String name = namedFwdRef.name;
            if (this.namedCaptureGroups.containsKey(name)) {
                this.sb.insert(pos, "\\" + this.namedCaptureGroups.get(name));
                continue;
            }
            if (this.namedCaptureGroups.isEmpty()) {
                this.sb.insert(pos, String.format("k<%s>", name));
                continue;
            }
            throw new PatternSyntaxException("unresolved named backreference", this.getContents(), namedFwdRef.inPos);
        }
    }

    public static RegExpScanner scan(String string) {
        RegExpScanner scanner = new RegExpScanner(string);
        try {
            scanner.disjunction();
        }
        catch (Exception e) {
            throw new PatternSyntaxException(e.getMessage(), string, scanner.position);
        }
        scanner.processForwardReferences();
        if (scanner.position != string.length()) {
            throw new PatternSyntaxException("cannot parse regular expression", string, scanner.position);
        }
        return scanner;
    }

    final StringBuilder getStringBuilder() {
        return this.sb;
    }

    public String getJavaPattern() {
        return this.sb.toString();
    }

    private boolean commit(int n) {
        switch (n) {
            case 1: {
                this.sb.append(this.ch0);
                this.skip(1);
                break;
            }
            case 2: {
                this.sb.append(this.ch0);
                this.sb.append(this.ch1);
                this.skip(2);
                break;
            }
            case 3: {
                this.sb.append(this.ch0);
                this.sb.append(this.ch1);
                this.sb.append(this.ch2);
                this.skip(3);
                break;
            }
            default: {
                assert (false) : "Should not reach here";
                break;
            }
        }
        return true;
    }

    private void restart(int startIn, int startOut) {
        this.reset(startIn);
        this.sb.setLength(startOut);
    }

    private void push(char ch) {
        this.expected.put(Character.valueOf(ch), this.expected.get(Character.valueOf(ch)) + 1);
    }

    private void pop(char ch) {
        this.expected.put(Character.valueOf(ch), Math.min(0, this.expected.get(Character.valueOf(ch)) - 1));
    }

    private void disjunction() {
        while (true) {
            this.alternative();
            if (this.ch0 != '|') break;
            this.commit(1);
        }
    }

    private void alternative() {
        while (this.term()) {
        }
    }

    private boolean term() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.assertion()) {
            if (this.lastAssertionWasLookahead) {
                this.quantifier();
            }
            return true;
        }
        if (this.atom()) {
            this.quantifier();
            return true;
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean assertion() {
        int startIn = this.position;
        int startOut = this.sb.length();
        this.lastAssertionWasLookahead = false;
        switch (this.ch0) {
            case '$': 
            case '^': {
                return this.commit(1);
            }
            case '\\': {
                if (this.ch1 != 'b' && this.ch1 != 'B') break;
                return this.commit(2);
            }
            case '(': {
                boolean lookbehind;
                if (this.ch1 != '?') break;
                this.commit(2);
                boolean bl = lookbehind = this.ch0 == '<';
                if (lookbehind) {
                    this.commit(1);
                }
                if (this.ch0 != '=' && this.ch0 != '!') break;
                boolean isNegativeLookaround = this.ch0 == '!';
                this.commit(1);
                if (isNegativeLookaround) {
                    if (this.negLookaroundLevel == 0) {
                        ++this.negLookaroundGroup;
                    }
                    ++this.negLookaroundLevel;
                }
                this.disjunction();
                if (isNegativeLookaround) {
                    --this.negLookaroundLevel;
                }
                if (this.ch0 != ')') break;
                this.lastAssertionWasLookahead = !lookbehind;
                return this.commit(1);
            }
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean quantifier() {
        if (this.quantifierPrefix()) {
            if (this.ch0 == '?') {
                this.commit(1);
            }
            return true;
        }
        return false;
    }

    private boolean quantifierPrefix() {
        int startIn = this.position;
        int startOut = this.sb.length();
        switch (this.ch0) {
            case '*': 
            case '+': 
            case '?': {
                return this.commit(1);
            }
            case '{': {
                this.commit(1);
                if (!this.decimalDigits()) break;
                this.push('}');
                if (this.ch0 == ',') {
                    this.commit(1);
                    this.decimalDigits();
                }
                if (this.ch0 != '}') {
                    this.pop('}');
                    this.restart(startIn, startOut);
                    return false;
                }
                this.pop('}');
                this.commit(1);
                return true;
            }
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean atom() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.patternCharacter()) {
            return true;
        }
        if (this.ch0 == '.') {
            return this.commit(1);
        }
        if (this.ch0 == '\\') {
            this.commit(1);
            if (this.atomEscape()) {
                return true;
            }
        }
        if (this.characterClass()) {
            return true;
        }
        if (this.ch0 == '(') {
            this.commit(1);
            if (this.ch0 == '?' && this.ch1 == ':') {
                this.commit(2);
            } else {
                this.caps.add(new Capture(this.negLookaroundGroup, this.negLookaroundLevel));
                this.groupSpecifier();
            }
            this.disjunction();
            if (this.ch0 == ')') {
                this.commit(1);
                return true;
            }
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean patternCharacter() {
        if (this.atEOF()) {
            return false;
        }
        switch (this.ch0) {
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case '^': 
            case '|': {
                return false;
            }
            case ']': 
            case '}': {
                int n = this.expected.get(Character.valueOf(this.ch0));
                if (n != 0) {
                    return false;
                }
            }
            case '{': {
                if (!this.quantifierPrefix()) {
                    this.sb.append('\\');
                    return this.commit(1);
                }
                return false;
            }
        }
        return this.commit(1);
    }

    private void handleBackReference(int groupIndex) {
        if (!this.caps.get(groupIndex - 1).isContained(this.negLookaroundGroup, this.negLookaroundLevel)) {
            this.sb.setLength(this.sb.length() - 1);
        } else {
            this.sb.append(groupIndex);
        }
    }

    private boolean atomEscape() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.ch0 == 'k') {
            this.skip(1);
            StringBuilder nameSB = new StringBuilder();
            if (this.groupName(nameSB)) {
                String name = nameSB.toString();
                if (this.namedCaptureGroups.containsKey(name)) {
                    int groupIndex = this.namedCaptureGroups.get(name);
                    this.handleBackReference(groupIndex);
                } else {
                    this.sb.setLength(this.sb.length() - 1);
                    this.forwardReferences.push(new NamedForwardReference(this.sb.length(), startIn - 1, name));
                }
                return true;
            }
            this.restart(startIn, startOut);
        }
        return this.decimalEscape() || this.characterClassEscape() || this.characterEscape();
    }

    private boolean characterEscape() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.controlEscape()) {
            return true;
        }
        if (this.ch0 == 'c') {
            this.commit(1);
            if (this.controlLetter()) {
                return true;
            }
            this.restart(startIn, startOut);
        }
        if (this.ch0 == '0' && !RegExpScanner.isDecimalDigit(this.ch1)) {
            this.skip(1);
            RegExpScanner.unicode(0, this.sb);
            return true;
        }
        if (this.hexEscapeSequence() || this.unicodeEscapeSequence() || this.legacyOctalEscapeSequence() || this.identityEscape()) {
            return true;
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean scanEscapeSequence(char leader, int length) {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.ch0 != leader) {
            return false;
        }
        this.commit(1);
        for (int i = 0; i < length; ++i) {
            char ch0l = Character.toLowerCase(this.ch0);
            if (!(ch0l >= 'a' && ch0l <= 'f' || RegExpScanner.isDecimalDigit(this.ch0))) {
                this.restart(startIn, startOut);
                return false;
            }
            this.commit(1);
        }
        return true;
    }

    private boolean hexEscapeSequence() {
        return this.scanEscapeSequence('x', 2);
    }

    private boolean unicodeEscapeSequence() {
        return this.scanEscapeSequence('u', 4);
    }

    private boolean legacyOctalEscapeSequence() {
        int startIn = this.position;
        int startOut = this.sb.length();
        int octalValue = 0;
        while (RegExpScanner.isOctalDigit(this.ch0) && octalValue < 32 && this.position < startIn + 3) {
            octalValue = octalValue * 8 + this.ch0 - 48;
            this.skip(1);
        }
        if (this.position > startIn) {
            RegExpScanner.unicode(octalValue, this.sb);
            return true;
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean controlEscape() {
        switch (this.ch0) {
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                return this.commit(1);
            }
        }
        return false;
    }

    private boolean controlLetter() {
        if (this.ch0 >= 'A' && this.ch0 <= 'Z' || this.ch0 >= 'a' && this.ch0 <= 'z' || this.inCharClass && (RegExpScanner.isDecimalDigit(this.ch0) || this.ch0 == '_')) {
            this.sb.setLength(this.sb.length() - 1);
            RegExpScanner.unicode(this.ch0 % 32, this.sb);
            this.skip(1);
            return true;
        }
        return false;
    }

    private void groupSpecifier() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.ch0 == '?') {
            this.skip(1);
            StringBuilder name = new StringBuilder();
            if (this.groupName(name)) {
                this.namedCaptureGroups.put(name.toString(), this.caps.size());
            } else {
                this.restart(startIn, startOut);
            }
        }
    }

    private boolean groupName(StringBuilder nameBuilder) {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.ch0 == '<') {
            this.skip(1);
            if (this.regExpIdentifierName(nameBuilder) && this.ch0 == '>') {
                this.skip(1);
                return true;
            }
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean regExpIdentifierName(StringBuilder nameBuilder) {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.regExpIdentifierStart(nameBuilder)) {
            while (this.regExpIdentifierPart(nameBuilder)) {
            }
            return true;
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean regExpIdentifierElement(StringBuilder nameBuilder, Predicate<Character> allowedChars) {
        int startIn = this.position;
        int startOut = this.sb.length();
        char codeUnit = '\u0000';
        if (this.ch0 == '\\') {
            this.skip(1);
            if (this.unicodeEscapeSequence()) {
                String hexSequence = this.sb.substring(this.sb.length() - 4);
                this.sb.setLength(this.sb.length() - 6);
                codeUnit = (char)Integer.parseInt(hexSequence, 16);
            }
        } else {
            codeUnit = this.ch0;
            this.skip(1);
        }
        if (allowedChars.test(Character.valueOf(codeUnit))) {
            nameBuilder.append(codeUnit);
            return true;
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean regExpIdentifierStart(StringBuilder nameBuilder) {
        return this.regExpIdentifierElement(nameBuilder, c -> ID_START.contains((int)c.charValue()) || c.charValue() == '$' || c.charValue() == '_');
    }

    private boolean regExpIdentifierPart(StringBuilder nameBuilder) {
        return this.regExpIdentifierElement(nameBuilder, c -> ID_CONTINUE.contains((int)c.charValue()) || c.charValue() == '$' || c.charValue() == '\u200c' || c.charValue() == '\u200d');
    }

    private boolean identityEscape() {
        if (this.atEOF()) {
            throw new RuntimeException("\\ at end of pattern");
        }
        if (this.ch0 == 'c') {
            this.sb.append('\\');
        } else if (NON_IDENT_ESCAPES.indexOf(this.ch0) == -1) {
            this.sb.setLength(this.sb.length() - 1);
        }
        return this.commit(1);
    }

    private boolean decimalEscape() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (RegExpScanner.isDecimalDigit(this.ch0) && this.ch0 != '0') {
            int decimalValue = 0;
            while (RegExpScanner.isDecimalDigit(this.ch0)) {
                decimalValue = decimalValue * 10 + this.ch0 - 48;
                this.skip(1);
            }
            if (this.inCharClass) {
                this.sb.setLength(this.sb.length() - 1);
                RegExpScanner.octalOrLiteral(Integer.toString(decimalValue), this.sb);
            } else if (decimalValue <= this.caps.size()) {
                this.handleBackReference(decimalValue);
            } else {
                this.sb.setLength(this.sb.length() - 1);
                this.forwardReferences.push(new IndexedForwardReference(this.sb.length(), decimalValue));
            }
            return true;
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean characterClassEscape() {
        switch (this.ch0) {
            case 'D': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 's': 
            case 'w': {
                return this.commit(1);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean characterClass() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.ch0 == '[') {
            try {
                this.inCharClass = true;
                this.push(']');
                this.commit(1);
                if (this.ch0 == '^') {
                    this.inNegativeClass = true;
                    this.commit(1);
                }
                if (this.classRanges() && this.ch0 == ']') {
                    this.pop(']');
                    this.commit(1);
                    if (this.position == startIn + 2) {
                        this.sb.setLength(this.sb.length() - 1);
                        this.sb.append("^\\s\\S]");
                    } else if (this.position == startIn + 3 && this.inNegativeClass) {
                        this.sb.setLength(this.sb.length() - 2);
                        this.sb.append("\\s\\S]");
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.inCharClass = false;
                this.inNegativeClass = false;
            }
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean classRanges() {
        this.nonemptyClassRanges();
        return true;
    }

    private boolean nonemptyClassRanges() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.classAtom()) {
            if (this.ch0 == '-') {
                this.commit(1);
                if (this.classAtom() && this.classRanges()) {
                    return true;
                }
            }
            this.nonemptyClassRangesNoDash();
            return true;
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean nonemptyClassRangesNoDash() {
        int startIn = this.position;
        int startOut = this.sb.length();
        if (this.classAtomNoDash()) {
            if (this.ch0 == '-') {
                this.commit(1);
                if (this.classAtom() && this.classRanges()) {
                    return true;
                }
            }
            this.nonemptyClassRangesNoDash();
            return true;
        }
        if (this.classAtom()) {
            return true;
        }
        this.restart(startIn, startOut);
        return false;
    }

    private boolean classAtom() {
        if (this.ch0 == '-') {
            return this.commit(1);
        }
        return this.classAtomNoDash();
    }

    private boolean classAtomNoDash() {
        if (this.atEOF()) {
            return false;
        }
        int startIn = this.position;
        int startOut = this.sb.length();
        switch (this.ch0) {
            case '-': 
            case ']': {
                return false;
            }
            case '[': {
                this.sb.append('\\');
                return this.commit(1);
            }
            case '\\': {
                this.commit(1);
                if (this.classEscape()) {
                    return true;
                }
                this.restart(startIn, startOut);
                return false;
            }
        }
        return this.commit(1);
    }

    private boolean classEscape() {
        if (this.ch0 == 'b') {
            this.sb.setLength(this.sb.length() - 1);
            this.sb.append('\b');
            this.skip(1);
            return true;
        }
        return this.characterClassEscape() || this.characterEscape();
    }

    private boolean decimalDigits() {
        if (!RegExpScanner.isDecimalDigit(this.ch0)) {
            return false;
        }
        while (RegExpScanner.isDecimalDigit(this.ch0)) {
            this.commit(1);
        }
        return true;
    }

    private static void unicode(int value, StringBuilder buffer) {
        String hex = Integer.toHexString(value);
        buffer.append('u');
        for (int i = 0; i < 4 - hex.length(); ++i) {
            buffer.append('0');
        }
        buffer.append(hex);
    }

    private static void octalOrLiteral(String numberLiteral, StringBuilder buffer) {
        char ch;
        int pos;
        int length = numberLiteral.length();
        int octalValue = 0;
        for (pos = 0; pos < length && octalValue < 32 && RegExpScanner.isOctalDigit(ch = numberLiteral.charAt(pos)); ++pos) {
            octalValue = octalValue * 8 + ch - 48;
        }
        if (octalValue > 0) {
            buffer.append('\\');
            RegExpScanner.unicode(octalValue, buffer);
            buffer.append(numberLiteral.substring(pos));
        } else {
            buffer.append(numberLiteral);
        }
    }

    private static boolean isOctalDigit(char ch) {
        return ch >= '0' && ch <= '7';
    }

    private static boolean isDecimalDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static class NamedForwardReference
    extends ForwardReference {
        public final String name;
        public final int inPos;

        NamedForwardReference(int outPos, int inPos, String name) {
            super(outPos);
            this.inPos = inPos;
            this.name = name;
        }
    }

    private static class IndexedForwardReference
    extends ForwardReference {
        public final int index;

        IndexedForwardReference(int outPos, int index) {
            super(outPos);
            this.index = index;
        }
    }

    private static class ForwardReference {
        public final int outPos;

        protected ForwardReference(int outPos) {
            this.outPos = outPos;
        }
    }

    private static class Capture {
        private final int negLookaroundLevel;
        private final int negLookaroundGroup;

        Capture(int negLookaroundGroup, int negLookaroundLevel) {
            this.negLookaroundGroup = negLookaroundGroup;
            this.negLookaroundLevel = negLookaroundLevel;
        }

        boolean isContained(int group, int level) {
            return this.negLookaroundLevel == 0 || group == this.negLookaroundGroup && level >= this.negLookaroundLevel;
        }
    }
}

