/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.toolchain.launchers.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.home.HomeFinder;

public class Driver {
    protected final String exe;
    protected final boolean isBundledTool;
    private static boolean hasJreDir = System.getProperty("java.specification.version").startsWith("1.");
    public static final String VERSIION = Driver.getVersion();

    public Driver(String exe, boolean inLLVMDir) {
        this.exe = inLLVMDir ? this.getLLVMExecutable(exe).toString() : exe;
        this.isBundledTool = inLLVMDir;
    }

    public Driver(String exe) {
        this(exe, true);
    }

    private static Path getRuntimeDir() {
        Path runtimeDir = HomeFinder.getInstance().getHomeFolder();
        if (runtimeDir == null) {
            throw new IllegalStateException("Could not find GraalVM home");
        }
        if (hasJreDir) {
            runtimeDir = runtimeDir.resolve("jre");
        }
        return runtimeDir;
    }

    public Path getLLVMBinDir() {
        String property = System.getProperty("llvm.bin.dir");
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        Path toolchainHome = (Path)HomeFinder.getInstance().getLanguageHomes().get("llvm-toolchain");
        if (toolchainHome != null) {
            return toolchainHome.resolve("bin");
        }
        return Driver.getRuntimeDir().resolve("lib").resolve("llvm").resolve("bin");
    }

    public Path getSulongHome() {
        String property = System.getProperty("llvm.home");
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        Path sulongHome = (Path)HomeFinder.getInstance().getLanguageHomes().get("llvm");
        if (sulongHome != null) {
            return sulongHome;
        }
        throw new IllegalStateException("Could not find the llvm home");
    }

    private static String getVersion() {
        String version = System.getProperty("org.graalvm.version");
        if (version == null) {
            version = System.getProperty("graalvm.version");
        }
        if (version == null) {
            return "Development Build";
        }
        return version;
    }

    public void runDriver(List<String> sulongArgs, List<String> userArgs, boolean verbose, boolean help, boolean earlyExit) {
        this.runDriverExit(sulongArgs, userArgs, verbose, help, earlyExit);
    }

    public final void runDriverExit(List<String> sulongArgs, List<String> userArgs, boolean verbose, boolean help, boolean earlyExit) {
        try {
            System.exit(this.runDriverReturn(sulongArgs, userArgs, verbose, help, earlyExit));
        }
        catch (IOException e) {
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Exception: " + e);
            System.exit(1);
        }
    }

    public final int runDriverReturn(List<String> sulongArgs, List<String> userArgs, boolean verbose, boolean help, boolean earlyExit) throws Exception {
        ArrayList<String> toolArgs = new ArrayList<String>(sulongArgs.size() + userArgs.size());
        toolArgs.addAll(sulongArgs);
        toolArgs.addAll(userArgs);
        this.printInfos(verbose, help, earlyExit, toolArgs);
        if (earlyExit) {
            return 0;
        }
        ProcessBuilder pb = new ProcessBuilder(toolArgs);
        if (verbose) {
            Driver.setupRedirectsDefault(pb);
        } else {
            this.setupRedirects(pb);
        }
        Process p = null;
        try {
            p = pb.start();
            if (!verbose) {
                this.processIO(p.getInputStream(), p.getOutputStream(), p.getErrorStream());
            }
            p.waitFor();
            return p.exitValue();
        }
        catch (IOException ioe) {
            if (this.isBundledTool) {
                this.printMissingToolMessage();
            }
            throw ioe;
        }
        catch (Exception e) {
            if (p != null) {
                p.destroyForcibly();
            }
            throw e;
        }
    }

    protected void processIO(InputStream inputStream, OutputStream outputStream, InputStream errorStream) {
    }

    protected ProcessBuilder setupRedirects(ProcessBuilder pb) {
        return Driver.setupRedirectsDefault(pb);
    }

    private static ProcessBuilder setupRedirectsDefault(ProcessBuilder pb) {
        return pb.inheritIO();
    }

    private void printMissingToolMessage() {
        System.err.println("Tool execution failed. Are you sure the toolchain is available at " + this.getLLVMBinDir().getParent());
        System.err.println("You can install it via GraalVM updater: `gu install llvm-toolchain`");
        System.err.println();
        System.err.println("More infos: https://www.graalvm.org/docs/reference-manual/languages/llvm/");
    }

    private void printInfos(boolean verbose, boolean help, boolean earlyExit, ArrayList<String> toolArgs) {
        if (help) {
            System.out.println("##################################################");
            System.out.println("This it the the GraalVM wrapper script for " + this.getTool());
            System.out.println();
            System.out.println("Its purpose is to make it easy to compile native projects to be used with");
            System.out.println("GraalVM's LLVM IR engine (bin/lli).");
            System.out.println("More infos: https://www.graalvm.org/docs/reference-manual/languages/llvm/");
            System.out.println("Wrapped executable: " + this.exe);
            System.out.println("GraalVM version: " + VERSIION);
        }
        if (verbose) {
            System.out.println("GraalVM wrapper script for " + this.getTool());
            System.out.println("GraalVM version: " + VERSIION);
            System.out.println("running: " + String.join((CharSequence)" ", toolArgs));
        }
        if (help) {
            if (!earlyExit) {
                System.out.println();
                System.out.println("The following is the output of the wrapped tool:");
            }
            System.out.println("##################################################");
        }
    }

    private Path getTool() {
        return Paths.get(this.exe, new String[0]).getFileName();
    }

    public Path getLLVMExecutable(String tool) {
        return this.getLLVMBinDir().resolve(tool);
    }

    public static enum OS {
        DARWIN,
        LINUX;

        private static final OS current;

        private static OS findCurrent() {
            String name = System.getProperty("os.name");
            if (name.equals("Linux")) {
                return LINUX;
            }
            if (name.equals("Mac OS X") || name.equals("Darwin")) {
                return DARWIN;
            }
            throw new IllegalArgumentException("unknown OS: " + name);
        }

        public static OS getCurrent() {
            return current;
        }

        static {
            current = OS.findCurrent();
        }
    }
}

