/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.generic.model.impl;

import java.util.Iterator;
import org.graalvm.visualvm.jfr.model.JFRDataDescriptor;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.flightrecorder.JfrAttributes;

final class DisplayableSupport {
    static Iterator<IAccessorKey> displayableAccessorKeys(final IType type, boolean includeExperimental) {
        return new Iterator<IAccessorKey>(){
            private final String ID_STACKTRACE = JfrAttributes.EVENT_STACKTRACE.getIdentifier();
            private final Iterator<IAccessorKey> master = type.getAccessorKeys().keySet().iterator();
            private IAccessorKey next = this.computeNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public IAccessorKey next() {
                IAccessorKey ret = this.next;
                this.next = this.computeNext();
                return ret;
            }

            private IAccessorKey computeNext() {
                while (this.master.hasNext()) {
                    IAccessorKey _next = this.master.next();
                    if (!this.isDisplayable(_next)) continue;
                    return _next;
                }
                return null;
            }

            private boolean isDisplayable(IAccessorKey key) {
                return !this.ID_STACKTRACE.equals(key.getIdentifier());
            }
        };
    }

    static JFRDataDescriptor getDataDescriptor(IAccessorKey key) {
        String dataName = TypeHandling.getValueString(key);
        String dataDescription = TypeHandling.getVerboseString(key);
        boolean isNumericData = key.getContentType() instanceof LinearKindOfQuantity;
        return new JFRDataDescriptor(dataName, dataDescription, null, null, isNumericData);
    }

    private DisplayableSupport() {
    }
}

