/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.generic.model.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graalvm.visualvm.jfr.generic.model.impl.DisplayableSupport;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericClass;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericStackTrace;
import org.graalvm.visualvm.jfr.generic.model.impl.JFRGenericThread;
import org.graalvm.visualvm.jfr.model.JFRClass;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.model.JFRThread;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.item.IAccessorKey;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;

final class JFRGenericEvent
extends JFREvent {
    final IItem item;

    JFRGenericEvent(IItem event) {
        this.item = event;
    }

    public Duration getDuration(String key) throws JFRPropertyNotAvailableException {
        Object duration;
        switch (key) {
            case "eventDuration": {
                try {
                    duration = JFRGenericEvent.getValue(this.item, JfrAttributes.DURATION);
                    break;
                }
                catch (JFRPropertyNotAvailableException e) {
                    IQuantity startTime = this.getTime("eventTime");
                    if (startTime == null) {
                        throw new JFRPropertyNotAvailableException("No start time to compute duration: " + key);
                    }
                    IQuantity endTime = this.getTime("endTime");
                    if (endTime == null) {
                        throw new JFRPropertyNotAvailableException("No end time to compute duration: " + key);
                    }
                    return JFRGenericEvent.durationFromQuantity(endTime.subtract(startTime));
                }
            }
            default: {
                duration = this.getValue(key);
            }
        }
        if (duration instanceof IQuantity) {
            return JFRGenericEvent.durationFromQuantity((IQuantity)duration);
        }
        if (duration == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No duration value available: " + key);
    }

    private static Duration durationFromQuantity(IQuantity quantity) {
        try {
            long nanos = quantity.longValueIn(UnitLookup.NANOSECOND);
            return Duration.ofNanos(nanos);
        }
        catch (QuantityConversionException ex1) {
            try {
                long millis = quantity.longValueIn(UnitLookup.MILLISECOND);
                return Duration.ofMillis(millis);
            }
            catch (QuantityConversionException ex3) {
                long seconds = quantity.clampedLongValueIn(UnitLookup.SECOND);
                return Duration.ofSeconds(seconds);
            }
        }
    }

    private IQuantity getTime(String key) throws JFRPropertyNotAvailableException {
        Object time;
        switch (key) {
            case "eventTime": 
            case "startTime": {
                try {
                    time = JFRGenericEvent.getValue(this.item, JfrAttributes.START_TIME);
                }
                catch (JFRPropertyNotAvailableException e) {
                    time = JFRGenericEvent.getValue(this.item, JfrAttributes.END_TIME);
                }
                break;
            }
            case "endTime": {
                try {
                    time = JFRGenericEvent.getValue(this.item, JfrAttributes.END_TIME);
                }
                catch (JFRPropertyNotAvailableException e) {
                    time = this.getValue("endTime");
                }
                break;
            }
            default: {
                time = this.getValue(key);
            }
        }
        if (time instanceof IQuantity) {
            return (IQuantity)time;
        }
        if (time == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No instant value available: " + key);
    }

    public Instant getInstant(String key) throws JFRPropertyNotAvailableException {
        IQuantity quantity = this.getTime(key);
        return quantity == null ? null : JFRGenericEvent.instantFromQuantity(quantity);
    }

    private static Instant instantFromQuantity(IQuantity quantity) {
        try {
            long nanos = quantity.longValueIn(UnitLookup.EPOCH_NS);
            return Instant.EPOCH.plusNanos(nanos);
        }
        catch (QuantityConversionException ex1) {
            try {
                long millis = quantity.longValueIn(UnitLookup.EPOCH_MS);
                return Instant.ofEpochMilli(millis);
            }
            catch (QuantityConversionException ex3) {
                long seconds = quantity.clampedLongValueIn(UnitLookup.EPOCH_S);
                return Instant.ofEpochSecond(seconds);
            }
        }
    }

    public JFRClass getClass(String key) throws JFRPropertyNotAvailableException {
        Object value = this.getValue(key);
        if (value instanceof IMCType) {
            return new JFRGenericClass((IMCType)value);
        }
        if (value == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No class value available: " + key);
    }

    public JFRThread getThread(String key) throws JFRPropertyNotAvailableException {
        Object thread;
        switch (key) {
            case "eventThread": {
                thread = JFRGenericEvent.getValue(this.item, JfrAttributes.EVENT_THREAD);
                break;
            }
            case "sampledThread": {
                try {
                    thread = this.getValue("sampledThread");
                }
                catch (JFRPropertyNotAvailableException e) {
                    thread = JFRGenericEvent.getValue(this.item, JfrAttributes.EVENT_THREAD);
                }
                break;
            }
            case "thread": {
                try {
                    thread = this.getValue("thread");
                }
                catch (JFRPropertyNotAvailableException e) {
                    thread = this.getValue("javalangthread");
                }
                break;
            }
            default: {
                thread = this.getValue(key);
            }
        }
        if (thread instanceof IMCThread) {
            return new JFRGenericThread((IMCThread)thread);
        }
        if (thread == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No thread value available: " + key);
    }

    public JFRStackTrace getStackTrace(String key) throws JFRPropertyNotAvailableException {
        Object stackTrace;
        switch (key) {
            case "eventStackTrace": {
                stackTrace = JFRGenericEvent.getValue(this.item, JfrAttributes.EVENT_STACKTRACE);
                break;
            }
            default: {
                stackTrace = this.getValue(key);
            }
        }
        if (stackTrace instanceof IMCStackTrace) {
            return new JFRGenericStackTrace((IMCStackTrace)stackTrace);
        }
        if (stackTrace == null) {
            return null;
        }
        throw new JFRPropertyNotAvailableException("No stacktrace value available: " + key);
    }

    public Object getValue(String key) throws JFRPropertyNotAvailableException {
        return JFRGenericEvent.getValue(this.item, key);
    }

    protected static Object getValue(IItem item, IAttribute attribute) throws JFRPropertyNotAvailableException {
        IType<?> type = item.getType();
        IMemberAccessor accessor = type.getAccessor(attribute.getKey());
        if (accessor != null) {
            return accessor.getMember(item);
        }
        throw new JFRPropertyNotAvailableException("No value available: " + attribute.getIdentifier());
    }

    static Object getValue(IItem item, String key) throws JFRPropertyNotAvailableException {
        key = key.replace('.', ':');
        IType<?> type = item.getType();
        for (IAccessorKey<?> accessor : type.getAccessorKeys().keySet()) {
            if (!key.equals(accessor.getIdentifier())) continue;
            return type.getAccessor(accessor).getMember(item);
        }
        throw new JFRPropertyNotAvailableException("No value available: " + key);
    }

    public List<Comparable> getDisplayableValues(boolean includeExperimental) {
        IType<?> type = this.item.getType();
        ArrayList<Comparable> values = new ArrayList<Comparable>();
        Iterator<IAccessorKey> keys = DisplayableSupport.displayableAccessorKeys(type, includeExperimental);
        while (keys.hasNext()) {
            IAccessorKey key = keys.next();
            Object value = type.getAccessor(key).getMember(this.item);
            values.add((Comparable)((Object)(value == null ? "" : key.getContentType().getDefaultFormatter().format(value))));
        }
        return values;
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof JFRGenericEvent ? this.item.equals(((JFRGenericEvent)((Object)o)).item) : false;
    }

    public String toString() {
        return this.item.toString() + " [" + this.item.getType().getAccessorKeys().keySet() + "]";
    }
}

