/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graalvm.locator;

import com.oracle.graalvm.locator.JDKServices;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.TruffleLocator;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.graalvm.home.HomeFinder;

public final class GraalVMLocator
extends TruffleLocator
implements Callable<ClassLoader> {
    private static final boolean LOCATOR_TRACE = Boolean.valueOf(System.getProperty("truffle.class.path.trace", "false"));
    private static URLClassLoader loader;

    private static void setGraalVMProperties(HomeFinder homeFinder) {
        Path homePath = homeFinder.getHomeFolder();
        if (homePath != null) {
            String home = homePath.toString();
            if (System.getProperty("graalvm.home") == null) {
                System.setProperty("graalvm.home", home);
            }
            if (System.getProperty("org.graalvm.home") == null) {
                System.setProperty("org.graalvm.home", home);
            }
        }
        String version = homeFinder.getVersion();
        System.setProperty("graalvm.version", version);
        System.setProperty("org.graalvm.version", version);
        for (Map.Entry languageHome : homeFinder.getLanguageHomes().entrySet()) {
            GraalVMLocator.setLanguageHomeProperty((String)languageHome.getKey(), (Path)languageHome.getValue());
        }
        for (Map.Entry toolHome : homeFinder.getToolHomes().entrySet()) {
            GraalVMLocator.setLanguageHomeProperty((String)toolHome.getKey(), (Path)toolHome.getValue());
        }
    }

    private static void setLanguageHomeProperty(String languageId, Path languageLocation) {
        String homeFolderKey;
        if (Files.isDirectory(languageLocation, new LinkOption[0]) && System.getProperty(homeFolderKey = languageId + ".home") == null) {
            System.setProperty(homeFolderKey, languageLocation.toString());
        }
    }

    private static List<URL> collectClassPath(HomeFinder homeFinder) {
        ArrayList<URL> classPath = new ArrayList<URL>();
        GraalVMLocator.collectLanguageJars(homeFinder.getLanguageHomes(), classPath);
        GraalVMLocator.collectLanguageJars(homeFinder.getToolHomes(), classPath);
        String append = System.getProperty("truffle.class.path.append");
        if (append != null) {
            String[] files = append.split(System.getProperty("path.separator"));
            for (String file : files) {
                GraalVMLocator.addJarOrDir(classPath, Paths.get(file, new String[0]));
            }
        }
        if (LOCATOR_TRACE) {
            PrintStream out = System.out;
            out.println("Setting up Truffle GuestLanguageTools classpath:");
            for (URL url : classPath) {
                out.println(url);
            }
        }
        return classPath;
    }

    public static ClassLoader getLanguagesLoader() {
        if (loader == null) {
            HomeFinder homeFinder = HomeFinder.getInstance();
            if (homeFinder == null) {
                throw new IllegalStateException("No HomeFinder instance.");
            }
            GraalVMLocator.setGraalVMProperties(homeFinder);
            if (!TruffleOptions.AOT) {
                List<URL> classPath = GraalVMLocator.collectClassPath(homeFinder);
                loader = new GuestLangToolsLoader(classPath.toArray(new URL[0]), JDKServices.getLocatorBaseClassLoader(GraalVMLocator.class));
            }
        }
        return loader;
    }

    private static void collectLanguageJars(Map<String, Path> homes, List<URL> classPath) {
        for (Map.Entry<String, Path> languageHome : homes.entrySet()) {
            Path languageLocation = languageHome.getValue();
            if (Files.isDirectory(languageLocation, new LinkOption[0])) {
                try {
                    DirectoryStream<Path> dirStream = Files.newDirectoryStream(languageLocation);
                    Throwable throwable = null;
                    try {
                        for (Path file : dirStream) {
                            GraalVMLocator.addJar(classPath, file);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dirStream == null) continue;
                        if (throwable != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dirStream.close();
                        continue;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            GraalVMLocator.addJar(classPath, languageLocation);
        }
    }

    private static void addJarOrDir(List<URL> classPath, Path file) {
        if (Files.isDirectory(file, new LinkOption[0])) {
            try {
                classPath.add(file.toUri().toURL());
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        } else {
            GraalVMLocator.addJar(classPath, file);
        }
    }

    private static void addJar(List<URL> classPath, Path jar) {
        Path filename = jar.getFileName();
        if (filename != null && filename.toString().endsWith(".jar") && Files.exists(jar, new LinkOption[0])) {
            try {
                classPath.add(jar.toUri().toURL());
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public void locate(TruffleLocator.Response response) {
        ClassLoader cl;
        if (!"true".equals(System.getProperty("graalvm.locatorDisabled")) && (cl = GraalVMLocator.getLanguagesLoader()) != null) {
            response.registerClassLoader(cl);
        }
    }

    @Override
    public ClassLoader call() throws Exception {
        return GraalVMLocator.getLanguagesLoader();
    }

    private static class GuestLangToolsLoader
    extends URLClassLoader {
        GuestLangToolsLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }
    }
}

