/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.function.Supplier;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalManagementRegistration;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.management.HotSpotGraalRuntimeMBean;
import org.graalvm.compiler.hotspot.management.libgraal.Id;
import org.graalvm.compiler.hotspot.management.libgraal.SVMToHotSpotCalls;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class HotSpotGraalManagement
implements HotSpotGraalManagementRegistration {
    private static final String HS_BEAN_CLASS_NAME = null;
    private static final byte[] HS_BEAN_CLASS = null;
    private static final String HS_BEAN_FACTORY_CLASS_NAME = null;
    private static final byte[] HS_BEAN_FACTORY_CLASS = null;
    private static final String HS_SVM_CALLS_CLASS_NAME = null;
    private static final byte[] HS_SVM_CALLS_CLASS = null;
    private static final String HS_PUSHBACK_ITER_CLASS_NAME = null;
    private static final byte[] HS_PUSHBACK_ITER_CLASS = null;
    private static final String SVM_HS_ENTRYPOINTS_CLASS_NAME = null;
    private static final byte[] SVM_HS_ENTRYPOINTS_CLASS = null;
    private static JNI.JClass svmToHotSpotEntryPoints;
    private static long jniEnvOffset;
    private HotSpotGraalRuntimeMBean bean;
    private String name;
    private volatile boolean needsRegistration = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void initialize(HotSpotGraalRuntime runtime, GraalHotSpotVMConfig config) {
        if (jniEnvOffset == 0L) {
            Class<HotSpotGraalManagement> clazz = HotSpotGraalManagement.class;
            // MONITORENTER : org.graalvm.compiler.hotspot.management.libgraal.HotSpotGraalManagement.class
            if (jniEnvOffset == 0L) {
                if (config.jniEnvironmentOffset == Integer.MIN_VALUE) {
                    // MONITOREXIT : clazz
                    return;
                }
                jniEnvOffset = config.jniEnvironmentOffset;
                HotSpotGraalManagement.defineClassesInHotSpot(HotSpotGraalManagement.getCurrentJNIEnv());
            }
            // MONITOREXIT : clazz
        }
        if (this.bean != null) {
            if (this.bean.getRuntime() == runtime) return;
            throw new IllegalArgumentException("Cannot change the runtime a management interface is associated with");
        }
        if (runtime.getManagement() != this) {
            throw new IllegalArgumentException("Cannot initialize a second management object for runtime " + runtime.getName());
        }
        try {
            this.name = runtime.getName().replace(':', '_');
            this.bean = new HotSpotGraalRuntimeMBean(new ObjectName("org.graalvm.compiler.hotspot:type=" + this.name), runtime);
            Factory.enqueue(this);
            HotSpotGraalManagement.signal(HotSpotGraalManagement.getCurrentJNIEnv(), svmToHotSpotEntryPoints, HotSpotGraalManagement.getFactory(HotSpotGraalManagement.getCurrentJNIEnv(), svmToHotSpotEntryPoints));
            return;
        }
        catch (MalformedObjectNameException err) {
            err.printStackTrace(TTY.out);
            return;
        }
    }

    public ObjectName poll(boolean sync) {
        if (this.bean == null || this.needsRegistration) {
            return null;
        }
        return this.bean.getObjectName();
    }

    HotSpotGraalRuntimeMBean getBean() {
        return this.bean;
    }

    void finishRegistration() {
        this.needsRegistration = false;
    }

    String getName() {
        return this.name;
    }

    private static void defineClassesInHotSpot(JNI.JNIEnv env) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)Id.DefineClasses, env);){
            JNI.JObject classLoader = SVMToHotSpotCalls.getJVMCIClassLoader(env);
            if (HotSpotGraalManagement.defineClassInHotSpot(env, classLoader, HS_BEAN_CLASS_NAME, HS_BEAN_CLASS).isNull()) {
                throw HotSpotGraalManagement.throwDefineClassError(HS_BEAN_CLASS_NAME);
            }
            if (HotSpotGraalManagement.defineClassInHotSpot(env, classLoader, HS_BEAN_FACTORY_CLASS_NAME, HS_BEAN_FACTORY_CLASS).isNull()) {
                throw HotSpotGraalManagement.throwDefineClassError(HS_BEAN_FACTORY_CLASS_NAME);
            }
            if (HotSpotGraalManagement.defineClassInHotSpot(env, classLoader, HS_PUSHBACK_ITER_CLASS_NAME, HS_PUSHBACK_ITER_CLASS).isNull()) {
                throw HotSpotGraalManagement.throwDefineClassError(HS_PUSHBACK_ITER_CLASS_NAME);
            }
            if (HotSpotGraalManagement.defineClassInHotSpot(env, classLoader, HS_SVM_CALLS_CLASS_NAME, HS_SVM_CALLS_CLASS).isNull()) {
                throw HotSpotGraalManagement.throwDefineClassError(HS_SVM_CALLS_CLASS_NAME);
            }
            JNI.JClass svmHsEntryPoints = HotSpotGraalManagement.defineClassInHotSpot(env, classLoader, SVM_HS_ENTRYPOINTS_CLASS_NAME, SVM_HS_ENTRYPOINTS_CLASS);
            if (svmHsEntryPoints.isNull()) {
                throw HotSpotGraalManagement.throwDefineClassError(SVM_HS_ENTRYPOINTS_CLASS_NAME);
            }
            svmToHotSpotEntryPoints = (JNI.JClass)JNIUtil.NewGlobalRef((JNI.JNIEnv)env, (JNI.JObject)svmHsEntryPoints, (String)("Class<" + SVM_HS_ENTRYPOINTS_CLASS_NAME + ">"));
        }
    }

    /*
     * Loose catch block
     */
    private static JNI.JClass defineClassInHotSpot(JNI.JNIEnv env, JNI.JObject classLoader, String clazzName, byte[] clazz) {
        CCharPointer classData = (CCharPointer)UnmanagedMemory.malloc((int)clazz.length);
        ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)classData, (int)clazz.length);
        buffer.put(clazz);
        try {
            try (CTypeConversion.CCharPointerHolder className = CTypeConversion.toCString((CharSequence)clazzName);){
                JNI.JClass jClass = JNIUtil.DefineClass((JNI.JNIEnv)env, (CCharPointer)className.get(), (JNI.JObject)classLoader, (CCharPointer)classData, (int)clazz.length);
                return jClass;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            UnmanagedMemory.free((PointerBase)classData);
        }
    }

    private static JNI.JObject getFactory(JNI.JNIEnv env, JNI.JClass svmHsEntryPoints) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)Id.GetFactory, env);){
            JNI.JObject factory = SVMToHotSpotCalls.getFactory(env, svmHsEntryPoints);
            if (factory.isNull()) {
                throw new InternalError("Failed to instantiate MBean factory on HotSpot side.");
            }
            JNI.JObject jObject = factory;
            return jObject;
        }
    }

    private static void signal(JNI.JNIEnv env, JNI.JClass svmHsEntryPoints, JNI.JObject factory) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)Id.NewMBean, env);){
            SVMToHotSpotCalls.signal(env, svmHsEntryPoints, factory);
        }
    }

    private static JNI.JNIEnv getCurrentJNIEnv() {
        if (jniEnvOffset == 0L) {
            throw new IllegalStateException("JniEnvOffset is not yet initialized.");
        }
        long currentJavaThreadAddr = HotSpotJVMCIRuntime.runtime().getCurrentJavaThread();
        return (JNI.JNIEnv)WordFactory.pointer((long)(currentJavaThreadAddr + jniEnvOffset));
    }

    private static RuntimeException throwDefineClassError(String name) {
        throw new InternalError(String.format("Failed to define %s.", name));
    }

    static final class Factory
    implements Supplier<HotSpotGraalManagementRegistration> {
        private static Queue<HotSpotGraalManagement> registrations = new ArrayDeque<HotSpotGraalManagement>();

        Factory() {
        }

        @Override
        public HotSpotGraalManagementRegistration get() {
            return new HotSpotGraalManagement();
        }

        static synchronized List<HotSpotGraalManagement> drain() {
            if (registrations.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<HotSpotGraalManagement> res = new ArrayList<HotSpotGraalManagement>(registrations);
            registrations.clear();
            return res;
        }

        private static synchronized HotSpotGraalManagement enqueue(HotSpotGraalManagement instance) {
            registrations.add(instance);
            return instance;
        }
    }
}

