/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.management.libgraal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.graalvm.compiler.hotspot.management.libgraal.HotSpotGraalManagement;
import org.graalvm.compiler.hotspot.management.libgraal.Id;
import org.graalvm.libgraal.jni.HotSpotToSVMScope;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.util.OptionsEncoder;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

final class HotSpotToSVMEntryPoints {
    private HotSpotToSVMEntryPoints() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_libgraal_runtime_HotSpotToSVMCalls_pollRegistrations")
    static JNI.JLongArray pollRegistrations(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId) {
        HotSpotToSVMScope scope;
        try (HotSpotToSVMScope s = scope = new HotSpotToSVMScope((Enum)Id.PollRegistrations, env);){
            List<HotSpotGraalManagement> registrations = HotSpotGraalManagement.Factory.drain();
            JNI.JLongArray res = JNIUtil.NewLongArray((JNI.JNIEnv)env, (int)registrations.size());
            CLongPointer elems = JNIUtil.GetLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)res, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
            try {
                ObjectHandles globalHandles = ObjectHandles.getGlobal();
                for (int i = 0; i < registrations.size(); ++i) {
                    long handle = globalHandles.create((Object)registrations.get(i)).rawValue();
                    elems.write(i, handle);
                }
            }
            finally {
                JNIUtil.ReleaseLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)res, (CLongPointer)elems, (int)0);
            }
            scope.setObjectResult((JNI.JObject)res);
        }
        return (JNI.JLongArray)scope.getObjectResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_libgraal_runtime_HotSpotToSVMCalls_finishRegistration")
    static void finishRegistration(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, JNI.JLongArray svmRegistrations) {
        try (HotSpotToSVMScope s = new HotSpotToSVMScope((Enum)Id.FinishRegistration, env);){
            long len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)svmRegistrations);
            CLongPointer elems = JNIUtil.GetLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)svmRegistrations, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
            try {
                ObjectHandles globalHandles = ObjectHandles.getGlobal();
                int i = 0;
                while ((long)i < len) {
                    HotSpotGraalManagement registration = (HotSpotGraalManagement)globalHandles.get((ObjectHandle)WordFactory.pointer((long)elems.read(i)));
                    registration.finishRegistration();
                    ++i;
                }
            }
            finally {
                JNIUtil.ReleaseLongArrayElements((JNI.JNIEnv)env, (JNI.JLongArray)svmRegistrations, (CLongPointer)elems, (int)2);
            }
        }
    }

    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_libgraal_runtime_HotSpotToSVMCalls_getRegistrationName")
    static JNI.JString getRegistrationName(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long svmRegistration) {
        HotSpotToSVMScope scope;
        try (HotSpotToSVMScope s = scope = new HotSpotToSVMScope((Enum)Id.GetRegistrationName, env);){
            ObjectHandles globalHandles = ObjectHandles.getGlobal();
            HotSpotGraalManagement registration = (HotSpotGraalManagement)globalHandles.get((ObjectHandle)WordFactory.pointer((long)svmRegistration));
            String name = registration.getName();
            scope.setObjectResult((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)env, (String)name));
        }
        return (JNI.JString)scope.getObjectResult();
    }

    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_libgraal_runtime_HotSpotToSVMCalls_getMBeanInfo")
    static JNI.JByteArray getMBeanInfo(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long svmRegistration) {
        HotSpotToSVMScope scope;
        try (HotSpotToSVMScope s = scope = new HotSpotToSVMScope((Enum)Id.GetMBeanInfo, env);){
            ObjectHandles globalHandles = ObjectHandles.getGlobal();
            HotSpotGraalManagement registration = (HotSpotGraalManagement)globalHandles.get((ObjectHandle)WordFactory.pointer((long)svmRegistration));
            MBeanInfo info = registration.getBean().getMBeanInfo();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("bean.class", info.getClassName());
            map.put("bean.description", info.getDescription());
            for (MBeanAttributeInfo attr : info.getAttributes()) {
                String name = attr.getName();
                map.put("attr." + name + ".name", name);
                map.put("attr." + name + ".type", attr.getType());
                map.put("attr." + name + ".description", attr.getDescription());
                map.put("attr." + name + ".r", attr.isReadable());
                map.put("attr." + name + ".w", attr.isWritable());
                map.put("attr." + name + ".i", attr.isIs());
            }
            int opCounter = 0;
            for (MBeanOperationInfo op : info.getOperations()) {
                String name = op.getName();
                map.put("op." + ++opCounter + ".id", opCounter);
                map.put("op." + opCounter + ".name", name);
                map.put("op." + opCounter + ".type", op.getReturnType());
                map.put("op." + opCounter + ".description", op.getDescription());
                map.put("op." + opCounter + ".i", op.getImpact());
                for (MBeanParameterInfo param : op.getSignature()) {
                    String paramName = param.getName();
                    map.put("op." + opCounter + ".arg." + paramName + ".name", paramName);
                    map.put("op." + opCounter + ".arg." + paramName + ".description", param.getDescription());
                    map.put("op." + opCounter + ".arg." + paramName + ".type", param.getType());
                }
            }
            scope.setObjectResult((JNI.JObject)HotSpotToSVMEntryPoints.mapToRaw(env, map));
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_libgraal_runtime_HotSpotToSVMCalls_getAttributes")
    static JNI.JByteArray getAttributes(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long svmRegistration, JNI.JObjectArray requiredAttributes) {
        HotSpotToSVMScope scope;
        try (HotSpotToSVMScope s = scope = new HotSpotToSVMScope((Enum)Id.GetAttributes, env);){
            int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)requiredAttributes);
            String[] attrNames = new String[len];
            for (int i = 0; i < len; ++i) {
                JNI.JString el = (JNI.JString)JNIUtil.GetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)requiredAttributes, (int)i);
                attrNames[i] = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)el);
            }
            HotSpotGraalManagement registration = (HotSpotGraalManagement)ObjectHandles.getGlobal().get((ObjectHandle)WordFactory.pointer((long)svmRegistration));
            AttributeList attributesList = registration.getBean().getAttributes(attrNames);
            scope.setObjectResult((JNI.JObject)HotSpotToSVMEntryPoints.attributeListToRaw(env, attributesList));
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_libgraal_runtime_HotSpotToSVMCalls_setAttributes")
    static JNI.JByteArray setAttributes(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long svmRegistration, JNI.JByteArray attributes) {
        HotSpotToSVMScope scope;
        try (HotSpotToSVMScope s = scope = new HotSpotToSVMScope((Enum)Id.SetAttributes, env);){
            Map<String, Object> map = HotSpotToSVMEntryPoints.rawToMap(env, attributes);
            AttributeList attributesList = new AttributeList();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                attributesList.add(new Attribute(entry.getKey(), entry.getValue()));
            }
            HotSpotGraalManagement registration = (HotSpotGraalManagement)ObjectHandles.getGlobal().get((ObjectHandle)WordFactory.pointer((long)svmRegistration));
            attributesList = registration.getBean().setAttributes(attributesList);
            scope.setObjectResult((JNI.JObject)HotSpotToSVMEntryPoints.attributeListToRaw(env, attributesList));
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    @CEntryPoint(name="Java_org_graalvm_compiler_hotspot_management_libgraal_runtime_HotSpotToSVMCalls_invoke")
    static JNI.JByteArray invoke(JNI.JNIEnv env, JNI.JClass hsClazz, @CEntryPoint.IsolateThreadContext long isolateThreadId, long svmRegistration, JNI.JString hsActionName, JNI.JByteArray hsParams, JNI.JObjectArray hsSignature) {
        HotSpotToSVMScope scope;
        try (HotSpotToSVMScope s = scope = new HotSpotToSVMScope((Enum)Id.Invoke, env);){
            String actionName = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)hsActionName);
            int len = hsSignature.isNull() ? 0 : JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)hsSignature);
            String[] signature = new String[len];
            for (int i = 0; i < len; ++i) {
                signature[i] = JNIUtil.createString((JNI.JNIEnv)env, (JNI.JString)((JNI.JString)JNIUtil.GetObjectArrayElement((JNI.JNIEnv)env, (JNI.JObjectArray)hsSignature, (int)i)));
            }
            Map<String, Object> map = HotSpotToSVMEntryPoints.rawToMap(env, hsParams);
            Object[] params = map.values().toArray(new Object[map.size()]);
            HotSpotGraalManagement registration = (HotSpotGraalManagement)ObjectHandles.getGlobal().get((ObjectHandle)WordFactory.pointer((long)svmRegistration));
            try {
                Object result = registration.getBean().invoke(actionName, params, signature);
                AttributeList attributesList = new AttributeList();
                if (result != null) {
                    attributesList.add(new Attribute("result", result));
                }
                scope.setObjectResult((JNI.JObject)HotSpotToSVMEntryPoints.attributeListToRaw(env, attributesList));
            }
            catch (MBeanException | ReflectionException e) {
                scope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
        }
        return (JNI.JByteArray)scope.getObjectResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> rawToMap(JNI.JNIEnv env, JNI.JByteArray raw) {
        int len = JNIUtil.GetArrayLength((JNI.JNIEnv)env, (JNI.JArray)raw);
        byte[] serialized = new byte[len];
        CCharPointer elems = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)raw, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            CTypeConversion.asByteBuffer((PointerBase)elems, (int)len).get(serialized);
        }
        finally {
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)raw, (CCharPointer)elems, (int)0);
        }
        return OptionsEncoder.decode((byte[])serialized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JNI.JByteArray mapToRaw(JNI.JNIEnv env, Map<String, Object> map) {
        byte[] serialized = OptionsEncoder.encode(map);
        JNI.JByteArray res = JNIUtil.NewByteArray((JNI.JNIEnv)env, (int)serialized.length);
        CCharPointer elems = JNIUtil.GetByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)res, (JNI.JValue)((JNI.JValue)WordFactory.nullPointer()));
        try {
            CTypeConversion.asByteBuffer((PointerBase)elems, (int)serialized.length).put(serialized);
        }
        finally {
            JNIUtil.ReleaseByteArrayElements((JNI.JNIEnv)env, (JNI.JByteArray)res, (CCharPointer)elems, (int)0);
        }
        return res;
    }

    private static JNI.JByteArray attributeListToRaw(JNI.JNIEnv env, AttributeList attributesList) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Object item : attributesList) {
            Attribute attr = (Attribute)item;
            values.put(attr.getName(), attr.getValue());
        }
        return HotSpotToSVMEntryPoints.mapToRaw(env, values);
    }
}

