/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.Pointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.tools.Logger;
import java.util.ArrayDeque;
import java.util.Deque;

public class PointerScope
implements AutoCloseable {
    private static final Logger logger = Logger.create(PointerScope.class);
    static final ThreadLocal<Deque<PointerScope>> scopeStack = new ThreadLocal<Deque<PointerScope>>(){

        @Override
        protected Deque initialValue() {
            return new ArrayDeque();
        }
    };
    Deque<Pointer> pointerStack = new ArrayDeque<Pointer>();
    boolean deallocateOnClose = true;

    public static PointerScope getInnerScope() {
        return scopeStack.get().peek();
    }

    public PointerScope() {
        this(true);
    }

    public PointerScope(boolean deallocateOnClose) {
        if (logger.isDebugEnabled()) {
            logger.debug("Opening " + this);
        }
        this.deallocateOnClose = deallocateOnClose;
        scopeStack.get().push(this);
    }

    public PointerScope deallocateOnClose(boolean deallocateOnClose) {
        this.deallocateOnClose = deallocateOnClose;
        return this;
    }

    public boolean deallocateOnClose() {
        return this.deallocateOnClose;
    }

    public PointerScope attach(Pointer p) {
        if (logger.isDebugEnabled()) {
            logger.debug("Attaching " + p + " to " + this);
        }
        this.pointerStack.push(p);
        return this;
    }

    public PointerScope detach(Pointer p) {
        if (logger.isDebugEnabled()) {
            logger.debug("Detaching " + p + " from " + this);
        }
        this.pointerStack.remove(p);
        return this;
    }

    @Override
    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("Closing " + this);
        }
        if (this.deallocateOnClose()) {
            this.deallocate();
        }
        scopeStack.get().remove(this);
    }

    public void deallocate() {
        if (logger.isDebugEnabled()) {
            logger.debug("Deallocating " + this);
        }
        while (this.pointerStack.size() > 0) {
            this.pointerStack.pop().deallocate();
        }
        this.pointerStack = null;
    }
}

