/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.UShortIndexer;

public class UShortArrayIndexer
extends UShortIndexer {
    protected short[] array;

    public UShortArrayIndexer(short[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public UShortArrayIndexer(short[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public short[] array() {
        return this.array;
    }

    @Override
    public int get(long i) {
        return this.array[(int)i] & 0xFFFF;
    }

    @Override
    public UShortIndexer get(long i, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[(int)i * (int)this.strides[0] + n] & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j] & 0xFFFF;
    }

    @Override
    public UShortIndexer get(long i, long j, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] & 0xFFFF;
    }

    @Override
    public int get(long ... indices) {
        return this.array[(int)this.index(indices)] & 0xFFFF;
    }

    @Override
    public UShortIndexer get(long[] indices, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[(int)this.index(indices) + n] & 0xFFFF;
        }
        return this;
    }

    @Override
    public UShortIndexer put(long i, int s) {
        this.array[(int)i] = (short)s;
        return this;
    }

    @Override
    public UShortIndexer put(long i, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = (short)s[offset + n];
        }
        return this;
    }

    @Override
    public UShortIndexer put(long i, long j, int s) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = (short)s;
        return this;
    }

    @Override
    public UShortIndexer put(long i, long j, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = (short)s[offset + n];
        }
        return this;
    }

    @Override
    public UShortIndexer put(long i, long j, long k, int s) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = (short)s;
        return this;
    }

    @Override
    public UShortIndexer put(long[] indices, int s) {
        this.array[(int)this.index((long[])indices)] = (short)s;
        return this;
    }

    @Override
    public UShortIndexer put(long[] indices, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = (short)s[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

