/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.modules.openide.loaders.AWTTask;
import org.netbeans.modules.openide.loaders.DataObjectAccessor;
import org.openide.awt.AcceleratorBinding;
import org.openide.awt.Actions;
import org.openide.awt.ToolbarPool;
import org.openide.awt.ToolbarWithOverflow;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.util.ImageUtilities;
import org.openide.util.Task;
import org.openide.util.actions.Presenter;

public class Toolbar
extends ToolbarWithOverflow {
    @Deprecated
    public static final int BASIC_HEIGHT = 34;
    static final Logger LOG = Logger.getLogger(Toolbar.class.getName());
    private String displayName;
    private DataFolder backingFolder;
    private Folder processor;
    private static final boolean isMetalLaF = MetalLookAndFeel.class.isAssignableFrom(UIManager.getLookAndFeel().getClass());
    static final long serialVersionUID = 5011742660516204764L;
    private JButton label;
    private static final Insets emptyInsets;
    private static Action emptyAction;

    public Toolbar() {
        this("");
    }

    public Toolbar(String string) {
        this(string, string, false);
    }

    public Toolbar(String string, String string2) {
        this(string, string2, false);
    }

    public Toolbar(String string, boolean bl) {
        this(string, string, bl);
    }

    Toolbar(DataFolder dataFolder) {
        this.backingFolder = dataFolder;
        this.initAll(dataFolder.getName(), false);
        this.putClientProperty("folder", dataFolder);
    }

    public boolean isOpaque() {
        if (null != UIManager.get("NbMainWindow.showCustomBackground")) {
            return !UIManager.getBoolean("NbMainWindow.showCustomBackground");
        }
        return super.isOpaque();
    }

    DataFolder getFolder() {
        return this.backingFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Folder waitFinished() {
        if (this.backingFolder == null) {
            return null;
        }
        Toolbar toolbar = this;
        synchronized (toolbar) {
            if (this.processor == null && this.isVisible()) {
                this.processor = new Folder();
            }
            return this.processor;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.waitFinished();
    }

    public Component[] getComponents() {
        this.waitFinished();
        return super.getComponents();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.waitFinished();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof AbstractButton) {
            component.setFocusable(false);
            ((JComponent)component).setOpaque(false);
            if (isMetalLaF) {
                ((AbstractButton)component).setBorderPainted(false);
                ((AbstractButton)component).setOpaque(false);
            }
            if (!isMetalLaF) {
                ((AbstractButton)component).setMargin(emptyInsets);
            }
            if (null != this.label && component != this.label) {
                this.remove(this.label);
                this.label = null;
            }
        } else if (component instanceof JToolBar.Separator) {
            JToolBar.Separator separator = (JToolBar.Separator)component;
            if (this.getOrientation() == 1) {
                separator.setOrientation(0);
            } else {
                separator.setOrientation(1);
            }
        }
        super.addImpl(component, object, n);
    }

    public Toolbar(String string, String string2, boolean bl) {
        this.setDisplayName(string2);
        this.initAll(string, bl);
    }

    @Deprecated
    public static int getBasicHeight() {
        return ToolbarPool.getDefault().getPreferredIconSize();
    }

    private void initAll(String string, boolean bl) {
        this.setName(string);
        this.setFloatable(bl);
        this.getAccessibleContext().setAccessibleName(this.displayName == null ? this.getName() : this.displayName);
        this.getAccessibleContext().setAccessibleDescription(this.getName());
    }

    public String getUIClassID() {
        if (UIManager.get("Nb.Toolbar.ui") != null) {
            return "Nb.Toolbar.ui";
        }
        return super.getUIClassID();
    }

    @Deprecated
    public static int rowCount(int n) {
        return 1;
    }

    @Deprecated
    public void setDnDListener(DnDListener dnDListener) {
    }

    @Deprecated
    protected void fireDragToolbar(int n, int n2, int n3) {
    }

    @Deprecated
    protected void fireDropToolbar(int n, int n2, int n3) {
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            if (this.backingFolder.isValid()) {
                try {
                    return this.backingFolder.getNodeDelegate().getDisplayName();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return this.backingFolder.getName();
        }
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    private static void acceleratorBindingsWarmUp() {
        if (null == emptyAction) {
            emptyAction = new Action(){

                @Override
                public Object getValue(String string) {
                    return null;
                }

                @Override
                public void putValue(String string, Object object) {
                }

                @Override
                public void setEnabled(boolean bl) {
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            };
            AcceleratorBinding.setAccelerator((Action)emptyAction, (FileObject)FileUtil.getConfigRoot());
        }
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
        if (null != this.backingFolder && null != this.processor) {
            this.processor.recreate();
        }
    }

    static {
        try {
            Class.forName(AcceleratorBinding.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
        emptyInsets = new Insets(1, 1, 1, 1);
    }

    private static class DefaultIconToggleButton
    extends JToggleButton {
        private Icon unknownIcon;

        private DefaultIconToggleButton() {
        }

        @Override
        public Icon getIcon() {
            Icon icon = super.getIcon();
            if (null == icon && (null == this.getText() || this.getText().length() == 0)) {
                if (this.unknownIcon == null) {
                    this.unknownIcon = ImageUtilities.loadImageIcon((String)"org/openide/loaders/unknown.gif", (boolean)false);
                }
                icon = this.unknownIcon;
            }
            return icon;
        }
    }

    private static class DefaultIconButton
    extends JButton {
        private Icon unknownIcon;

        private DefaultIconButton() {
        }

        @Override
        public Icon getIcon() {
            Icon icon = super.getIcon();
            if (null == icon && (null == this.getText() || this.getText().length() == 0)) {
                if (this.unknownIcon == null) {
                    this.unknownIcon = ImageUtilities.loadImageIcon((String)"org/openide/loaders/unknown.gif", (boolean)false);
                }
                icon = this.unknownIcon;
            }
            return icon;
        }
    }

    @Deprecated
    public static class DnDEvent
    extends EventObject {
        public static final int DND_ONE = 1;
        public static final int DND_END = 2;
        public static final int DND_LINE = 3;
        private String name;
        private int dx;
        private int dy;
        private int type;
        static final long serialVersionUID = 4389530973297716699L;

        public DnDEvent(Toolbar toolbar, String string, int n, int n2, int n3) {
            super((Object)toolbar);
            this.name = string;
            this.dx = n;
            this.dy = n2;
            this.type = n3;
        }

        public String getName() {
            return this.name;
        }

        public int getDX() {
            return this.dx;
        }

        public int getDY() {
            return this.dy;
        }

        public int getType() {
            return this.type;
        }
    }

    @Deprecated
    public static interface DnDListener
    extends EventListener {
        public void dragToolbar(DnDEvent var1);

        public void dropToolbar(DnDEvent var1);
    }

    final class Folder
    extends FolderInstance {
        private Map<Object, DataObject> cookiesToObjects;

        public Folder() {
            super(Toolbar.this.backingFolder);
            this.cookiesToObjects = new HashMap<Object, DataObject>();
            DataObjectAccessor.DEFAULT.precreateInstances(this);
            this.recreate();
            Toolbar.acceleratorBindingsWarmUp();
        }

        @Override
        public String instanceName() {
            return ((Object)((Object)Toolbar.this)).getClass().getName();
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return ((Object)((Object)Toolbar.this)).getClass();
        }

        @Override
        protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Object object = super.instanceForCookie(dataObject, instanceCookie);
            this.cookiesToObjects.put(object, dataObject);
            return object;
        }

        @Override
        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            boolean bl;
            boolean bl2;
            if (instanceCookie instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)instanceCookie;
                bl2 = of.instanceOf(Action.class);
                bl = of.instanceOf(Component.class) || of.instanceOf(Presenter.Toolbar.class) || bl2;
            } else {
                Class clazz = instanceCookie.instanceClass();
                bl2 = Action.class.isAssignableFrom(clazz);
                boolean bl3 = bl = Component.class.isAssignableFrom(clazz) || Presenter.Toolbar.class.isAssignableFrom(clazz) || bl2;
            }
            if (bl2) {
                instanceCookie.instanceCreate();
            }
            return bl ? instanceCookie : null;
        }

        @Override
        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            Toolbar.this.removeAll();
            for (int i = 0; i < instanceCookieArray.length; ++i) {
                try {
                    Object object = instanceCookieArray[i].instanceCreate();
                    DataObject dataObject = this.cookiesToObjects.get(object);
                    if (object instanceof Presenter.Toolbar) {
                        if (object instanceof Action && dataObject != null) {
                            AcceleratorBinding.setAccelerator((Action)((Action)object), (FileObject)dataObject.getPrimaryFile());
                        }
                        object = ((Presenter.Toolbar)object).getToolbarPresenter();
                    }
                    if (object instanceof Component) {
                        if (object instanceof JComponent && "Fixed".equals(((JComponent)object).getClientProperty("Toolbar"))) {
                            Toolbar.this.removeAll();
                            Toolbar.this.setBorder(null);
                        }
                        if (object instanceof JComponent) {
                            if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
                                ((JComponent)object).putClientProperty("PreferredIconSize", new Integer(24));
                            }
                            ((JComponent)object).putClientProperty("file", dataObject);
                        }
                        Toolbar.this.add((Component)object);
                        continue;
                    }
                    if (!(object instanceof Action)) continue;
                    Action action = (Action)object;
                    AbstractButton abstractButton = action.getValue("openide.awt.actionToggle") != null ? new DefaultIconToggleButton() : new DefaultIconButton();
                    if (ToolbarPool.getDefault().getPreferredIconSize() == 24) {
                        abstractButton.putClientProperty("PreferredIconSize", new Integer(24));
                    }
                    if (null == action.getValue("SmallIcon") && (null == action.getValue("Name") || action.getValue("Name").toString().length() == 0)) {
                        action.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/openide/loaders/unknown.gif", (boolean)false));
                    }
                    Actions.connect((AbstractButton)abstractButton, (Action)action);
                    abstractButton.putClientProperty("file", dataObject);
                    Toolbar.this.add(abstractButton);
                    if (dataObject == null) continue;
                    AcceleratorBinding.setAccelerator((Action)action, (FileObject)dataObject.getPrimaryFile());
                    continue;
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOG.log(Level.WARNING, null, classNotFoundException);
                    continue;
                }
                finally {
                    this.cookiesToObjects.clear();
                }
            }
            if (instanceCookieArray.length == 0) {
                Toolbar.this.label = new JButton("<" + Actions.cutAmpersand((String)Toolbar.this.getDisplayName()) + ">");
                Toolbar.this.add(Toolbar.this.label);
            }
            Toolbar.this.invalidate();
            return Toolbar.this;
        }

        @Override
        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable, this);
        }
    }
}

