/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jmx.impl;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.jmx.JmxApplicationsSupport;
import org.graalvm.visualvm.jmx.JmxConnectionCustomizer;
import org.graalvm.visualvm.jmx.impl.JmxApplication;
import org.graalvm.visualvm.jmx.impl.JmxConnectionConfigurator;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class AddJMXConnectionAction
extends SingleDataSourceAction<Host> {
    private static final String ICON_PATH = "org/graalvm/visualvm/jmx/resources/addJmxApplication.png";
    private static final Image ICON = ImageUtilities.loadImage((String)"org/graalvm/visualvm/jmx/resources/addJmxApplication.png");
    private boolean tracksSelection = false;
    private static AddJMXConnectionAction alwaysEnabled;
    private static AddJMXConnectionAction selectionAware;

    public static synchronized AddJMXConnectionAction alwaysEnabled() {
        if (alwaysEnabled == null) {
            alwaysEnabled = new AddJMXConnectionAction();
            alwaysEnabled.putValue("SmallIcon", new ImageIcon(ICON));
            alwaysEnabled.putValue("iconBase", ICON_PATH);
        }
        return alwaysEnabled;
    }

    public static synchronized AddJMXConnectionAction selectionAware() {
        if (selectionAware == null) {
            selectionAware = new AddJMXConnectionAction();
            AddJMXConnectionAction.selectionAware.tracksSelection = true;
        }
        return selectionAware;
    }

    protected void actionPerformed(Host host, ActionEvent actionEvent) {
        final JmxConnectionConfigurator.Result result = JmxConnectionConfigurator.getResult();
        final JmxConnectionCustomizer.Setup setup = result.getSetup();
        if (setup != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    JmxApplication application = (JmxApplication)JmxApplicationsSupport.getInstance().createJmxApplicationInteractive(setup.getConnectionString(), setup.getDisplayName(), setup.getEnvironmentProvider(), setup.isConnectionPersistent(), setup.allowsInsecureConnection());
                    if (application == null) {
                        result.cancelled();
                    } else {
                        result.accepted(application);
                    }
                }
            });
        } else {
            result.cancelled();
        }
    }

    protected boolean isEnabled(Host host) {
        return host != Host.UNKNOWN_HOST;
    }

    protected void updateState(Set<Host> selectedHosts) {
        if (this.tracksSelection) {
            super.updateState(selectedHosts);
        }
    }

    private AddJMXConnectionAction() {
        super(Host.class);
        this.putValue("Name", NbBundle.getMessage(AddJMXConnectionAction.class, (String)"MSG_Add_JMX_Connection"));
        this.putValue("ShortDescription", NbBundle.getMessage(AddJMXConnectionAction.class, (String)"ToolTip_Add_JMX_Connection"));
    }
}

