/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;

public final class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;

    @NotNull
    public static String getHomePath() {
        String string2 = PathManager.getHomePath(true);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result2 = ourHomePath;
        if (result2 != null) {
            return result2;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result2 = ourHomePath;
            if (result2 != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result2;
            }
            String explicit = PathManager.getExplicitPath("idea.home.path");
            if (explicit == null) {
                explicit = PathManager.getExplicitPath("idea.home");
            }
            if (explicit != null) {
                result2 = explicit;
                if (!Files.isDirectory(Paths.get(result2, new String[0]), new LinkOption[0])) {
                    ourHomePath = result2;
                    throw new RuntimeException("Invalid home path '" + result2 + "'");
                }
            } else if (insideIde && (result2 = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result2 != null && SystemInfoRt.isWindows) {
                try {
                    result2 = Paths.get(result2, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ourBinDirectories = result2 == null ? Collections.emptyList() : PathManager.getBinDirectories(Paths.get(result2, new String[0]));
            ourHomePath = result2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result2;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result2 = ourBinDirectories;
        if (result2 == null) {
            PathManager.getHomePath(true);
            result2 = ourBinDirectories;
        }
        return result2;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        String rootPath;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        Path root2 = Paths.get(rootPath, new String[0]).toAbsolutePath();
        while ((root2 = root2.getParent()) != null && !PathManager.isIdeaHome(root2) && !PathManager.isKotlinIdeRepoHome(root2)) {
        }
        if (root2 != null && PathManager.isKotlinIdeRepoHome(root2)) {
            root2 = root2.resolve("intellij");
        }
        return root2 != null ? root2.toString() : null;
    }

    private static boolean isKotlinIdeRepoHome(@NotNull Path path2) {
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        boolean containsRootKotlinModuleFile = Files.isRegularFile(path2.resolve("kotlin/idea/kotlin.idea.iml"), new LinkOption[0]) || Files.isRegularFile(path2.resolve("idea/kotlin.idea.iml"), new LinkOption[0]);
        return Files.isDirectory(path2, new LinkOption[0]) && containsRootKotlinModuleFile && Files.isDirectory(path2.resolve("intellij"), new LinkOption[0]) && PathManager.isIdeaHome(path2.resolve("intellij"));
    }

    private static boolean isIdeaHome(Path root2) {
        for (Path binDir : PathManager.getBinDirectories(root2)) {
            if (!Files.isRegularFile(binDir.resolve("idea.properties"), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getBinDirectories(Path root2) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        @NonNls String[] subDirs = new String[]{"bin", "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            Path dir = root2.resolve(subDir);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        String string2 = PathManager.getHomePath() + '/' + "bin";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Nullable
    public static Path findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate2 = binDir.resolve(fileName);
            if (!Files.isRegularFile(candidate2, new LinkOption[0])) continue;
            return candidate2;
        }
        return null;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string2 = ourConfigPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(12);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath("idea.config.path");
        ourConfigPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + "config");
        String string3 = ourConfigPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(16);
        }
        String string2 = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string2 = ourSystemPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(25);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath("idea.system.path");
        ourSystemPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + "system");
        String string3 = ourSystemPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(27);
        }
        String string2 = PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        return string2;
    }

    @NotNull
    public static File getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        File file2 = Paths.get(indexRootPath, new String[0]).toFile();
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        return file2;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context, @NotNull String path2) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        if ((url = context.getResource(path2)) == null) {
            url = ClassLoader.getSystemResource(path2.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path2) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, @NotNull String resourcePath) {
        URL url;
        if (cl == null) {
            PathManager.$$$reportNull$$$0(36);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        return (url = cl.getResource(resourcePath)) != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.length() == 0 || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            File result2;
            try {
                result2 = new File(resourceURL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + resourceURL.toString() + "'", e);
            }
            String path2 = result2.getPath();
            String testPath = path2.replace('\\', '/');
            String testResourcePath = resourcePath.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase(testPath, testResourcePath)) {
                resultPath = path2.substring(0, path2.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            String jarPath = PathManager.splitJarUrl(resourceURL.getFile());
            if (jarPath != null) {
                resultPath = jarPath;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @Nullable
    private static String splitJarUrl(@NotNull String url) {
        int pivot;
        if (url == null) {
            PathManager.$$$reportNull$$$0(38);
        }
        if ((pivot = url.indexOf("!/")) < 0) {
            return null;
        }
        String jarPath = url.substring(0, pivot);
        boolean startsWithConcatenation = true;
        int offset2 = 0;
        for (String prefix : new String[]{"jar", ":"}) {
            int prefixLen = prefix.length();
            if (!jarPath.regionMatches(offset2, prefix, 0, prefixLen)) {
                startsWithConcatenation = false;
                break;
            }
            offset2 += prefixLen;
        }
        if (startsWithConcatenation) {
            jarPath = jarPath.substring("jar".length() + 1);
        }
        if (!jarPath.startsWith("file")) {
            return jarPath;
        }
        try {
            File result2;
            URL parsedUrl = new URL(jarPath);
            try {
                result2 = new File(parsedUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + parsedUrl.toString() + "'", e);
            }
            return result2.getPath().replace('\\', '/');
        }
        catch (Exception e) {
            jarPath = jarPath.substring("file".length());
            if (jarPath.startsWith("://")) {
                return jarPath.substring("://".length());
            }
            if (!jarPath.isEmpty() && jarPath.charAt(0) == ':') {
                return jarPath.substring(1);
            }
            return jarPath;
        }
    }

    @NotNull
    @NonNls
    public static String getCommunityHomePath() {
        String path2 = PathManager.getHomePath();
        if (Files.isDirectory(Paths.get(path2, "community/.idea"), new LinkOption[0])) {
            String string2 = path2 + "/community";
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(42);
            }
            return string2;
        }
        if (Files.isDirectory(Paths.get(path2, "ultimate/community/.idea"), new LinkOption[0])) {
            String string3 = path2 + "/ultimate/community";
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(43);
            }
            return string3;
        }
        String string4 = path2;
        if (string4 == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        return string4;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) != null ? Paths.get(resourceRoot, new String[0]).toAbsolutePath().toString() : null;
    }

    private static void log(@NonNls String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path2) {
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(55);
        }
        if (path2.startsWith("~/") || path2.startsWith("~\\")) {
            path2 = SystemProperties.getUserHome() + path2.substring(1);
        }
        String string2 = Paths.get(path2, new String[0]).toAbsolutePath().normalize().toString();
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(56);
        }
        return string2;
    }

    @Nullable
    private static String getExplicitPath(String property2) {
        String path2 = System.getProperty(property2);
        return path2 != null ? PathManager.getAbsolutePath(StringUtilRt.unquoteString(path2, '\"')) : null;
    }

    private static String platformPath(@NonNls String selector, @NonNls String macDir, @NonNls String macSub, @NonNls String winVar, @NonNls String winSub, @NonNls String xdgVar, @NonNls String xdgDfl, @NonNls String xdgSub) {
        String userHome = SystemProperties.getUserHome();
        String vendorName = PathManager.vendorName();
        if (SystemInfoRt.isMac) {
            @NonNls String dir = userHome + "/Library/" + macDir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '/' + selector;
            }
            if (!macSub.isEmpty()) {
                dir = dir + '/' + macSub;
            }
            return dir;
        }
        if (SystemInfoRt.isWindows) {
            @NonNls String dir = System.getenv(winVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir = dir + '\\' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '\\' + selector;
            }
            if (!winSub.isEmpty()) {
                dir = dir + '\\' + winSub;
            }
            return dir;
        }
        if (SystemInfoRt.isUnix) {
            String dir = System.getenv(xdgVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + '/' + xdgDfl;
            }
            dir = dir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir = dir + '/' + selector;
            }
            if (!xdgSub.isEmpty()) {
                dir = dir + '/' + xdgSub;
            }
            return dir;
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static String vendorName() {
        String property2 = System.getProperty("idea.vendor.name");
        if (property2 == null) {
            try {
                Class<?> ex = Class.forName("org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup2 = MethodHandles.lookup();
                Object instance2 = lookup2.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property2 = lookup2.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.setProperty("idea.vendor.name", property2 != null ? property2 : "JetBrains");
        }
        return property2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 55: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 55: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 3: 
            case 35: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 16: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoot";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactFileName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactDirNameInPluginLayout";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactDirNameInBuildLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/PathManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonDataPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactPath";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isKotlinIdeRepoHome";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getJarArtifactPath";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactPath";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 55: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

