/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;

public abstract class EdtInvocationManager {
    private static final AtomicReference<EdtInvocationManager> ourInstance = new AtomicReference();
    private static final Method dispatchEventMethod = Objects.requireNonNull(ReflectionUtil.getDeclaredMethod(EventQueue.class, "dispatchEvent", AWTEvent.class));

    @TestOnly
    public static void dispatchAllInvocationEvents() {
        AWTEvent event;
        assert (EdtInvocationManager.getInstance().isEventDispatchThread()) : Thread.currentThread() + "; EDT: " + EdtInvocationManager.getEventQueueThread();
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        int i = 1;
        while ((event = eventQueue.peekEvent()) != null) {
            try {
                event = eventQueue.getNextEvent();
                if (event instanceof InvocationEvent) {
                    dispatchEventMethod.invoke((Object)eventQueue, event);
                }
            }
            catch (InvocationTargetException e) {
                ExceptionUtil.rethrowAllAsUnchecked(e.getCause());
            }
            catch (Exception e) {
                ExceptionUtil.rethrow(e);
            }
            if (i % 10000 == 0) {
                System.out.println("Suspiciously many (" + i + ") AWT events, last dispatched " + event);
            }
            ++i;
        }
    }

    @NotNull
    private static Thread getEventQueueThread() {
        Thread thread;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            Method method = ReflectionUtil.getDeclaredMethod(EventQueue.class, "getDispatchThread", new Class[0]);
            thread = (Thread)method.invoke((Object)eventQueue, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (thread == null) {
            EdtInvocationManager.$$$reportNull$$$0(0);
        }
        return thread;
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager edtInvocationManager;
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(1);
        }
        if ((edtInvocationManager = EdtInvocationManager.getInstance()).isEventDispatchThread()) {
            runnable.run();
        } else {
            edtInvocationManager.invokeLater(runnable);
        }
    }

    public abstract boolean isEventDispatchThread();

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager result2 = ourInstance.get();
        if (result2 == null && !ourInstance.compareAndSet(null, result2 = new SwingEdtInvocationManager())) {
            result2 = ourInstance.get();
        }
        EdtInvocationManager edtInvocationManager = result2;
        if (edtInvocationManager == null) {
            EdtInvocationManager.$$$reportNull$$$0(2);
        }
        return edtInvocationManager;
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        EdtInvocationManager manager;
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(5);
        }
        if ((manager = EdtInvocationManager.getInstance()).isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                manager.invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getInstance(EdtInvocationManager.class).error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtInvocationManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventQueueThread";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEdtInvocationManager";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restoreEdtInvocationManager";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        @Override
        public boolean isEventDispatchThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        public void invokeLater(@NotNull Runnable task) {
            if (task == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(0);
            }
            EventQueue.invokeLater(task);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task) throws InvocationTargetException, InterruptedException {
            if (task == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(1);
            }
            EventQueue.invokeAndWait(task);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "task";
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/EdtInvocationManager$SwingEdtInvocationManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeLater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAndWait";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

