/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.gradle.kotlin.dsl.execution.CharSequenceExtensionsKt;
import org.gradle.kotlin.dsl.execution.ProgramSourceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\fH\u0002\u00a2\u0006\u0002\u0010\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001b\u0010\u0013\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001aJ\u001f\u0010\u001b\u001a\u00020\u00002\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\f\"\u00020\t\u00a2\u0006\u0002\u0010\u001cJ\u001b\u0010\u001b\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0000\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\tJ\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\""}, d2={"Lorg/gradle/kotlin/dsl/execution/ProgramText;", "", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "complementOf", "Ljava/util/ArrayList;", "Lkotlin/ranges/IntRange;", "Lkotlin/collections/ArrayList;", "ranges", "", "([Lkotlin/ranges/IntRange;)Ljava/util/ArrayList;", "component1", "copy", "equals", "", "other", "erase", "", "erase$kotlin_dsl", "hashCode", "", "lineNumberOf", "index", "lineNumberOf$kotlin_dsl", "preserve", "([Lkotlin/ranges/IntRange;)Lorg/gradle/kotlin/dsl/execution/ProgramText;", "preserve$kotlin_dsl", "subText", "range", "toString", "Companion", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nProgramSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgramSource.kt\norg/gradle/kotlin/dsl/execution/ProgramText\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,155:1\n37#2,2:156\n6442#3:158\n*S KotlinDebug\n*F\n+ 1 ProgramSource.kt\norg/gradle/kotlin/dsl/execution/ProgramText\n*L\n54#1:156,2\n67#1:158\n*E\n"})
public final class ProgramText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;

    private ProgramText(String text) {
        this.text = text;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final ProgramText erase$kotlin_dsl(@NotNull List<IntRange> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        return ranges.isEmpty() ? this : new ProgramText(ProgramSourceKt.access$erase(this.text, ranges));
    }

    @NotNull
    public final ProgramText preserve(IntRange ... ranges) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        return this.erase$kotlin_dsl((List<IntRange>)this.complementOf(ranges));
    }

    @NotNull
    public final ProgramText preserve$kotlin_dsl(@NotNull List<IntRange> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        Collection $this$toTypedArray$iv = ranges;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IntRange[] intRangeArray = thisCollection$iv.toArray(new IntRange[0]);
        return this.preserve(Arrays.copyOf(intRangeArray, intRangeArray.length));
    }

    @NotNull
    public final ProgramText subText(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new ProgramText(StringsKt.substring((String)this.text, (IntRange)range));
    }

    public final int lineNumberOf$kotlin_dsl(int index) {
        return ((Number)CharSequenceExtensionsKt.lineAndColumnFor(this.text, index).getFirst()).intValue();
    }

    private final ArrayList<IntRange> complementOf(IntRange[] ranges) {
        if (!(!(ranges.length == 0))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Object[] $this$sortedBy$iv = ranges;
        boolean $i$f$sortedBy = false;
        List sortedRanges = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IntRange it = (IntRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFirst());
                it = (IntRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
            }
        });
        ArrayList<IntRange> rangesToErase = new ArrayList<IntRange>(ranges.length + 1);
        int last = 0;
        for (IntRange range : sortedRanges) {
            rangesToErase.add(RangesKt.until((int)last, (int)range.getFirst()));
            last = range.getLast() + 1;
        }
        int lastIndexToPreserve = ((IntRange)CollectionsKt.last((List)sortedRanges)).getLast();
        if (lastIndexToPreserve < StringsKt.getLastIndex((CharSequence)this.text)) {
            rangesToErase.add(new IntRange(lastIndexToPreserve + 1, StringsKt.getLastIndex((CharSequence)this.text)));
        }
        return rangesToErase;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final ProgramText copy(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new ProgramText(text);
    }

    public static /* synthetic */ ProgramText copy$default(ProgramText programText, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = programText.text;
        }
        return programText.copy(string2);
    }

    @NotNull
    public String toString() {
        return "ProgramText(text=" + this.text + ')';
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProgramText)) {
            return false;
        }
        ProgramText programText = (ProgramText)other;
        return Intrinsics.areEqual((Object)this.text, (Object)programText.text);
    }

    public /* synthetic */ ProgramText(String text, DefaultConstructorMarker $constructor_marker) {
        this(text);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/gradle/kotlin/dsl/execution/ProgramText$Companion;", "", "()V", "from", "Lorg/gradle/kotlin/dsl/execution/ProgramText;", "string", "", "from$kotlin_dsl", "kotlin-dsl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProgramText from$kotlin_dsl(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
            return new ProgramText(StringsKt.replace$default((String)string2, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

