/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import org.gradle.internal.snapshot.CompositeFileSystemSnapshot;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.MissingFileSnapshot;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RootTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class OutputSnapshotUtil {
    public static ImmutableSortedMap<String, FileSystemSnapshot> findOutputsStillPresentSincePreviousExecution(ImmutableSortedMap<String, FileSystemSnapshot> previousSnapshots, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredBeforeExecutionSnapshots) {
        return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(unfilteredBeforeExecutionSnapshots, (key, unfilteredBeforeExecution) -> {
            FileSystemSnapshot previous = (FileSystemSnapshot)previousSnapshots.get(key);
            if (previous == null) {
                return FileSystemSnapshot.EMPTY;
            }
            return OutputSnapshotUtil.findOutputPropertyStillPresentSincePreviousExecution(previous, unfilteredBeforeExecution);
        }));
    }

    @VisibleForTesting
    static FileSystemSnapshot findOutputPropertyStillPresentSincePreviousExecution(FileSystemSnapshot previous, FileSystemSnapshot current) {
        Map previousIndex = SnapshotUtil.indexByAbsolutePath((FileSystemSnapshot)previous);
        return OutputSnapshotUtil.filterSnapshot(current, (currentSnapshot, isRoot) -> previousIndex.containsKey(currentSnapshot.getAbsolutePath()));
    }

    public static ImmutableSortedMap<String, FileSystemSnapshot> filterOutputsAfterExecution(ImmutableSortedMap<String, FileSystemSnapshot> previousSnapshots, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredBeforeExecutionSnapshots, ImmutableSortedMap<String, FileSystemSnapshot> unfilteredAfterExecutionSnapshots) {
        return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(unfilteredAfterExecutionSnapshots, (propertyName, unfilteredAfterExecution) -> {
            assert (unfilteredAfterExecution != null);
            FileSystemSnapshot previous = (FileSystemSnapshot)previousSnapshots.get(propertyName);
            FileSystemSnapshot unfilteredBeforeExecution = (FileSystemSnapshot)unfilteredBeforeExecutionSnapshots.get(propertyName);
            return OutputSnapshotUtil.filterOutputAfterExecution(previous, unfilteredBeforeExecution, unfilteredAfterExecution);
        }));
    }

    @VisibleForTesting
    static FileSystemSnapshot filterOutputAfterExecution(@Nullable FileSystemSnapshot previous, FileSystemSnapshot unfilteredBeforeExecution, FileSystemSnapshot unfilteredAfterExecution) {
        Map beforeExecutionIndex = SnapshotUtil.indexByAbsolutePath((FileSystemSnapshot)unfilteredBeforeExecution);
        if (beforeExecutionIndex.isEmpty()) {
            return unfilteredAfterExecution;
        }
        Object previousIndex = previous != null ? SnapshotUtil.indexByAbsolutePath((FileSystemSnapshot)previous) : ImmutableMap.of();
        return OutputSnapshotUtil.filterSnapshot(unfilteredAfterExecution, (arg_0, arg_1) -> OutputSnapshotUtil.lambda$filterOutputAfterExecution$3((Map)previousIndex, beforeExecutionIndex, arg_0, arg_1));
    }

    private static boolean isOutputEntry(Set<String> previousLocations, Map<String, FileSystemLocationSnapshot> beforeExecutionSnapshots, FileSystemLocationSnapshot afterExecutionSnapshot, Boolean isRoot) {
        if (isRoot.booleanValue()) {
            return true;
        }
        FileSystemLocationSnapshot beforeSnapshot = beforeExecutionSnapshots.get(afterExecutionSnapshot.getAbsolutePath());
        if (beforeSnapshot == null) {
            return true;
        }
        if (!afterExecutionSnapshot.isContentAndMetadataUpToDate(beforeSnapshot)) {
            return true;
        }
        return previousLocations.contains(afterExecutionSnapshot.getAbsolutePath());
    }

    private static FileSystemSnapshot filterSnapshot(FileSystemSnapshot root, BiPredicate<FileSystemLocationSnapshot, Boolean> predicate) {
        SnapshotFilteringVisitor visitor = new SnapshotFilteringVisitor(predicate);
        root.accept((FileSystemSnapshotHierarchyVisitor)visitor);
        if (visitor.hasBeenFiltered()) {
            return CompositeFileSystemSnapshot.of(visitor.getNewRoots());
        }
        return root;
    }

    private static /* synthetic */ boolean lambda$filterOutputAfterExecution$3(Map previousIndex, Map beforeExecutionIndex, FileSystemLocationSnapshot afterExecutionSnapshot, Boolean isRoot) {
        return OutputSnapshotUtil.isOutputEntry(previousIndex.keySet(), beforeExecutionIndex, afterExecutionSnapshot, isRoot);
    }

    private static class SnapshotFilteringVisitor
    extends RootTrackingFileSystemSnapshotHierarchyVisitor {
        private final BiPredicate<FileSystemLocationSnapshot, Boolean> predicate;
        private final ImmutableList.Builder<FileSystemSnapshot> newRootsBuilder = ImmutableList.builder();
        private boolean hasBeenFiltered;
        private DirectorySnapshotBuilder directorySnapshotBuilder;
        private boolean currentRootFiltered;
        private DirectorySnapshot currentRoot;

        public SnapshotFilteringVisitor(BiPredicate<FileSystemLocationSnapshot, Boolean> predicate) {
            this.predicate = predicate;
        }

        public void enterDirectory(DirectorySnapshot directorySnapshot, boolean isRoot) {
            boolean isOutputDir = this.predicate.test((FileSystemLocationSnapshot)directorySnapshot, isRoot);
            DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy = isOutputDir ? DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS : DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.EXCLUDE_EMPTY_DIRS;
            this.directorySnapshotBuilder.enterDirectory(directorySnapshot, emptyDirectoryHandlingStrategy);
        }

        public SnapshotVisitResult visitEntry(final FileSystemLocationSnapshot snapshot, final boolean isRoot) {
            snapshot.accept(new FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor(){

                public void visitDirectory(DirectorySnapshot directorySnapshot) {
                    if (directorySnapshotBuilder == null) {
                        directorySnapshotBuilder = MerkleDirectorySnapshotBuilder.noSortingRequired();
                        currentRoot = directorySnapshot;
                        currentRootFiltered = false;
                    }
                }

                public void visitRegularFile(RegularFileSnapshot fileSnapshot) {
                    this.visitNonDirectoryEntry(snapshot, isRoot);
                }

                public void visitMissing(MissingFileSnapshot missingSnapshot) {
                    this.visitNonDirectoryEntry(snapshot, isRoot);
                }
            });
            return SnapshotVisitResult.CONTINUE;
        }

        private void visitNonDirectoryEntry(FileSystemLocationSnapshot snapshot, boolean isRoot) {
            if (!this.predicate.test(snapshot, isRoot)) {
                this.hasBeenFiltered = true;
                this.currentRootFiltered = true;
                return;
            }
            if (this.directorySnapshotBuilder == null) {
                this.newRootsBuilder.add((Object)snapshot);
            } else if (snapshot instanceof FileSystemLeafSnapshot) {
                this.directorySnapshotBuilder.visitLeafElement((FileSystemLeafSnapshot)snapshot);
            }
        }

        public void leaveDirectory(DirectorySnapshot directorySnapshot, boolean isRoot) {
            boolean excludedDir;
            boolean bl = excludedDir = this.directorySnapshotBuilder.leaveDirectory() == null;
            if (excludedDir) {
                this.currentRootFiltered = true;
                this.hasBeenFiltered = true;
            }
            if (isRoot) {
                FileSystemLocationSnapshot result = this.directorySnapshotBuilder.getResult();
                if (result != null) {
                    this.newRootsBuilder.add(this.currentRootFiltered ? result : this.currentRoot);
                }
                this.directorySnapshotBuilder = null;
                this.currentRoot = null;
            }
        }

        public ImmutableList<FileSystemSnapshot> getNewRoots() {
            return this.newRootsBuilder.build();
        }

        public boolean hasBeenFiltered() {
            return this.hasBeenFiltered;
        }
    }
}

