/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.model.annotations;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.properties.annotations.AbstractPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;

abstract class AbstractInputPropertyAnnotationHandler
extends AbstractPropertyAnnotationHandler {
    protected AbstractInputPropertyAnnotationHandler(Class<? extends Annotation> annotationType, ImmutableSet<Class<? extends Annotation>> allowedModifiers) {
        super(annotationType, PropertyAnnotationHandler.Kind.INPUT, allowedModifiers);
    }

    protected static void validateUnsupportedInputPropertyValueTypes(PropertyMetadata propertyMetadata, TypeValidationContext validationContext, Class<? extends Annotation> annotationType) {
        AbstractInputPropertyAnnotationHandler.validateUnsupportedPropertyValueType(annotationType, AbstractInputPropertyAnnotationHandler.unpackValueTypesOf(propertyMetadata), propertyMetadata, validationContext, ResolvedArtifactResult.class, "Extract artifact metadata and annotate with @Input", "Extract artifact files and annotate with @InputFiles");
    }

    private static void validateUnsupportedPropertyValueType(Class<? extends Annotation> annotationType, List<Class<?>> valueTypes, PropertyMetadata propertyMetadata, TypeValidationContext validationContext, Class<?> unsupportedType, String ... possibleSolutions) {
        if (valueTypes.stream().anyMatch(unsupportedType::isAssignableFrom)) {
            validationContext.visitPropertyProblem(problem -> {
                ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem.withId(ValidationProblemId.UNSUPPORTED_VALUE_TYPE)).forProperty(propertyMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> String.format("has @%s annotation used on property of type '%s'", annotationType.getSimpleName(), TypeOf.typeOf((Type)propertyMetadata.getDeclaredType().getType()).getSimpleName()))).happensBecause(() -> String.format("%s is not supported on task properties annotated with @%s", unsupportedType.getSimpleName(), annotationType.getSimpleName()));
                for (String possibleSolution : possibleSolutions) {
                    problem.addPossibleSolution(possibleSolution);
                }
                problem.documentedAt("validation_problems", "unsupported_value_type");
            });
        }
    }

    private static List<Class<?>> unpackValueTypesOf(PropertyMetadata propertyMetadata) {
        ArrayList unpackedValueTypes = new ArrayList();
        Class returnType = propertyMetadata.getDeclaredType().getRawType();
        if (Provider.class.isAssignableFrom(returnType)) {
            List typeArguments = TypeOf.typeOf((Type)propertyMetadata.getDeclaredType().getType()).getActualTypeArguments();
            for (TypeOf typeArgument : typeArguments) {
                unpackedValueTypes.add(typeArgument.getConcreteClass());
            }
        } else {
            unpackedValueTypes.add(returnType);
        }
        return unpackedValueTypes;
    }
}

