/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.DefaultGradleProperties;
import org.gradle.initialization.Environment;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.initialization.properties.MutableGradleProperties;

public class DefaultGradlePropertiesLoader
implements IGradlePropertiesLoader {
    private final StartParameterInternal startParameter;
    private final Environment environment;

    public DefaultGradlePropertiesLoader(StartParameterInternal startParameter, Environment environment) {
        this.startParameter = startParameter;
        this.environment = environment;
    }

    @Override
    public MutableGradleProperties loadGradleProperties(File rootDir) {
        return this.loadProperties(rootDir);
    }

    private MutableGradleProperties loadProperties(File rootDir) {
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>();
        HashMap<String, Object> overrideProperties = new HashMap<String, Object>();
        this.addGradlePropertiesFrom(this.startParameter.getGradleHomeDir(), defaultProperties);
        this.addGradlePropertiesFrom(rootDir, defaultProperties);
        this.addGradlePropertiesFrom(this.startParameter.getGradleUserHomeDir(), overrideProperties);
        return new DefaultGradleProperties(defaultProperties, overrideProperties);
    }

    private void addGradlePropertiesFrom(File dir, Map<String, Object> target) {
        Map<String, String> propertiesFile = this.environment.propertiesFile(new File(dir, "gradle.properties"));
        if (propertiesFile != null) {
            target.putAll(propertiesFile);
        }
    }
}

