/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.util.internal.MavenUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MavenToolchainsInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private static final String PROPERTY_NAME = "org.gradle.java.installations.maven-toolchains-file";
    private static final String PARSE_EXPRESSION = "/toolchains/toolchain[type='jdk']/configuration/jdkHome//text()";
    private static final Logger LOGGER = Logging.getLogger(MavenToolchainsInstallationSupplier.class);
    private final Provider<String> toolchainLocation;
    private final XPathFactory xPathFactory;
    private final DocumentBuilderFactory documentBuilderFactory;
    private final FileResolver fileResolver;

    @Inject
    public MavenToolchainsInstallationSupplier(ProviderFactory factory, FileResolver fileResolver) {
        super(factory);
        this.toolchainLocation = factory.gradleProperty(PROPERTY_NAME).orElse((Object)this.defaultMavenToolchainsDefinitionsLocation());
        this.xPathFactory = XPathFactory.newInstance();
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.fileResolver = fileResolver;
    }

    @Override
    public String getSourceName() {
        return "Maven Toolchains";
    }

    @Override
    protected Set<InstallationLocation> findCandidates() {
        block10: {
            File toolchainFile = this.fileResolver.resolve(this.toolchainLocation.get());
            if (toolchainFile.exists()) {
                Set<InstallationLocation> set;
                FileInputStream toolchain = new FileInputStream(toolchainFile);
                try {
                    DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
                    documentBuilder.setErrorHandler(new PropagatingErrorHandler());
                    XPath xpath = this.xPathFactory.newXPath();
                    XPathExpression expression = xpath.compile(PARSE_EXPRESSION);
                    NodeList nodes = (NodeList)expression.evaluate(documentBuilder.parse(toolchain), XPathConstants.NODESET);
                    HashSet<String> locations = new HashSet<String>();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node item = nodes.item(i);
                        if (item == null || item.getNodeType() != 3) continue;
                        locations.add(item.getNodeValue().trim());
                    }
                    set = locations.stream().map(jdkHome -> new InstallationLocation(new File((String)jdkHome), this.getSourceName())).collect(Collectors.toSet());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            toolchain.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Java Toolchain auto-detection failed to parse Maven Toolchains located at {}", (Object)toolchainFile, (Object)e);
                            break block10;
                        }
                        LOGGER.info("Java Toolchain auto-detection failed to parse Maven Toolchains located at {}. {}", (Object)toolchainFile, (Object)e.getMessage());
                    }
                }
                toolchain.close();
                return set;
            }
        }
        return Collections.emptySet();
    }

    private String defaultMavenToolchainsDefinitionsLocation() {
        return new File(MavenUtil.getUserMavenDir(), "toolchains.xml").getAbsolutePath();
    }

    private static class PropagatingErrorHandler
    implements ErrorHandler {
        private PropagatingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }
}

