/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.DisambiguationRule;
import org.gradle.api.internal.attributes.EmptySchema;
import org.gradle.api.internal.attributes.MultipleCandidatesResult;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;

public class PreferJavaRuntimeVariant
extends EmptySchema {
    private static final Set<Attribute<?>> SUPPORTED_ATTRIBUTES = Sets.newHashSet((Object[])new Attribute[]{Usage.USAGE_ATTRIBUTE, LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE});
    private final PreferRuntimeVariantUsageDisambiguationRule usageDisambiguationRule;
    private final PreferJarVariantUsageDisambiguationRule formatDisambiguationRule;

    public PreferJavaRuntimeVariant(NamedObjectInstantiator instantiator) {
        Usage runtimeUsage = (Usage)instantiator.named(Usage.class, "java-runtime");
        LibraryElements jarLibraryElements = (LibraryElements)instantiator.named(LibraryElements.class, "jar");
        this.usageDisambiguationRule = new PreferRuntimeVariantUsageDisambiguationRule(runtimeUsage);
        this.formatDisambiguationRule = new PreferJarVariantUsageDisambiguationRule(jarLibraryElements);
    }

    @Override
    public Set<Attribute<?>> getAttributes() {
        return SUPPORTED_ATTRIBUTES;
    }

    @Override
    @Nullable
    public Attribute<?> getAttributeByName(String name) {
        for (Attribute<?> attr : SUPPORTED_ATTRIBUTES) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public DisambiguationRule<Object> disambiguationRules(Attribute<?> attribute) {
        if (Usage.USAGE_ATTRIBUTE.equals(attribute)) {
            return (DisambiguationRule)Cast.uncheckedCast((Object)this.usageDisambiguationRule);
        }
        if (LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE.equals(attribute)) {
            return (DisambiguationRule)Cast.uncheckedCast((Object)this.formatDisambiguationRule);
        }
        return super.disambiguationRules(attribute);
    }

    private static class PreferJarVariantUsageDisambiguationRule
    implements DisambiguationRule<LibraryElements> {
        private final LibraryElements jarLibraryElements;

        public PreferJarVariantUsageDisambiguationRule(LibraryElements jarLibraryElements) {
            this.jarLibraryElements = jarLibraryElements;
        }

        @Override
        public boolean doesSomething() {
            return true;
        }

        public void execute(MultipleCandidatesResult<LibraryElements> details) {
            Set candidates;
            if (details.getConsumerValue() == null && (candidates = details.getCandidateValues()).contains(this.jarLibraryElements)) {
                details.closestMatch(this.jarLibraryElements);
            }
        }
    }

    private static class PreferRuntimeVariantUsageDisambiguationRule
    implements DisambiguationRule<Usage> {
        private final Usage runtimeUsage;

        public PreferRuntimeVariantUsageDisambiguationRule(Usage runtimeUsage) {
            this.runtimeUsage = runtimeUsage;
        }

        @Override
        public boolean doesSomething() {
            return true;
        }

        public void execute(MultipleCandidatesResult<Usage> details) {
            Set candidates;
            if (details.getConsumerValue() == null && (candidates = details.getCandidateValues()).contains(this.runtimeUsage)) {
                details.closestMatch(this.runtimeUsage);
            }
        }
    }
}

