/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.kryo;

import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ObjectReader;
import org.gradle.internal.serialize.ObjectWriter;
import org.gradle.internal.serialize.StatefulSerializer;

public class TypeSafeSerializer<T>
implements StatefulSerializer<Object> {
    private final Class<T> type;
    private final StatefulSerializer<T> serializer;

    public TypeSafeSerializer(Class<T> type, StatefulSerializer<T> serializer) {
        this.type = type;
        this.serializer = serializer;
    }

    @Override
    public ObjectReader<Object> newReader(Decoder decoder) {
        final ObjectReader<T> reader = this.serializer.newReader(decoder);
        return new ObjectReader<Object>(){

            @Override
            public Object read() throws Exception {
                return reader.read();
            }
        };
    }

    @Override
    public ObjectWriter<Object> newWriter(Encoder encoder) {
        final ObjectWriter<T> writer = this.serializer.newWriter(encoder);
        return new ObjectWriter<Object>(){

            @Override
            public void write(Object value) throws Exception {
                writer.write(TypeSafeSerializer.this.type.cast(value));
            }
        };
    }
}

