/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.factory;

import io.usethesource.capsule.Set;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;

public final class DefaultSetFactory {
    static final String DEFAULT_CLASS_NAME = "io.usethesource.capsule.core.PersistentTrieSet";
    static final String TARGET_CLASS_NAME = System.getProperty(String.format("%s.%s", Set.class.getName(), "targetClass"), "io.usethesource.capsule.core.PersistentTrieSet");
    private final String persistentFactoryMethodName = "of";
    public static final DefaultSetFactory FACTORY = new DefaultSetFactory();
    private final Method of0;
    private final Method of1;
    private final Method of2;
    private final Method ofN;
    private final Method transientOf0;
    private final Method transientOfN;

    private DefaultSetFactory() {
        try {
            Class<?> targetClass = Class.forName(TARGET_CLASS_NAME);
            this.of0 = targetClass.getMethod("of", new Class[0]);
            this.of1 = targetClass.getMethod("of", Object.class);
            this.of2 = targetClass.getMethod("of", Object.class, Object.class);
            this.ofN = targetClass.getMethod("of", Object[].class);
            this.transientOf0 = targetClass.getMethod("transientOf", new Class[0]);
            this.transientOfN = targetClass.getMethod("transientOf", Object[].class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static final <T> T unchecked(Callable<?> factoryMethod) {
        try {
            return (T)factoryMethod.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final <K> Set.Immutable<K> of() {
        return (Set.Immutable)DefaultSetFactory.unchecked(() -> this.of0.invoke(null, new Object[0]));
    }

    public final <K> Set.Immutable<K> of(K key0) {
        return (Set.Immutable)DefaultSetFactory.unchecked(() -> this.of1.invoke(null, key0));
    }

    public final <K> Set.Immutable<K> of(K key0, K key1) {
        return (Set.Immutable)DefaultSetFactory.unchecked(() -> this.of2.invoke(null, key0, key1));
    }

    public final <K> Set.Immutable<K> of(K ... keys) {
        return (Set.Immutable)DefaultSetFactory.unchecked(() -> this.ofN.invoke(null, new Object[]{keys}));
    }

    public final <K> Set.Transient<K> transientOf() {
        return (Set.Transient)DefaultSetFactory.unchecked(() -> this.transientOf0.invoke(null, new Object[0]));
    }

    public final <K> Set.Transient<K> transientOf(K ... keys) {
        return (Set.Transient)DefaultSetFactory.unchecked(() -> this.transientOfN.invoke(null, new Object[]{keys}));
    }
}

