/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.jvm.toolchain.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OsXJavaHomeOutputParser {

    private static final Pattern INSTALLATION_PATTERN = Pattern.compile(".+\\s+(/.+)");

    public Set<File> parse(Reader output) {
        BufferedReader reader = new BufferedReader(output);
        return reader.lines().flatMap(line -> {
            Matcher matcher = INSTALLATION_PATTERN.matcher(line);
            if (matcher.matches()) {
                String javaHome = matcher.group(1);
                return Stream.of(javaHome);
            }
            return Stream.empty();
        }).map(File::new).collect(Collectors.toSet());
    }

}
