/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfBorderDictionary;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.style.derived.ColorValue;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.AbstractFormField;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.RenderingContext;

public class CheckboxFormField
extends AbstractFormField {
    private static final String FIELD_TYPE = "Checkbox";

    public CheckboxFormField(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        this.initDimensions(c, box, cssWidth, cssHeight);
    }

    protected String getFieldType() {
        return FIELD_TYPE;
    }

    public void paint(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box) {
        PdfContentByte cb = outputDevice.getCurrentPage();
        PdfWriter writer = outputDevice.getWriter();
        PdfFormField field = PdfFormField.createCheckBox((PdfWriter)writer);
        Element e = box.getElement();
        String onValue = this.getValue(e);
        boolean checked = this.isChecked(e);
        float width = outputDevice.getDeviceLength(this.getWidth());
        float height = outputDevice.getDeviceLength(this.getHeight());
        Color color = box.getStyle().getColor();
        Color darker = ColorValue.darkenColor(box.getEffBackgroundColor(c));
        this.createAppearances(cb, field, onValue, width, height, true, color, darker);
        this.createAppearances(cb, field, onValue, width, height, false, color, darker);
        field.setWidget(outputDevice.createLocalTargetArea(c, box), PdfAnnotation.HIGHLIGHT_INVERT);
        field.setFieldName(this.getFieldName(outputDevice, e));
        field.setBorderStyle(new PdfBorderDictionary(0.0f, 0));
        field.setValueAsName(checked ? onValue : "Off");
        field.setAppearanceState(checked ? onValue : "Off");
        if (this.isReadOnly(e)) {
            field.setFieldFlags(1);
        }
        writer.addAnnotation((PdfAnnotation)field);
    }

    private void createAppearances(PdfContentByte cb, PdfFormField field, String onValue, float width, float height, boolean normal, Color color, Color darker) {
        PdfAppearance tpOff = cb.createAppearance(width, height);
        PdfAppearance tpOn = cb.createAppearance(width, height);
        tpOn.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        tpOff.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        float sLen = Math.min(width - this.reduce(width), height - this.reduce(height));
        if (!normal) {
            tpOff.setRGBColorFill(darker.getRed(), darker.getGreen(), darker.getBlue());
            tpOff.rectangle(0.0f, 0.0f, width, height);
            tpOff.fill();
            tpOn.setRGBColorFill(darker.getRed(), darker.getGreen(), darker.getBlue());
            tpOn.rectangle(0.0f, 0.0f, width, height);
            tpOn.fill();
        }
        tpOn.moveTo(width / 2.0f - sLen / 2.0f, height / 2.0f - sLen / 2.0f);
        tpOn.lineTo(width / 2.0f + sLen / 2.0f, height / 2.0f + sLen / 2.0f);
        tpOn.moveTo(width / 2.0f - sLen / 2.0f, height / 2.0f + sLen / 2.0f);
        tpOn.lineTo(width / 2.0f + sLen / 2.0f, height / 2.0f - sLen / 2.0f);
        tpOn.stroke();
        if (normal) {
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", (PdfTemplate)tpOff);
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, onValue, (PdfTemplate)tpOn);
        } else {
            field.setAppearance(PdfAnnotation.APPEARANCE_DOWN, "Off", (PdfTemplate)tpOff);
            field.setAppearance(PdfAnnotation.APPEARANCE_DOWN, onValue, (PdfTemplate)tpOn);
        }
    }

    private float reduce(float value) {
        return Math.min(value, Math.max(2.0f, 0.08f * value));
    }

    public int getBaseline() {
        return 0;
    }

    public boolean hasBaseline() {
        return false;
    }
}

