/*
 * Decompiled with CFR 0.152.
 */
package griffon.core;

import griffon.core.ThreadingHandler;
import griffon.util.CallableWithArgs;
import griffon.util.CallableWithArgsClosure;
import griffon.util.RunnableWithArgs;
import griffon.util.RunnableWithArgsClosure;
import griffon.util.UIThreadHandler;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIThreadManager {
    private UIThreadHandler uiThreadHandler;
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private static final Logger LOG = LoggerFactory.getLogger(UIThreadManager.class);
    private static final UIThreadManager INSTANCE = new UIThreadManager();
    private static final String EXECUTE_INSIDE_UI_SYNC = "execInsideUISync";
    private static final RunnableWithArgsClosure EXECUTE_INSIDE_UI_SYNC_RUNNER = new RunnableWithArgsClosure(INSTANCE, new ScriptOrRunnableRunner(){

        protected String getMethodName() {
            return UIThreadManager.EXECUTE_INSIDE_UI_SYNC;
        }

        protected void withScript(Script script) {
            INSTANCE.executeSync(script);
        }

        protected void withRunnable(Runnable runnable) {
            INSTANCE.executeSync(runnable);
        }
    });
    private static final String EXECUTE_INSIDE_UI_ASYNC = "execInsideUIAsync";
    private static final RunnableWithArgsClosure EXECUTE_INSIDE_UI_ASYNC_RUNNER = new RunnableWithArgsClosure(INSTANCE, new ScriptOrRunnableRunner(){

        protected String getMethodName() {
            return UIThreadManager.EXECUTE_INSIDE_UI_ASYNC;
        }

        protected void withScript(Script script) {
            INSTANCE.executeAsync(script);
        }

        protected void withRunnable(Runnable runnable) {
            INSTANCE.executeAsync(runnable);
        }
    });
    private static final String EXECUTE_OUTSIDE_UI = "execOutsideUI";
    private static final RunnableWithArgsClosure EXECUTE_OUTSIDE_UI_RUNNER = new RunnableWithArgsClosure(INSTANCE, new ScriptOrRunnableRunner(){

        protected String getMethodName() {
            return UIThreadManager.EXECUTE_OUTSIDE_UI;
        }

        protected void withScript(Script script) {
            INSTANCE.executeOutside(script);
        }

        protected void withRunnable(Runnable runnable) {
            INSTANCE.executeOutside(runnable);
        }
    });
    private static final String IS_UITHREAD = "isUIThread";
    private static final CallableWithArgsClosure IS_UITHREAD_RUNNER = new CallableWithArgsClosure<Boolean>(INSTANCE, new CallableWithArgs<Boolean>(){

        @Override
        public Boolean call(Object[] args) {
            if (args.length == 0) {
                return INSTANCE.isUIThread();
            }
            throw new MissingMethodException(UIThreadManager.IS_UITHREAD, UIThreadManager.class, args);
        }
    });
    private static final String EXECUTE_FUTURE = "executeFuture";
    private static final CallableWithArgsClosure EXECUTE_FUTURE_RUNNER = new CallableWithArgsClosure<Future>(INSTANCE, new CallableWithArgs<Future>(){

        @Override
        public Future call(Object[] args) {
            if (args.length == 1 && args[0] instanceof Callable) {
                return INSTANCE.executeFuture((Callable)args[0]);
            }
            if (args.length == 2 && args[0] instanceof ExecutorService && args[1] instanceof Callable) {
                return INSTANCE.executeFuture((ExecutorService)args[0], (Callable)args[1]);
            }
            throw new MissingMethodException(UIThreadManager.EXECUTE_FUTURE, UIThreadManager.class, args);
        }
    });

    public static UIThreadManager getInstance() {
        return INSTANCE;
    }

    private UIThreadManager() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Default Executor set to run with " + Runtime.getRuntime().availableProcessors() + " processors");
        }
    }

    public static void enhance(Script script) {
        if (script instanceof ThreadingHandler) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Enhancing script " + script);
        }
        script.getBinding().setVariable("execSync", (Object)EXECUTE_INSIDE_UI_SYNC_RUNNER);
        script.getBinding().setVariable("execAsync", (Object)EXECUTE_INSIDE_UI_ASYNC_RUNNER);
        script.getBinding().setVariable("execOutside", (Object)EXECUTE_OUTSIDE_UI_RUNNER);
        script.getBinding().setVariable(EXECUTE_INSIDE_UI_SYNC, (Object)EXECUTE_INSIDE_UI_SYNC_RUNNER);
        script.getBinding().setVariable(EXECUTE_INSIDE_UI_SYNC, (Object)EXECUTE_INSIDE_UI_ASYNC_RUNNER);
        script.getBinding().setVariable(EXECUTE_OUTSIDE_UI, (Object)EXECUTE_OUTSIDE_UI_RUNNER);
        script.getBinding().setVariable(IS_UITHREAD, (Object)IS_UITHREAD_RUNNER);
        script.getBinding().setVariable(EXECUTE_FUTURE, (Object)EXECUTE_FUTURE_RUNNER);
    }

    public static void enhance(MetaClass metaClass) {
        if (metaClass instanceof ExpandoMetaClass) {
            ExpandoMetaClass mc = (ExpandoMetaClass)metaClass;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Enhancing metaClass " + metaClass);
            }
            mc.registerInstanceMethod("execSync", (Closure)EXECUTE_INSIDE_UI_SYNC_RUNNER);
            mc.registerInstanceMethod("execAsync", (Closure)EXECUTE_INSIDE_UI_ASYNC_RUNNER);
            mc.registerInstanceMethod("execOutside", (Closure)EXECUTE_OUTSIDE_UI_RUNNER);
            mc.registerInstanceMethod(EXECUTE_INSIDE_UI_SYNC, (Closure)EXECUTE_INSIDE_UI_SYNC_RUNNER);
            mc.registerInstanceMethod(EXECUTE_INSIDE_UI_ASYNC, (Closure)EXECUTE_INSIDE_UI_ASYNC_RUNNER);
            mc.registerInstanceMethod(EXECUTE_OUTSIDE_UI, (Closure)EXECUTE_OUTSIDE_UI_RUNNER);
            mc.registerInstanceMethod(IS_UITHREAD, (Closure)IS_UITHREAD_RUNNER);
            mc.registerInstanceMethod(EXECUTE_FUTURE, (Closure)EXECUTE_FUTURE_RUNNER);
        }
    }

    public void setUIThreadHandler(UIThreadHandler threadHandler) {
        if (this.uiThreadHandler != null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("UIThreadHandler is already set, it can't be changed!");
            }
        } else {
            this.uiThreadHandler = threadHandler;
        }
    }

    public UIThreadHandler getUIThreadHandler() {
        if (this.uiThreadHandler == null) {
            try {
                this.setUIThreadHandler((UIThreadHandler)this.getClass().getClassLoader().loadClass("griffon.swing.SwingUIThreadHandler").newInstance());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Can't locate a suitable UIThreadHandler.", e);
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Can't locate a suitable UIThreadHandler.", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Can't locate a suitable UIThreadHandler.", e);
            }
        }
        return this.uiThreadHandler;
    }

    public boolean isUIThread() {
        return this.getUIThreadHandler().isUIThread();
    }

    public void executeAsync(Runnable runnable) {
        this.getUIThreadHandler().executeAsync(runnable);
    }

    public void executeAsync(final Script script) {
        this.getUIThreadHandler().executeAsync(new Runnable(){

            public void run() {
                script.run();
            }
        });
    }

    public void executeSync(Runnable runnable) {
        this.getUIThreadHandler().executeSync(runnable);
    }

    public void executeSync(final Script script) {
        this.getUIThreadHandler().executeSync(new Runnable(){

            public void run() {
                script.run();
            }
        });
    }

    public void executeOutside(Runnable runnable) {
        this.getUIThreadHandler().executeOutside(runnable);
    }

    public void executeOutside(final Script script) {
        this.getUIThreadHandler().executeOutside(new Runnable(){

            public void run() {
                script.run();
            }
        });
    }

    public Future executeFuture(Callable<?> callable) {
        return this.executeFuture(DEFAULT_EXECUTOR_SERVICE, callable);
    }

    public Future executeFuture(ExecutorService executorService, Callable<?> callable) {
        executorService = executorService != null ? executorService : DEFAULT_EXECUTOR_SERVICE;
        return executorService.submit(callable);
    }

    private static abstract class ScriptOrRunnableRunner
    extends RunnableWithArgs {
        private ScriptOrRunnableRunner() {
        }

        public void run(Object[] args) {
            if (args != null && args.length == 1) {
                if (args[0] instanceof Script) {
                    this.withScript((Script)args[0]);
                    return;
                }
                if (args[0] instanceof Runnable) {
                    this.withRunnable((Runnable)args[0]);
                    return;
                }
            }
            throw new MissingMethodException(this.getMethodName(), UIThreadManager.class, args);
        }

        protected abstract String getMethodName();

        protected abstract void withScript(Script var1);

        protected abstract void withRunnable(Runnable var1);
    }
}

