/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import java.util.Map;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public abstract class ConfigUtils {
    public static boolean isValueDefined(Map config, String key) {
        String[] keys = key.split("\\.");
        for (int i = 0; i < keys.length - 1; ++i) {
            if (config == null) {
                return false;
            }
            config = (Map)config.get(keys[i]);
        }
        if (config == null) {
            return false;
        }
        Object value = config.get(keys[keys.length - 1]);
        return value != null;
    }

    public static Object getConfigValue(Map config, String key) {
        return ConfigUtils.getConfigValue(config, key, null);
    }

    public static Object getConfigValue(Map config, String key, Object defaultValue) {
        String[] keys = key.split("\\.");
        for (int i = 0; i < keys.length - 1; ++i) {
            Object node;
            if (config != null) {
                node = config.get(keys[i]);
                if (!(node instanceof Map)) {
                    return defaultValue;
                }
            } else {
                return defaultValue;
            }
            config = (Map)node;
        }
        if (config == null) {
            return defaultValue;
        }
        Object value = config.get(keys[keys.length - 1]);
        return value != null ? value : defaultValue;
    }

    public static boolean getConfigValueAsBoolean(Map config, String key) {
        return ConfigUtils.getConfigValueAsBoolean(config, key, false);
    }

    public static boolean getConfigValueAsBoolean(Map config, String key, boolean defaultValue) {
        Object value = ConfigUtils.getConfigValue(config, key, defaultValue);
        return DefaultTypeTransformation.castToBoolean((Object)value);
    }

    public static int getConfigValueAsInt(Map config, String key) {
        return ConfigUtils.getConfigValueAsInt(config, key, 0);
    }

    public static int getConfigValueAsInt(Map config, String key, int defaultValue) {
        Object value = ConfigUtils.getConfigValue(config, key, defaultValue);
        return DefaultTypeTransformation.castToNumber((Object)value).intValue();
    }

    public static String getConfigValueAsString(Map config, String key) {
        return ConfigUtils.getConfigValueAsString(config, key, "");
    }

    public static String getConfigValueAsString(Map config, String key, String defaultValue) {
        Object value = ConfigUtils.getConfigValue(config, key, defaultValue);
        return String.valueOf(value);
    }
}

