/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.core.GriffonApplication;
import griffon.util.ApplicationHolder;
import griffon.util.GriffonNameUtils;
import java.util.Arrays;
import java.util.Map;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GriffonExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public static final String GRIFFON_FULL_STACKTRACE = "griffon.full.stacktrace";
    public static final String GRIFFON_EXCEPTION_OUTPUT = "griffon.exception.output";
    private static final Logger LOG = LoggerFactory.getLogger(GriffonExceptionHandler.class);
    private static final String[] CONFIG_OPTIONS = new String[]{"griffon.full.stacktrace", "griffon.exception.output"};

    public void uncaughtException(Thread t, Throwable e) {
        this.handle(e);
    }

    public void handle(Throwable throwable) {
        try {
            GriffonApplication app;
            GriffonExceptionHandler.sanitize(throwable);
            if (GriffonExceptionHandler.isOutputEnabled()) {
                throwable.printStackTrace(System.err);
            }
            if ((app = ApplicationHolder.getApplication()) != null) {
                LOG.error("Uncaught Exception", throwable);
                app.event("Uncaught" + GriffonNameUtils.getShortName(throwable.getClass()), Arrays.asList(throwable));
                app.event(GriffonApplication.Event.UNCAUGHT_EXCEPTION_THROWN.getName(), Arrays.asList(throwable));
            }
        }
        catch (Throwable t) {
            GriffonExceptionHandler.sanitize(t);
            if (GriffonExceptionHandler.isOutputEnabled()) {
                t.printStackTrace(System.err);
            }
            LOG.error("An error occurred while handling uncaught exception " + throwable, t);
        }
    }

    public static Throwable sanitize(Throwable throwable) {
        try {
            if (!Boolean.getBoolean(GRIFFON_FULL_STACKTRACE)) {
                StackTraceUtils.deepSanitize((Throwable)throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        return throwable;
    }

    public static boolean isOutputEnabled() {
        return Boolean.getBoolean(GRIFFON_EXCEPTION_OUTPUT);
    }

    public static void configure(Map config) {
        for (String option : CONFIG_OPTIONS) {
            if (!config.containsKey(option)) continue;
            System.setProperty(option, String.valueOf(config.get(option)));
        }
    }

    public static void registerExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new GriffonExceptionHandler());
        System.setProperty("sun.awt.exception.handler", GriffonExceptionHandler.class.getName());
    }
}

