/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonAddon;
import griffon.core.GriffonApplication;
import griffon.core.UIThreadManager;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.util.FactoryBuilderSupport;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.codehaus.griffon.runtime.core.ResourceLocator;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGriffonAddon
extends GroovyObjectSupport
implements GriffonAddon {
    private final GriffonApplication app;
    private final Logger log;
    private final ResourceLocator resourceLocator = new ResourceLocator();
    protected final Map<String, Object> factories = new LinkedHashMap<String, Object>();
    protected final Map<String, Closure> methods = new LinkedHashMap<String, Closure>();
    protected final Map<String, Map<String, Closure>> props = new LinkedHashMap<String, Map<String, Closure>>();
    protected final Map<String, Closure> events = new LinkedHashMap<String, Closure>();
    protected final Map<String, Map<String, Object>> mvcGroups = new LinkedHashMap<String, Map<String, Object>>();
    protected final List<Closure> attributeDelegates = new ArrayList<Closure>();
    protected final List<Closure> preInstantiateDelegates = new ArrayList<Closure>();
    protected final List<Closure> postInstantiateDelegates = new ArrayList<Closure>();
    protected final List<Closure> postNodeCompletionDelegates = new ArrayList<Closure>();

    public AbstractGriffonAddon(GriffonApplication app) {
        this(app, null);
    }

    protected AbstractGriffonAddon(GriffonApplication app, String loggingCategory) {
        this.app = app;
        if (GriffonNameUtils.isBlank(loggingCategory)) {
            loggingCategory = "griffon.addon." + this.getClass().getName();
        }
        this.log = LoggerFactory.getLogger((String)loggingCategory);
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public Object newInstance(Class clazz, String type) {
        return GriffonApplicationHelper.newInstance(this.getApp(), clazz, type);
    }

    @Override
    public void addonInit(GriffonApplication app) {
    }

    @Override
    public void addonPostInit(GriffonApplication app) {
    }

    @Override
    public void addonBuilderInit(GriffonApplication app, FactoryBuilderSupport builder) {
    }

    @Override
    public void addonBuilderPostInit(GriffonApplication app, FactoryBuilderSupport builder) {
    }

    @Override
    public Map<String, Object> getFactories() {
        return this.factories;
    }

    @Override
    public Map<String, Closure> getMethods() {
        return this.methods;
    }

    @Override
    public Map<String, Map<String, Closure>> getProps() {
        return this.props;
    }

    @Override
    public Map<String, Closure> getEvents() {
        return this.events;
    }

    @Override
    public Map<String, Map<String, Object>> getMvcGroups() {
        return this.mvcGroups;
    }

    @Override
    public List<Closure> getAttributeDelegates() {
        return this.attributeDelegates;
    }

    @Override
    public List<Closure> getPreInstantiateDelegates() {
        return this.preInstantiateDelegates;
    }

    @Override
    public List<Closure> getPostInstantiateDelegates() {
        return this.postInstantiateDelegates;
    }

    @Override
    public List<Closure> getPostNodeCompletionDelegates() {
        return this.postNodeCompletionDelegates;
    }

    @Override
    public boolean isUIThread() {
        return UIThreadManager.getInstance().isUIThread();
    }

    @Override
    public void execAsync(Runnable runnable) {
        this.execInsideUIAsync(runnable);
    }

    @Override
    public void execSync(Runnable runnable) {
        this.execInsideUIAsync(runnable);
    }

    @Override
    public void execOutside(Runnable runnable) {
        this.execOutsideUI(runnable);
    }

    @Override
    public void execInsideUIAsync(Runnable runnable) {
        UIThreadManager.getInstance().executeAsync(runnable);
    }

    @Override
    public void execInsideUISync(Runnable runnable) {
        UIThreadManager.getInstance().executeSync(runnable);
    }

    @Override
    public void execOutsideUI(Runnable runnable) {
        UIThreadManager.getInstance().executeOutside(runnable);
    }

    @Override
    public Future execFuture(ExecutorService executorService, Closure closure) {
        return UIThreadManager.getInstance().executeFuture(executorService, (Callable<?>)closure);
    }

    @Override
    public Future execFuture(Closure closure) {
        return UIThreadManager.getInstance().executeFuture((Callable<?>)closure);
    }

    @Override
    public Future execFuture(ExecutorService executorService, Callable callable) {
        return UIThreadManager.getInstance().executeFuture(executorService, callable);
    }

    @Override
    public Future execFuture(Callable callable) {
        return UIThreadManager.getInstance().executeFuture(callable);
    }

    protected Map<String, String> groupDef(String[][] parts) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < parts.length; ++i) {
            map.put(parts[i][0], parts[i][1]);
        }
        return map;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.resourceLocator.getResourceAsStream(name);
    }

    @Override
    public URL getResourceAsURL(String name) {
        return this.resourceLocator.getResourceAsURL(name);
    }

    @Override
    public List<URL> getResources(String name) {
        return this.resourceLocator.getResources(name);
    }
}

