/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.AddonManager;
import griffon.core.ApplicationPhase;
import griffon.core.ArtifactManager;
import griffon.core.GriffonApplication;
import griffon.core.GriffonController;
import griffon.core.GriffonModel;
import griffon.core.GriffonMvcArtifact;
import griffon.core.GriffonService;
import griffon.core.GriffonView;
import griffon.core.MVCClosure;
import griffon.core.MVCGroup;
import griffon.core.MVCGroupManager;
import griffon.core.ServiceManager;
import griffon.core.ShutdownHandler;
import griffon.core.UIThreadManager;
import griffon.util.ApplicationHolder;
import griffon.util.ConfigUtils;
import griffon.util.Metadata;
import griffon.util.RunnableWithArgs;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.util.ConfigObject;
import groovy.util.FactoryBuilderSupport;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.codehaus.griffon.runtime.core.AbstractObservable;
import org.codehaus.griffon.runtime.core.EventRouter;
import org.codehaus.griffon.runtime.core.ResourceLocator;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;
import org.codehaus.griffon.runtime.util.MVCGroupExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGriffonApplication
extends AbstractObservable
implements GriffonApplication {
    private Binding bindings = new Binding();
    private ConfigObject config;
    private ConfigObject builderConfig;
    private Object eventsConfig;
    private AddonManager addonManager;
    private ArtifactManager artifactManager;
    private MVCGroupManager mvcGroupManager;
    private ServiceManager serviceManager;
    private Locale locale = Locale.getDefault();
    public static final String[] EMPTY_ARGS = new String[0];
    protected final Object lock = new Object();
    private ApplicationPhase phase = ApplicationPhase.INITIALIZE;
    private final EventRouter eventRouter = new EventRouter();
    private final ResourceLocator resourceLocator = new ResourceLocator();
    private final List<ShutdownHandler> shutdownHandlers = new ArrayList<ShutdownHandler>();
    private final String[] startupArgs;
    private final Object shutdownLock = new Object();
    private final Logger log;

    public AbstractGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public AbstractGriffonApplication(String[] args) {
        this.startupArgs = new String[args.length];
        System.arraycopy(args, 0, this.startupArgs, 0, args.length);
        ApplicationHolder.setApplication(this);
        this.log = LoggerFactory.getLogger(this.getClass());
        MVCGroupExceptionHandler.registerWith(this);
    }

    @Override
    public Binding getBindings() {
        return this.bindings;
    }

    @Override
    public void setBindings(Binding bindings) {
        this.bindings = bindings;
    }

    @Override
    public ConfigObject getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ConfigObject config) {
        this.config = config;
    }

    @Override
    public ConfigObject getBuilderConfig() {
        return this.builderConfig;
    }

    @Override
    public void setBuilderConfig(ConfigObject builderConfig) {
        this.builderConfig = builderConfig;
    }

    @Override
    public Object getEventsConfig() {
        return this.eventsConfig;
    }

    @Override
    public void setEventsConfig(Object eventsConfig) {
        this.eventsConfig = eventsConfig;
    }

    @Override
    public Map<String, ? extends GriffonModel> getModels() {
        return this.getMvcGroupManager().getModels();
    }

    @Override
    public Map<String, ? extends GriffonView> getViews() {
        return this.getMvcGroupManager().getViews();
    }

    @Override
    public Map<String, ? extends GriffonController> getControllers() {
        return this.getMvcGroupManager().getControllers();
    }

    @Override
    public Map<String, ? extends FactoryBuilderSupport> getBuilders() {
        return this.getMvcGroupManager().getBuilders();
    }

    @Override
    public Map<String, MVCGroup> getGroups() {
        return this.getMvcGroupManager().getGroups();
    }

    @Override
    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    public void setAddonManager(AddonManager addonManager) {
        this.addonManager = addonManager;
    }

    @Override
    public ArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    @Override
    public MVCGroupManager getMvcGroupManager() {
        return this.mvcGroupManager;
    }

    public void setMvcGroupManager(MVCGroupManager mvcGroupManager) {
        this.mvcGroupManager = mvcGroupManager;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public Map<String, ? extends GriffonService> getServices() {
        return this.serviceManager.getServices();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String[] getStartupArgs() {
        return this.startupArgs;
    }

    @Override
    public Logger getLog() {
        return this.log;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        this.firePropertyChange("locale", this.locale, this.locale);
    }

    @Override
    public Metadata getMetadata() {
        return Metadata.getCurrent();
    }

    @Override
    public Class getAppConfigClass() {
        return this.loadClass(GriffonApplication.Configuration.APPLICATION.getName());
    }

    @Override
    public Class getConfigClass() {
        return this.loadClass(GriffonApplication.Configuration.CONFIG.getName());
    }

    @Override
    public Class getBuilderClass() {
        return this.loadClass(GriffonApplication.Configuration.BUILDER.getName());
    }

    @Override
    public Class getEventsClass() {
        return this.loadClass(GriffonApplication.Configuration.EVENTS.getName());
    }

    @Override
    public void initialize() {
        if (this.phase == ApplicationPhase.INITIALIZE) {
            GriffonApplicationHelper.prepare(this);
        }
    }

    @Override
    public void ready() {
        if (this.phase != ApplicationPhase.STARTUP) {
            return;
        }
        this.phase = ApplicationPhase.READY;
        this.event(GriffonApplication.Event.READY_START.getName(), Arrays.asList(this));
        GriffonApplicationHelper.runLifecycleHandler(GriffonApplication.Lifecycle.READY.getName(), this);
        this.event(GriffonApplication.Event.READY_END.getName(), Arrays.asList(this));
        this.phase = ApplicationPhase.MAIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canShutdown() {
        this.event(GriffonApplication.Event.SHUTDOWN_REQUESTED.getName(), Arrays.asList(this));
        Object object = this.shutdownLock;
        synchronized (object) {
            for (ShutdownHandler handler : this.shutdownHandlers) {
                if (handler.canShutdown(this)) continue;
                this.event(GriffonApplication.Event.SHUTDOWN_ABORTED.getName(), Arrays.asList(this));
                if (this.log.isDebugEnabled()) {
                    try {
                        this.log.debug("Shutdown aborted by " + handler);
                    }
                    catch (UnsupportedOperationException uoe) {
                        this.log.debug("Shutdown aborted by a handler");
                    }
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown() {
        Object latch;
        if (this.phase == ApplicationPhase.SHUTDOWN) {
            return false;
        }
        if (!this.canShutdown()) {
            return false;
        }
        this.log.info("Shutdown is in process");
        this.phase = ApplicationPhase.SHUTDOWN;
        this.log.debug("Shutdown stage 1: notify all event listeners");
        if (this.isEventPublishingEnabled()) {
            latch = new CountDownLatch(this.isUIThread() ? 1 : 0);
            this.addApplicationEventListener(GriffonApplication.Event.SHUTDOWN_START.getName(), new RunnableWithArgs((CountDownLatch)latch){
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$latch = countDownLatch;
                }

                public void run(Object[] args) {
                    this.val$latch.countDown();
                }
            });
            this.event(GriffonApplication.Event.SHUTDOWN_START.getName(), Arrays.asList(this));
            try {
                ((CountDownLatch)latch).await();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.log.debug("Shutdown stage 2: notify all shutdown handlers");
        latch = this.shutdownLock;
        synchronized (latch) {
            for (ShutdownHandler handler : this.shutdownHandlers) {
                handler.onShutdown(this);
            }
        }
        this.log.debug("Shutdown stage 3: destroy all MVC groups");
        ArrayList<String> mvcNames = new ArrayList<String>();
        if (this.getMvcGroupManager() != null) {
            mvcNames.addAll(this.getMvcGroupManager().getGroups().keySet());
            for (String name : mvcNames) {
                this.destroyMVCGroup(name);
            }
        }
        this.log.debug("Shutdown stage 4: execute Shutdown script");
        GriffonApplicationHelper.runLifecycleHandler(GriffonApplication.Lifecycle.SHUTDOWN.getName(), this);
        return true;
    }

    @Override
    public void startup() {
        if (this.phase != ApplicationPhase.INITIALIZE) {
            return;
        }
        this.phase = ApplicationPhase.STARTUP;
        this.event(GriffonApplication.Event.STARTUP_START.getName(), Arrays.asList(this));
        Object startupGroups = ConfigUtils.getConfigValue((Map)this.getConfig(), "application.startupGroups");
        if (startupGroups instanceof List) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Initializing all startup groups: " + startupGroups);
            }
            for (String groupName : (List)startupGroups) {
                this.createMVCGroup(groupName);
            }
        } else if (startupGroups != null && startupGroups.getClass().isArray()) {
            Object[] groups = (Object[])startupGroups;
            if (this.log.isInfoEnabled()) {
                this.log.info("Initializing all startup groups: " + Arrays.toString(groups));
            }
            for (Object groupName : groups) {
                this.createMVCGroup(String.valueOf(groupName));
            }
        }
        GriffonApplicationHelper.runLifecycleHandler(GriffonApplication.Lifecycle.STARTUP.getName(), this);
        this.event(GriffonApplication.Event.STARTUP_END.getName(), Arrays.asList(this));
    }

    @Override
    public void event(String eventName) {
        this.eventRouter.publish(eventName, Collections.emptyList());
    }

    @Override
    public void event(String eventName, List params) {
        this.eventRouter.publish(eventName, params);
    }

    @Override
    public void eventOutside(String eventName) {
        this.eventOutsideUI(eventName, Collections.emptyList());
    }

    @Override
    public void eventOutside(String eventName, List params) {
        this.eventOutsideUI(eventName, params);
    }

    @Override
    public void eventOutsideUI(String eventName) {
        this.eventRouter.publishOutsideUI(eventName, Collections.emptyList());
    }

    @Override
    public void eventOutsideUI(String eventName, List params) {
        this.eventRouter.publishOutsideUI(eventName, params);
    }

    @Override
    public void eventAsync(String eventName) {
        this.eventRouter.publishAsync(eventName, Collections.emptyList());
    }

    @Override
    public void eventAsync(String eventName, List params) {
        this.eventRouter.publishAsync(eventName, params);
    }

    @Override
    public void addApplicationEventListener(Object listener) {
        this.eventRouter.addEventListener(listener);
    }

    @Override
    public void removeApplicationEventListener(Object listener) {
        this.eventRouter.removeEventListener(listener);
    }

    @Override
    public void addApplicationEventListener(String eventName, Closure listener) {
        this.eventRouter.addEventListener(eventName, listener);
    }

    @Override
    public void removeApplicationEventListener(String eventName, Closure listener) {
        this.eventRouter.removeEventListener(eventName, listener);
    }

    @Override
    public void addApplicationEventListener(String eventName, RunnableWithArgs listener) {
        this.eventRouter.addEventListener(eventName, listener);
    }

    @Override
    public void removeApplicationEventListener(String eventName, RunnableWithArgs listener) {
        this.eventRouter.removeEventListener(eventName, listener);
    }

    @Override
    public boolean isEventPublishingEnabled() {
        return this.eventRouter.isEnabled();
    }

    @Override
    public void setEventPublishingEnabled(boolean enabled) {
        this.eventRouter.setEnabled(enabled);
    }

    @Override
    public Object createApplicationContainer() {
        return null;
    }

    @Override
    public void addShutdownHandler(ShutdownHandler handler) {
        if (handler != null && !this.shutdownHandlers.contains(handler)) {
            this.shutdownHandlers.add(handler);
        }
    }

    @Override
    public void removeShutdownHandler(ShutdownHandler handler) {
        if (handler != null) {
            this.shutdownHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationPhase getPhase() {
        Object object = this.lock;
        synchronized (object) {
            return this.phase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPhase(ApplicationPhase phase) {
        Object object = this.lock;
        synchronized (object) {
            this.phase = phase;
        }
    }

    @Override
    public boolean isUIThread() {
        return UIThreadManager.getInstance().isUIThread();
    }

    @Override
    public void execAsync(Runnable runnable) {
        this.execInsideUIAsync(runnable);
    }

    @Override
    public void execSync(Runnable runnable) {
        this.execInsideUIAsync(runnable);
    }

    @Override
    public void execOutside(Runnable runnable) {
        this.execOutsideUI(runnable);
    }

    @Override
    public void execInsideUIAsync(Runnable runnable) {
        UIThreadManager.getInstance().executeAsync(runnable);
    }

    @Override
    public void execInsideUISync(Runnable runnable) {
        UIThreadManager.getInstance().executeSync(runnable);
    }

    @Override
    public void execOutsideUI(Runnable runnable) {
        UIThreadManager.getInstance().executeOutside(runnable);
    }

    @Override
    public Future execFuture(ExecutorService executorService, Closure closure) {
        return UIThreadManager.getInstance().executeFuture(executorService, (Callable<?>)closure);
    }

    @Override
    public Future execFuture(Closure closure) {
        return UIThreadManager.getInstance().executeFuture((Callable<?>)closure);
    }

    @Override
    public Future execFuture(ExecutorService executorService, Callable callable) {
        return UIThreadManager.getInstance().executeFuture(executorService, callable);
    }

    @Override
    public Future execFuture(Callable callable) {
        return UIThreadManager.getInstance().executeFuture(callable);
    }

    @Override
    public Object newInstance(Class clazz, String type) {
        return GriffonApplicationHelper.newInstance(this, clazz, type);
    }

    @Override
    public MVCGroup buildMVCGroup(String mvcType) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, null, Collections.<String, Object>emptyMap());
    }

    @Override
    public MVCGroup buildMVCGroup(String mvcType, String mvcName) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, mvcName, Collections.<String, Object>emptyMap());
    }

    @Override
    public MVCGroup buildMVCGroup(Map<String, Object> args, String mvcType) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, null, args);
    }

    @Override
    public MVCGroup buildMVCGroup(String mvcType, Map<String, Object> args) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, null, args);
    }

    @Override
    public MVCGroup buildMVCGroup(Map<String, Object> args, String mvcType, String mvcName) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, mvcName, args);
    }

    @Override
    public MVCGroup buildMVCGroup(String mvcType, String mvcName, Map<String, Object> args) {
        return this.getMvcGroupManager().buildMVCGroup(mvcType, mvcName, args);
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, null, Collections.<String, Object>emptyMap());
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(Map<String, Object> args, String mvcType) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, null, args);
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, Map<String, Object> args) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, null, args);
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, String mvcName) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, mvcName, Collections.<String, Object>emptyMap());
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(Map<String, Object> args, String mvcType, String mvcName) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, mvcName, args);
    }

    @Override
    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, String mvcName, Map<String, Object> args) {
        return this.getMvcGroupManager().createMVCGroup(mvcType, mvcName, args);
    }

    @Override
    public void destroyMVCGroup(String mvcName) {
        this.getMvcGroupManager().destroyMVCGroup(mvcName);
    }

    @Override
    public void withMVCGroup(String mvcType, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, Collections.<String, Object>emptyMap(), handler);
    }

    @Override
    public void withMVCGroup(String mvcType, String mvcName, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, Collections.<String, Object>emptyMap(), handler);
    }

    @Override
    public void withMVCGroup(String mvcType, Map<String, Object> args, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    @Override
    public void withMVCGroup(Map<String, Object> args, String mvcType, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    @Override
    public void withMVCGroup(String mvcType, String mvcName, Map<String, Object> args, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    @Override
    public void withMVCGroup(Map<String, Object> args, String mvcType, String mvcName, Closure handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, Collections.<String, Object>emptyMap(), handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, String mvcName, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, Collections.<String, Object>emptyMap(), handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(Map<String, Object> args, String mvcType, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, String mvcName, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    @Override
    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(Map<String, Object> args, String mvcType, String mvcName, MVCClosure<M, V, C> handler) {
        this.getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    private Class loadClass(String className) {
        try {
            return this.getClass().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.resourceLocator.getResourceAsStream(name);
    }

    @Override
    public URL getResourceAsURL(String name) {
        return this.resourceLocator.getResourceAsURL(name);
    }

    @Override
    public List<URL> getResources(String name) {
        return this.resourceLocator.getResources(name);
    }
}

