/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.exceptions.NewInstanceCreationException;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import groovy.lang.ClosureInvokingMethod;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.codehaus.griffon.runtime.core.ClassPropertyFetcher;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGriffonClass
implements GriffonClass {
    private final Class<?> clazz;
    private final String type;
    private final GriffonApplication app;
    private final String fullName;
    private final String name;
    private final String packageName;
    private final String naturalName;
    private final String shortName;
    private final String propertyName;
    private final String logicalPropertyName;
    private final ClassPropertyFetcher classPropertyFetcher;
    protected final Set<String> eventsCache = new TreeSet<String>();
    protected final Logger log;

    public AbstractGriffonClass(GriffonApplication app, Class<?> clazz, String type, String trailingName) {
        this.app = app;
        this.clazz = clazz;
        this.type = type;
        this.fullName = clazz.getName();
        this.log = LoggerFactory.getLogger((String)(this.getClass().getSimpleName() + "[" + this.fullName + "]"));
        this.packageName = GriffonClassUtils.getPackageName(clazz);
        this.naturalName = GriffonNameUtils.getNaturalName(clazz.getName());
        this.shortName = GriffonClassUtils.getShortClassName(clazz);
        this.name = GriffonNameUtils.getLogicalName(clazz, trailingName);
        this.propertyName = GriffonNameUtils.getPropertyNameRepresentation(this.shortName);
        this.logicalPropertyName = GriffonNameUtils.isBlank(this.name) ? this.propertyName : GriffonNameUtils.getPropertyNameRepresentation(this.name);
        this.classPropertyFetcher = ClassPropertyFetcher.forClass(clazz);
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public String getArtifactType() {
        return this.type;
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }

    @Override
    public Object newInstance() {
        try {
            Object instance = GriffonApplicationHelper.newInstance(this.app, this.clazz, this.type);
            InvokerHelper.setProperty((Object)instance, (String)"app", (Object)this.app);
            return instance;
        }
        catch (Exception e) {
            Throwable targetException = null;
            targetException = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            throw new NewInstanceCreationException("Could not create a new instance of class " + this.clazz.getName(), GriffonExceptionHandler.sanitize(targetException));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNaturalName() {
        return this.naturalName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getLogicalPropertyName() {
        return this.logicalPropertyName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public Object getReferenceInstance() {
        Object obj = this.classPropertyFetcher.getReference();
        MetaClass myMetaClass = this.getMetaClass();
        if (obj instanceof GroovyObject) {
            MetaClass otherMetaClass = ((GroovyObject)obj).getMetaClass();
            if (myMetaClass != otherMetaClass) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Setting MetaClass " + myMetaClass + " on GroovyObject " + obj);
                }
                ((GroovyObject)obj).setMetaClass(myMetaClass);
            }
        } else {
            MetaClass otherMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(this.clazz);
            if (myMetaClass != otherMetaClass) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Setting MetaClass " + myMetaClass + " on non-GroovyObject " + obj);
                }
                GroovySystem.getMetaClassRegistry().setMetaClass(this.clazz, myMetaClass);
            }
        }
        return obj;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.classPropertyFetcher.getPropertyDescriptors();
    }

    public String[] getPropertiesWithFields() {
        return this.classPropertyFetcher.getPropertiesWithFields();
    }

    public Class<?> getPropertyType(String name) {
        return this.classPropertyFetcher.getPropertyType(name);
    }

    public boolean isReadableProperty(String name) {
        return this.classPropertyFetcher.isReadableProperty(name);
    }

    public boolean hasMetaMethod(String name) {
        return this.hasMetaMethod(name, null);
    }

    public boolean hasMetaMethod(String name, Object[] args) {
        return this.getMetaClass().getMetaMethod(name, args) != null;
    }

    public boolean hasMetaProperty(String name) {
        return this.getMetaClass().getMetaProperty(name) != null;
    }

    public MetaProperty[] getMetaProperties() {
        ArrayList<MetaProperty> properties = new ArrayList<MetaProperty>();
        for (MetaProperty property : this.getMetaClass().getProperties()) {
            if ("class".equals(property.getName()) || "metaClass".equals(property.getName())) continue;
            properties.add(property);
        }
        return properties.toArray(new MetaProperty[properties.size()]);
    }

    protected Object getPropertyOrStaticPropertyOrFieldValue(String name, Class<?> type) {
        Object value = this.classPropertyFetcher.getPropertyValue(name);
        return this.returnOnlyIfInstanceOf(value, type);
    }

    public <T> T getStaticPropertyValue(String propName, Class<T> type) {
        T value = this.classPropertyFetcher.getStaticPropertyValue(propName, type);
        if (value == null) {
            return this.getGroovyProperty(propName, type, true);
        }
        return value;
    }

    @Override
    public <T> T getPropertyValue(String propName, Class<T> type) {
        T value = this.classPropertyFetcher.getPropertyValue(propName, type);
        if (value == null) {
            return this.getGroovyProperty(propName, type, false);
        }
        return this.returnOnlyIfInstanceOf(value, type);
    }

    private <T> T getGroovyProperty(String propName, Class<T> type, boolean onlyStatic) {
        MetaProperty metaProperty;
        Object value = null;
        if (GroovyObject.class.isAssignableFrom(this.getClazz()) && (metaProperty = this.getMetaClass().getMetaProperty(propName)) != null) {
            int modifiers = metaProperty.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                value = metaProperty.getProperty(this.clazz);
            } else if (!onlyStatic) {
                value = metaProperty.getProperty(this.getReferenceInstance());
            }
        }
        return this.returnOnlyIfInstanceOf(value, type);
    }

    public Object getPropertyValueObject(String propertyNAme) {
        return this.getPropertyValue(propertyNAme, Object.class);
    }

    private <T> T returnOnlyIfInstanceOf(Object value, Class<T> type) {
        if (value != null && (type == Object.class || GriffonClassUtils.isGroovyAssignableFrom(type, value.getClass()))) {
            return (T)value;
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.getPropertyOrStaticPropertyOrFieldValue(name, Object.class);
    }

    public boolean isClosureMetaProperty(MetaProperty property) {
        int modifiers = property.getModifiers();
        if (modifiers != 1) {
            return false;
        }
        Object value = property.getProperty(this.getReferenceInstance());
        if (value != null) {
            return Closure.class.isAssignableFrom(value.getClass());
        }
        if (property instanceof MetaBeanProperty) {
            MetaMethod getter = ((MetaBeanProperty)property).getGetter();
            return getter instanceof ClosureInvokingMethod;
        }
        return false;
    }

    @Override
    public boolean hasProperty(String propName) {
        return this.classPropertyFetcher.isReadableProperty(propName);
    }

    @Override
    public MetaClass getMetaClass() {
        return GriffonApplicationHelper.expandoMetaClassFor(this.clazz);
    }

    public void setMetaClass(MetaClass metaClass) {
        GroovySystem.getMetaClassRegistry().setMetaClass(this.clazz, metaClass);
    }

    public String toString() {
        return "Artifact[" + this.type + "] > " + this.getName();
    }

    public void resetCaches() {
        this.eventsCache.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        GriffonClass gc = (GriffonClass)obj;
        return this.clazz.getName().equals(gc.getClazz().getName());
    }

    public int hashCode() {
        return this.clazz.hashCode() + this.type.hashCode();
    }

    public void updateMetaClass(Closure updater) {
        if (updater == null) {
            return;
        }
        updater.setDelegate((Object)this.getMetaClass());
        updater.setResolveStrategy(1);
        updater.run();
        this.resetCaches();
    }

    public String[] getEventNames() {
        if (this.eventsCache.isEmpty()) {
            for (String propertyName : this.getPropertiesWithFields()) {
                if (this.eventsCache.contains(propertyName) || !GriffonClassUtils.isEventHandler(propertyName) || this.getPropertyValue(propertyName, Closure.class) == null) continue;
                this.eventsCache.add(propertyName.substring(2));
            }
            for (Method method : this.getClazz().getMethods()) {
                String methodName = method.getName();
                if (this.eventsCache.contains(methodName) || !GriffonClassUtils.isPlainMethod(method) || !GriffonClassUtils.isEventHandler(methodName)) continue;
                this.eventsCache.add(methodName.substring(2));
            }
            for (MetaProperty p : this.getMetaProperties()) {
                String propertyName = p.getName();
                if (GriffonClassUtils.isGetter(p, true)) {
                    propertyName = GriffonNameUtils.uncapitalize(propertyName.substring(3));
                }
                if (this.eventsCache.contains(propertyName) || !GriffonClassUtils.isEventHandler(propertyName) || !this.isClosureMetaProperty(p)) continue;
                this.eventsCache.add(propertyName.substring(2));
            }
            for (MetaMethod method : this.getMetaClass().getMethods()) {
                String methodName = method.getName();
                if (this.eventsCache.contains(methodName) || !GriffonClassUtils.isPlainMethod(method) || !GriffonClassUtils.isEventHandler(methodName)) continue;
                this.eventsCache.add(methodName.substring(2));
            }
        }
        return this.eventsCache.toArray(new String[this.eventsCache.size()]);
    }
}

