/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonView;
import griffon.util.GriffonNameUtils;
import griffon.util.Xml2Groovy;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.util.FactoryBuilderSupport;
import java.io.InputStream;
import java.util.Map;
import org.codehaus.griffon.runtime.core.AbstractGriffonMvcArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGriffonView
extends AbstractGriffonMvcArtifact
implements GriffonView {
    private FactoryBuilderSupport builder;

    @Override
    protected String getArtifactType() {
        return "view";
    }

    public FactoryBuilderSupport getBuilder() {
        return this.builder;
    }

    @Override
    public void setBuilder(FactoryBuilderSupport builder) {
        this.builder = builder;
    }

    public void buildViewFromXml(Map<String, Object> args) {
        this.buildViewFromXml(args, this.getClass().getName().replace('.', '/') + ".xml");
    }

    public void buildViewFromXml(Map<String, Object> args, String fileName) {
        if (GriffonNameUtils.isBlank(fileName)) {
            throw new IllegalArgumentException("Invalid file name for externalized view.");
        }
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        if (is == null) {
            throw new IllegalArgumentException("Could not read file " + fileName);
        }
        String groovyScript = Xml2Groovy.getInstance().parse(is);
        if (GriffonNameUtils.isBlank(groovyScript)) {
            throw new IllegalArgumentException("File " + fileName + " is empty.");
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace("View script for " + fileName + "\n" + groovyScript);
        }
        final Script script = new GroovyShell().parse(groovyScript);
        script.setBinding((Binding)this.getBuilder());
        for (Map.Entry<String, Object> arg : args.entrySet()) {
            script.getBinding().setVariable(arg.getKey(), arg.getValue());
        }
        this.getApp().execSync(new Runnable(){

            public void run() {
                AbstractGriffonView.this.getBuilder().build(script);
            }
        });
    }
}

