/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.GriffonController;
import griffon.core.GriffonModel;
import griffon.core.GriffonView;
import griffon.core.MVCGroup;
import griffon.core.MVCGroupConfiguration;
import griffon.core.UIThreadManager;
import groovy.lang.Script;
import groovy.util.FactoryBuilderSupport;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMVCGroup
implements MVCGroup {
    protected final GriffonApplication app;
    protected final MVCGroupConfiguration configuration;
    protected final String mvcId;
    protected final Map<String, Object> members = new LinkedHashMap<String, Object>();
    private boolean alive;
    private final Object[] lock = new Object[0];
    protected final Map<String, Object> scriptResults = new LinkedHashMap<String, Object>();

    public AbstractMVCGroup(GriffonApplication app, MVCGroupConfiguration configuration, String mvcId, Map<String, Object> members) {
        this.app = app;
        this.configuration = configuration;
        this.mvcId = mvcId == null ? configuration.getMvcType() + "-" + UUID.randomUUID().toString() : mvcId;
        this.members.putAll(members);
        this.alive = true;
    }

    @Override
    public GriffonApplication getApp() {
        return this.app;
    }

    @Override
    public MVCGroupConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getMvcType() {
        return this.configuration.getMvcType();
    }

    @Override
    public String getMvcId() {
        return this.mvcId;
    }

    @Override
    public GriffonModel getModel() {
        return (GriffonModel)this.getMember("model");
    }

    @Override
    public GriffonView getView() {
        return (GriffonView)this.getMember("view");
    }

    @Override
    public GriffonController getController() {
        return (GriffonController)this.getMember("controller");
    }

    @Override
    public FactoryBuilderSupport getBuilder() {
        return (FactoryBuilderSupport)this.getMember("builder");
    }

    @Override
    public Object getMember(String name) {
        this.checkIfAlive();
        return this.members.get(name);
    }

    @Override
    public Map<String, Object> getMembers() {
        this.checkIfAlive();
        return Collections.unmodifiableMap(this.members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.checkIfAlive();
        this.app.getMvcGroupManager().destroyMVCGroup(this.mvcId);
        this.members.clear();
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.alive = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlive() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.alive;
        }
    }

    protected void checkIfAlive() {
        if (!this.isAlive()) {
            throw new IllegalStateException("Group " + this.getMvcType() + ":" + this.mvcId + " has been destroyed already.");
        }
    }

    @Override
    public Object getScriptResult(String name) {
        return this.scriptResults.get(name);
    }

    @Override
    public void buildScriptMember(final String name) {
        Object member = this.members.get(name);
        if (!(member instanceof Script)) {
            return;
        }
        final Script script = (Script)member;
        if ("view".equals(name)) {
            UIThreadManager.getInstance().executeSync(new Runnable(){

                public void run() {
                    AbstractMVCGroup.this.scriptResults.put(name, AbstractMVCGroup.this.getBuilder().build(script));
                }
            });
        } else {
            this.scriptResults.put(name, this.getBuilder().build(script));
        }
    }
}

