/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.core;

import griffon.core.GriffonApplication;
import griffon.core.GriffonServiceClass;
import griffon.util.GriffonClassUtils;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.griffon.runtime.core.DefaultGriffonClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGriffonServiceClass
extends DefaultGriffonClass
implements GriffonServiceClass {
    protected final Set<String> serviceCache = new LinkedHashSet<String>();

    public DefaultGriffonServiceClass(GriffonApplication app, Class<?> clazz) {
        super(app, clazz, "service", "Service");
    }

    @Override
    public void resetCaches() {
        super.resetCaches();
        this.serviceCache.clear();
    }

    @Override
    public String[] getServiceNames() {
        if (this.serviceCache.isEmpty()) {
            for (String propertyName : this.getPropertiesWithFields()) {
                if (STANDARD_PROPERTIES.contains(propertyName) || this.serviceCache.contains(propertyName) || GriffonClassUtils.isEventHandler(propertyName) || this.getPropertyValue(propertyName, Closure.class) == null) continue;
                this.serviceCache.add(propertyName);
            }
            for (Method method : this.getClazz().getMethods()) {
                String methodName = method.getName();
                if (this.serviceCache.contains(methodName) || !GriffonClassUtils.isPlainMethod(method) || GriffonClassUtils.isEventHandler(methodName)) continue;
                this.serviceCache.add(methodName);
            }
            for (MetaProperty p : this.getMetaProperties()) {
                String propertyName = p.getName();
                if (GriffonClassUtils.isGetter(p, true)) {
                    propertyName = GriffonNameUtils.uncapitalize(propertyName.substring(3));
                }
                if (STANDARD_PROPERTIES.contains(propertyName) || this.serviceCache.contains(propertyName) || GriffonClassUtils.isEventHandler(propertyName) || !this.isClosureMetaProperty(p)) continue;
                this.serviceCache.add(propertyName);
            }
            for (MetaMethod method : this.getMetaClass().getMethods()) {
                String methodName = method.getName();
                if (this.serviceCache.contains(methodName) || !GriffonClassUtils.isPlainMethod(method) || GriffonClassUtils.isEventHandler(methodName)) continue;
                this.serviceCache.add(methodName);
            }
        }
        return this.serviceCache.toArray(new String[this.serviceCache.size()]);
    }
}

