/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.util;

import griffon.util.GriffonExceptionHandler;
import griffon.util.UIThreadHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class AbstractUIThreadHandler
implements UIThreadHandler {
    protected static final ExecutorService DEFAULT_EXECUTOR_SERVICE = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = new GriffonExceptionHandler();

    public void executeOutside(final Runnable runnable) {
        if (!this.isUIThread()) {
            runnable.run();
        } else {
            DEFAULT_EXECUTOR_SERVICE.submit(new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), throwable);
                    }
                }
            });
        }
    }
}

