/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.cli.shell;

import griffon.util.BuildSettingsHolder;
import griffon.util.Environment;
import griffon.util.GriffonNameUtils;
import griffon.util.GriffonUtil;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.codehaus.griffon.cli.GriffonScriptRunner;
import org.codehaus.griffon.cli.shell.GriffonCommand;
import org.codehaus.griffon.cli.shell.GriffonShellContext;
import org.codehaus.griffon.cli.shell.support.CommandArguments;

public abstract class AbstractGriffonShellCommand
implements GriffonCommand {
    @Option(name="--env", description="Sets the environment to use.")
    protected String env = Environment.DEVELOPMENT.getName();
    @Option(name="--non-interactive", description="Controls if the shell can ask for input or not.")
    protected boolean nonInteractive = false;
    private CommandArguments commandArguments;

    public CommandArguments getCommandArguments() {
        return this.commandArguments;
    }

    public void setCommandArguments(CommandArguments commandArguments) {
        this.commandArguments = commandArguments;
    }

    public Object execute(CommandSession session) throws Exception {
        GriffonScriptRunner runner = GriffonShellContext.getGriffonScriptRunner();
        this.setEnvironment(runner);
        return this.doExecute(session, this.commandArguments);
    }

    private void setEnvironment(GriffonScriptRunner runner) {
        System.clearProperty("griffon.env");
        runner.setRunningEnvironment(this.getScriptName(), this.env);
        runner.setInteractive(!this.nonInteractive);
        String currentEnvironment = BuildSettingsHolder.getSettings().getGriffonEnv();
        if (!currentEnvironment.equalsIgnoreCase(GriffonShellContext.getLastEnvironment())) {
            System.clearProperty("griffon.env.set");
        }
        GriffonShellContext.setLastEnvironment(currentEnvironment);
    }

    protected String getScriptName() {
        return GriffonUtil.getScriptName((String)GriffonNameUtils.getShortName((String)this.getClass().getName()));
    }

    protected abstract Object doExecute(CommandSession var1, CommandArguments var2) throws Exception;
}

