
# Overview

This directory contains source code for C++ implementation of gRPC.

To install gRPC for C++ on your system, follow the instructions to build from source
[here](../../INSTALL.md). This also installs the protocol buffer compiler
`protoc` (if you don't have it already), and the C++ gRPC plugin for `protoc`.

# Documentation

You can find out how to build and run our simplest gRPC C++ example in our
[C++ quick start](../../examples/cpp).

For more detailed documentation on using gRPC in C++ , see our main
documentation site at [grpc.io](https://grpc.io), specifically:

* [Overview](https://grpc.io/docs/): An introduction to gRPC with a simple
  Hello World example in all our supported languages, including C++.
* [gRPC Basics - C++](https://grpc.io/docs/tutorials/basic/c.html):
  A tutorial that steps you through creating a simple gRPC C++ example
  application.
* [Asynchronous Basics - C++](https://grpc.io/docs/tutorials/async/helloasync-cpp.html):
  A tutorial that shows you how to use gRPC C++'s asynchronous/non-blocking
  APIs.


# Examples

Code examples for gRPC C++ live in this repository's
[examples/cpp](../../examples/cpp) directory.
