# -*- ruby -*-
# encoding: utf-8
$LOAD_PATH.push File.expand_path('../src/ruby/lib', __FILE__)
require 'grpc/version'

Gem::Specification.new do |s|
  s.name          = 'grpc'
  s.version       = GRPC::VERSION
  s.authors       = ['gRPC Authors']
  s.email         = 'temiola@google.com'
  s.homepage      = 'https://github.com/google/grpc/tree/master/src/ruby'
  s.summary       = 'GRPC system in Ruby'
  s.description   = 'Send RPCs from Ruby using GRPC'
  s.license       = 'Apache-2.0'

  s.required_ruby_version = '>= 2.0.0'

  s.files = %w( Makefile .yardopts )
  s.files += %w( etc/roots.pem )
  s.files += Dir.glob('src/ruby/bin/**/*')
  s.files += Dir.glob('src/ruby/ext/**/*')
  s.files += Dir.glob('src/ruby/lib/**/*')
  s.files += Dir.glob('src/ruby/pb/**/*')
  s.files += Dir.glob('include/grpc/**/*')
  s.test_files = Dir.glob('src/ruby/spec/**/*')
  s.bindir = 'src/ruby/bin'
  s.require_paths = %w( src/ruby/lib src/ruby/bin src/ruby/pb )
  s.platform      = Gem::Platform::RUBY

  s.add_dependency 'google-protobuf', '~> 3.1'
  s.add_dependency 'googleauth',      '>= 0.5.1', '< 0.7'
  s.add_dependency 'googleapis-common-protos-types', '~> 1.0.0'

  s.add_development_dependency 'bundler',            '~> 1.9'
  s.add_development_dependency 'facter',             '~> 2.4'
  s.add_development_dependency 'logging',            '~> 2.0'
  s.add_development_dependency 'simplecov',          '~> 0.14.1'
  s.add_development_dependency 'rake',               '~> 12.0'
  s.add_development_dependency 'rake-compiler',      '~> 1.0'
  s.add_development_dependency 'rake-compiler-dock', '~> 0.5.1'
  s.add_development_dependency 'rspec',              '~> 3.6'
  s.add_development_dependency 'rubocop',            '~> 0.49.1'
  s.add_development_dependency 'signet',             '~> 0.7.0'

  s.extensions = %w(src/ruby/ext/grpc/extconf.rb)

  s.files += %w( include/grpc/support/alloc.h )
  s.files += %w( include/grpc/support/atm.h )
  s.files += %w( include/grpc/support/atm_gcc_atomic.h )
  s.files += %w( include/grpc/support/atm_gcc_sync.h )
  s.files += %w( include/grpc/support/atm_windows.h )
  s.files += %w( include/grpc/support/avl.h )
  s.files += %w( include/grpc/support/cmdline.h )
  s.files += %w( include/grpc/support/cpu.h )
  s.files += %w( include/grpc/support/host_port.h )
  s.files += %w( include/grpc/support/log.h )
  s.files += %w( include/grpc/support/log_windows.h )
  s.files += %w( include/grpc/support/port_platform.h )
  s.files += %w( include/grpc/support/string_util.h )
  s.files += %w( include/grpc/support/subprocess.h )
  s.files += %w( include/grpc/support/sync.h )
  s.files += %w( include/grpc/support/sync_custom.h )
  s.files += %w( include/grpc/support/sync_generic.h )
  s.files += %w( include/grpc/support/sync_posix.h )
  s.files += %w( include/grpc/support/sync_windows.h )
  s.files += %w( include/grpc/support/thd.h )
  s.files += %w( include/grpc/support/time.h )
  s.files += %w( include/grpc/support/tls.h )
  s.files += %w( include/grpc/support/tls_gcc.h )
  s.files += %w( include/grpc/support/tls_msvc.h )
  s.files += %w( include/grpc/support/tls_pthread.h )
  s.files += %w( include/grpc/support/useful.h )
  s.files += %w( include/grpc/impl/codegen/atm.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_atomic.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_sync.h )
  s.files += %w( include/grpc/impl/codegen/atm_windows.h )
  s.files += %w( include/grpc/impl/codegen/fork.h )
  s.files += %w( include/grpc/impl/codegen/gpr_slice.h )
  s.files += %w( include/grpc/impl/codegen/gpr_types.h )
  s.files += %w( include/grpc/impl/codegen/port_platform.h )
  s.files += %w( include/grpc/impl/codegen/sync.h )
  s.files += %w( include/grpc/impl/codegen/sync_custom.h )
  s.files += %w( include/grpc/impl/codegen/sync_generic.h )
  s.files += %w( include/grpc/impl/codegen/sync_posix.h )
  s.files += %w( include/grpc/impl/codegen/sync_windows.h )
  s.files += %w( src/core/lib/gpr++/abstract.h )
  s.files += %w( src/core/lib/gpr++/atomic.h )
  s.files += %w( src/core/lib/gpr++/atomic_with_atm.h )
  s.files += %w( src/core/lib/gpr++/atomic_with_std.h )
  s.files += %w( src/core/lib/gpr++/manual_constructor.h )
  s.files += %w( src/core/lib/gpr++/memory.h )
  s.files += %w( src/core/lib/gpr/arena.h )
  s.files += %w( src/core/lib/gpr/env.h )
  s.files += %w( src/core/lib/gpr/fork.h )
  s.files += %w( src/core/lib/gpr/mpscq.h )
  s.files += %w( src/core/lib/gpr/murmur_hash.h )
  s.files += %w( src/core/lib/gpr/spinlock.h )
  s.files += %w( src/core/lib/gpr/string.h )
  s.files += %w( src/core/lib/gpr/string_windows.h )
  s.files += %w( src/core/lib/gpr/thd_internal.h )
  s.files += %w( src/core/lib/gpr/time_precise.h )
  s.files += %w( src/core/lib/gpr/tmpfile.h )
  s.files += %w( src/core/lib/profiling/timers.h )
  s.files += %w( src/core/lib/gpr/alloc.cc )
  s.files += %w( src/core/lib/gpr/arena.cc )
  s.files += %w( src/core/lib/gpr/atm.cc )
  s.files += %w( src/core/lib/gpr/avl.cc )
  s.files += %w( src/core/lib/gpr/cmdline.cc )
  s.files += %w( src/core/lib/gpr/cpu_iphone.cc )
  s.files += %w( src/core/lib/gpr/cpu_linux.cc )
  s.files += %w( src/core/lib/gpr/cpu_posix.cc )
  s.files += %w( src/core/lib/gpr/cpu_windows.cc )
  s.files += %w( src/core/lib/gpr/env_linux.cc )
  s.files += %w( src/core/lib/gpr/env_posix.cc )
  s.files += %w( src/core/lib/gpr/env_windows.cc )
  s.files += %w( src/core/lib/gpr/fork.cc )
  s.files += %w( src/core/lib/gpr/host_port.cc )
  s.files += %w( src/core/lib/gpr/log.cc )
  s.files += %w( src/core/lib/gpr/log_android.cc )
  s.files += %w( src/core/lib/gpr/log_linux.cc )
  s.files += %w( src/core/lib/gpr/log_posix.cc )
  s.files += %w( src/core/lib/gpr/log_windows.cc )
  s.files += %w( src/core/lib/gpr/mpscq.cc )
  s.files += %w( src/core/lib/gpr/murmur_hash.cc )
  s.files += %w( src/core/lib/gpr/string.cc )
  s.files += %w( src/core/lib/gpr/string_posix.cc )
  s.files += %w( src/core/lib/gpr/string_util_windows.cc )
  s.files += %w( src/core/lib/gpr/string_windows.cc )
  s.files += %w( src/core/lib/gpr/subprocess_posix.cc )
  s.files += %w( src/core/lib/gpr/subprocess_windows.cc )
  s.files += %w( src/core/lib/gpr/sync.cc )
  s.files += %w( src/core/lib/gpr/sync_posix.cc )
  s.files += %w( src/core/lib/gpr/sync_windows.cc )
  s.files += %w( src/core/lib/gpr/thd.cc )
  s.files += %w( src/core/lib/gpr/thd_posix.cc )
  s.files += %w( src/core/lib/gpr/thd_windows.cc )
  s.files += %w( src/core/lib/gpr/time.cc )
  s.files += %w( src/core/lib/gpr/time_posix.cc )
  s.files += %w( src/core/lib/gpr/time_precise.cc )
  s.files += %w( src/core/lib/gpr/time_windows.cc )
  s.files += %w( src/core/lib/gpr/tls_pthread.cc )
  s.files += %w( src/core/lib/gpr/tmpfile_msys.cc )
  s.files += %w( src/core/lib/gpr/tmpfile_posix.cc )
  s.files += %w( src/core/lib/gpr/tmpfile_windows.cc )
  s.files += %w( src/core/lib/gpr/wrap_memcpy.cc )
  s.files += %w( src/core/lib/profiling/basic_timers.cc )
  s.files += %w( src/core/lib/profiling/stap_timers.cc )
  s.files += %w( include/grpc/impl/codegen/byte_buffer.h )
  s.files += %w( include/grpc/impl/codegen/byte_buffer_reader.h )
  s.files += %w( include/grpc/impl/codegen/compression_types.h )
  s.files += %w( include/grpc/impl/codegen/connectivity_state.h )
  s.files += %w( include/grpc/impl/codegen/grpc_types.h )
  s.files += %w( include/grpc/impl/codegen/propagation_bits.h )
  s.files += %w( include/grpc/impl/codegen/slice.h )
  s.files += %w( include/grpc/impl/codegen/status.h )
  s.files += %w( include/grpc/impl/codegen/atm.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_atomic.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_sync.h )
  s.files += %w( include/grpc/impl/codegen/atm_windows.h )
  s.files += %w( include/grpc/impl/codegen/fork.h )
  s.files += %w( include/grpc/impl/codegen/gpr_slice.h )
  s.files += %w( include/grpc/impl/codegen/gpr_types.h )
  s.files += %w( include/grpc/impl/codegen/port_platform.h )
  s.files += %w( include/grpc/impl/codegen/sync.h )
  s.files += %w( include/grpc/impl/codegen/sync_custom.h )
  s.files += %w( include/grpc/impl/codegen/sync_generic.h )
  s.files += %w( include/grpc/impl/codegen/sync_posix.h )
  s.files += %w( include/grpc/impl/codegen/sync_windows.h )
  s.files += %w( include/grpc/grpc_security.h )
  s.files += %w( include/grpc/byte_buffer.h )
  s.files += %w( include/grpc/byte_buffer_reader.h )
  s.files += %w( include/grpc/compression.h )
  s.files += %w( include/grpc/fork.h )
  s.files += %w( include/grpc/grpc.h )
  s.files += %w( include/grpc/grpc_posix.h )
  s.files += %w( include/grpc/grpc_security_constants.h )
  s.files += %w( include/grpc/load_reporting.h )
  s.files += %w( include/grpc/slice.h )
  s.files += %w( include/grpc/slice_buffer.h )
  s.files += %w( include/grpc/status.h )
  s.files += %w( include/grpc/support/workaround_list.h )
  s.files += %w( include/grpc/census.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_decoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_encoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_transport.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/flow_control.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_data.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_goaway.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_ping.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_rst_stream.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_settings.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_window_update.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_table.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/huffsyms.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/incoming_metadata.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/internal.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_map.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/varint.h )
  s.files += %w( src/core/ext/transport/chttp2/alpn/alpn.h )
  s.files += %w( src/core/ext/filters/http/client/http_client_filter.h )
  s.files += %w( src/core/ext/filters/http/message_compress/message_compress_filter.h )
  s.files += %w( src/core/ext/filters/http/server/http_server_filter.h )
  s.files += %w( src/core/lib/security/context/security_context.h )
  s.files += %w( src/core/lib/security/credentials/composite/composite_credentials.h )
  s.files += %w( src/core/lib/security/credentials/credentials.h )
  s.files += %w( src/core/lib/security/credentials/fake/fake_credentials.h )
  s.files += %w( src/core/lib/security/credentials/google_default/google_default_credentials.h )
  s.files += %w( src/core/lib/security/credentials/iam/iam_credentials.h )
  s.files += %w( src/core/lib/security/credentials/jwt/json_token.h )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_credentials.h )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_verifier.h )
  s.files += %w( src/core/lib/security/credentials/oauth2/oauth2_credentials.h )
  s.files += %w( src/core/lib/security/credentials/plugin/plugin_credentials.h )
  s.files += %w( src/core/lib/security/credentials/ssl/ssl_credentials.h )
  s.files += %w( src/core/lib/security/transport/auth_filters.h )
  s.files += %w( src/core/lib/security/transport/lb_targets_info.h )
  s.files += %w( src/core/lib/security/transport/secure_endpoint.h )
  s.files += %w( src/core/lib/security/transport/security_connector.h )
  s.files += %w( src/core/lib/security/transport/security_handshaker.h )
  s.files += %w( src/core/lib/security/transport/tsi_error.h )
  s.files += %w( src/core/lib/security/util/json_util.h )
  s.files += %w( src/core/tsi/fake_transport_security.h )
  s.files += %w( src/core/tsi/gts_transport_security.h )
  s.files += %w( src/core/tsi/ssl_transport_security.h )
  s.files += %w( src/core/tsi/ssl_types.h )
  s.files += %w( src/core/tsi/transport_security_grpc.h )
  s.files += %w( src/core/tsi/transport_security.h )
  s.files += %w( src/core/tsi/transport_security_adapter.h )
  s.files += %w( src/core/tsi/transport_security_interface.h )
  s.files += %w( src/core/ext/transport/chttp2/server/chttp2_server.h )
  s.files += %w( src/core/ext/filters/client_channel/backup_poller.h )
  s.files += %w( src/core/ext/filters/client_channel/client_channel.h )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_factory.h )
  s.files += %w( src/core/ext/filters/client_channel/connector.h )
  s.files += %w( src/core/ext/filters/client_channel/http_connect_handshaker.h )
  s.files += %w( src/core/ext/filters/client_channel/http_proxy.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy_factory.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy_registry.h )
  s.files += %w( src/core/ext/filters/client_channel/parse_address.h )
  s.files += %w( src/core/ext/filters/client_channel/proxy_mapper.h )
  s.files += %w( src/core/ext/filters/client_channel/proxy_mapper_registry.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver_factory.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver_registry.h )
  s.files += %w( src/core/ext/filters/client_channel/retry_throttle.h )
  s.files += %w( src/core/ext/filters/client_channel/subchannel.h )
  s.files += %w( src/core/ext/filters/client_channel/subchannel_index.h )
  s.files += %w( src/core/ext/filters/client_channel/uri_parser.h )
  s.files += %w( src/core/ext/filters/deadline/deadline_filter.h )
  s.files += %w( src/core/ext/transport/chttp2/client/chttp2_connector.h )
  s.files += %w( src/core/ext/transport/inproc/inproc_transport.h )
  s.files += %w( src/core/lib/backoff/backoff.h )
  s.files += %w( src/core/lib/channel/channel_args.h )
  s.files += %w( src/core/lib/channel/channel_stack.h )
  s.files += %w( src/core/lib/channel/channel_stack_builder.h )
  s.files += %w( src/core/lib/channel/connected_channel.h )
  s.files += %w( src/core/lib/channel/context.h )
  s.files += %w( src/core/lib/channel/handshaker.h )
  s.files += %w( src/core/lib/channel/handshaker_factory.h )
  s.files += %w( src/core/lib/channel/handshaker_registry.h )
  s.files += %w( src/core/lib/compression/algorithm_metadata.h )
  s.files += %w( src/core/lib/compression/message_compress.h )
  s.files += %w( src/core/lib/compression/stream_compression.h )
  s.files += %w( src/core/lib/compression/stream_compression_gzip.h )
  s.files += %w( src/core/lib/compression/stream_compression_identity.h )
  s.files += %w( src/core/lib/debug/stats.h )
  s.files += %w( src/core/lib/debug/stats_data.h )
  s.files += %w( src/core/lib/gpr++/debug_location.h )
  s.files += %w( src/core/lib/gpr++/inlined_vector.h )
  s.files += %w( src/core/lib/gpr++/orphanable.h )
  s.files += %w( src/core/lib/gpr++/ref_counted.h )
  s.files += %w( src/core/lib/gpr++/ref_counted_ptr.h )
  s.files += %w( src/core/lib/http/format_request.h )
  s.files += %w( src/core/lib/http/httpcli.h )
  s.files += %w( src/core/lib/http/parser.h )
  s.files += %w( src/core/lib/iomgr/block_annotate.h )
  s.files += %w( src/core/lib/iomgr/call_combiner.h )
  s.files += %w( src/core/lib/iomgr/closure.h )
  s.files += %w( src/core/lib/iomgr/combiner.h )
  s.files += %w( src/core/lib/iomgr/endpoint.h )
  s.files += %w( src/core/lib/iomgr/endpoint_pair.h )
  s.files += %w( src/core/lib/iomgr/error.h )
  s.files += %w( src/core/lib/iomgr/error_internal.h )
  s.files += %w( src/core/lib/iomgr/ev_epoll1_linux.h )
  s.files += %w( src/core/lib/iomgr/ev_epollex_linux.h )
  s.files += %w( src/core/lib/iomgr/ev_epollsig_linux.h )
  s.files += %w( src/core/lib/iomgr/ev_poll_posix.h )
  s.files += %w( src/core/lib/iomgr/ev_posix.h )
  s.files += %w( src/core/lib/iomgr/exec_ctx.h )
  s.files += %w( src/core/lib/iomgr/executor.h )
  s.files += %w( src/core/lib/iomgr/gethostname.h )
  s.files += %w( src/core/lib/iomgr/iocp_windows.h )
  s.files += %w( src/core/lib/iomgr/iomgr.h )
  s.files += %w( src/core/lib/iomgr/iomgr_internal.h )
  s.files += %w( src/core/lib/iomgr/iomgr_posix.h )
  s.files += %w( src/core/lib/iomgr/iomgr_uv.h )
  s.files += %w( src/core/lib/iomgr/is_epollexclusive_available.h )
  s.files += %w( src/core/lib/iomgr/load_file.h )
  s.files += %w( src/core/lib/iomgr/lockfree_event.h )
  s.files += %w( src/core/lib/iomgr/nameser.h )
  s.files += %w( src/core/lib/iomgr/network_status_tracker.h )
  s.files += %w( src/core/lib/iomgr/polling_entity.h )
  s.files += %w( src/core/lib/iomgr/pollset.h )
  s.files += %w( src/core/lib/iomgr/pollset_set.h )
  s.files += %w( src/core/lib/iomgr/pollset_set_windows.h )
  s.files += %w( src/core/lib/iomgr/pollset_uv.h )
  s.files += %w( src/core/lib/iomgr/pollset_windows.h )
  s.files += %w( src/core/lib/iomgr/port.h )
  s.files += %w( src/core/lib/iomgr/resolve_address.h )
  s.files += %w( src/core/lib/iomgr/resource_quota.h )
  s.files += %w( src/core/lib/iomgr/sockaddr.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_posix.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_utils.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_windows.h )
  s.files += %w( src/core/lib/iomgr/socket_factory_posix.h )
  s.files += %w( src/core/lib/iomgr/socket_mutator.h )
  s.files += %w( src/core/lib/iomgr/socket_utils.h )
  s.files += %w( src/core/lib/iomgr/socket_utils_posix.h )
  s.files += %w( src/core/lib/iomgr/socket_windows.h )
  s.files += %w( src/core/lib/iomgr/sys_epoll_wrapper.h )
  s.files += %w( src/core/lib/iomgr/tcp_client.h )
  s.files += %w( src/core/lib/iomgr/tcp_client_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_server.h )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_uv.h )
  s.files += %w( src/core/lib/iomgr/tcp_windows.h )
  s.files += %w( src/core/lib/iomgr/time_averaged_stats.h )
  s.files += %w( src/core/lib/iomgr/timer.h )
  s.files += %w( src/core/lib/iomgr/timer_generic.h )
  s.files += %w( src/core/lib/iomgr/timer_heap.h )
  s.files += %w( src/core/lib/iomgr/timer_manager.h )
  s.files += %w( src/core/lib/iomgr/timer_uv.h )
  s.files += %w( src/core/lib/iomgr/udp_server.h )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix.h )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_cv.h )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_pipe.h )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_posix.h )
  s.files += %w( src/core/lib/json/json.h )
  s.files += %w( src/core/lib/json/json_common.h )
  s.files += %w( src/core/lib/json/json_reader.h )
  s.files += %w( src/core/lib/json/json_writer.h )
  s.files += %w( src/core/lib/slice/b64.h )
  s.files += %w( src/core/lib/slice/percent_encoding.h )
  s.files += %w( src/core/lib/slice/slice_hash_table.h )
  s.files += %w( src/core/lib/slice/slice_internal.h )
  s.files += %w( src/core/lib/slice/slice_string_helpers.h )
  s.files += %w( src/core/lib/surface/alarm_internal.h )
  s.files += %w( src/core/lib/surface/api_trace.h )
  s.files += %w( src/core/lib/surface/call.h )
  s.files += %w( src/core/lib/surface/call_test_only.h )
  s.files += %w( src/core/lib/surface/channel.h )
  s.files += %w( src/core/lib/surface/channel_init.h )
  s.files += %w( src/core/lib/surface/channel_stack_type.h )
  s.files += %w( src/core/lib/surface/completion_queue.h )
  s.files += %w( src/core/lib/surface/completion_queue_factory.h )
  s.files += %w( src/core/lib/surface/event_string.h )
  s.files += %w( src/core/lib/surface/init.h )
  s.files += %w( src/core/lib/surface/lame_client.h )
  s.files += %w( src/core/lib/surface/server.h )
  s.files += %w( src/core/lib/surface/validate_metadata.h )
  s.files += %w( src/core/lib/transport/bdp_estimator.h )
  s.files += %w( src/core/lib/transport/byte_stream.h )
  s.files += %w( src/core/lib/transport/connectivity_state.h )
  s.files += %w( src/core/lib/transport/error_utils.h )
  s.files += %w( src/core/lib/transport/http2_errors.h )
  s.files += %w( src/core/lib/transport/metadata.h )
  s.files += %w( src/core/lib/transport/metadata_batch.h )
  s.files += %w( src/core/lib/transport/pid_controller.h )
  s.files += %w( src/core/lib/transport/service_config.h )
  s.files += %w( src/core/lib/transport/static_metadata.h )
  s.files += %w( src/core/lib/transport/status_conversion.h )
  s.files += %w( src/core/lib/transport/timeout_encoding.h )
  s.files += %w( src/core/lib/transport/transport.h )
  s.files += %w( src/core/lib/transport/transport_impl.h )
  s.files += %w( src/core/lib/debug/trace.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_channel.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/proto/grpc/lb/v1/load_balancer.pb.h )
  s.files += %w( third_party/nanopb/pb.h )
  s.files += %w( third_party/nanopb/pb_common.h )
  s.files += %w( third_party/nanopb/pb_decode.h )
  s.files += %w( third_party/nanopb/pb_encode.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/fake/fake_resolver.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/subchannel_list.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.h )
  s.files += %w( src/core/ext/filters/load_reporting/server_load_reporting_filter.h )
  s.files += %w( src/core/ext/filters/load_reporting/server_load_reporting_plugin.h )
  s.files += %w( src/core/ext/filters/max_age/max_age_filter.h )
  s.files += %w( src/core/ext/filters/message_size/message_size_filter.h )
  s.files += %w( src/core/ext/filters/workarounds/workaround_cronet_compression_filter.h )
  s.files += %w( src/core/ext/filters/workarounds/workaround_utils.h )
  s.files += %w( src/core/lib/surface/init.cc )
  s.files += %w( src/core/lib/backoff/backoff.cc )
  s.files += %w( src/core/lib/channel/channel_args.cc )
  s.files += %w( src/core/lib/channel/channel_stack.cc )
  s.files += %w( src/core/lib/channel/channel_stack_builder.cc )
  s.files += %w( src/core/lib/channel/connected_channel.cc )
  s.files += %w( src/core/lib/channel/handshaker.cc )
  s.files += %w( src/core/lib/channel/handshaker_factory.cc )
  s.files += %w( src/core/lib/channel/handshaker_registry.cc )
  s.files += %w( src/core/lib/compression/compression.cc )
  s.files += %w( src/core/lib/compression/message_compress.cc )
  s.files += %w( src/core/lib/compression/stream_compression.cc )
  s.files += %w( src/core/lib/compression/stream_compression_gzip.cc )
  s.files += %w( src/core/lib/compression/stream_compression_identity.cc )
  s.files += %w( src/core/lib/debug/stats.cc )
  s.files += %w( src/core/lib/debug/stats_data.cc )
  s.files += %w( src/core/lib/http/format_request.cc )
  s.files += %w( src/core/lib/http/httpcli.cc )
  s.files += %w( src/core/lib/http/parser.cc )
  s.files += %w( src/core/lib/iomgr/call_combiner.cc )
  s.files += %w( src/core/lib/iomgr/combiner.cc )
  s.files += %w( src/core/lib/iomgr/endpoint.cc )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_posix.cc )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_uv.cc )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_windows.cc )
  s.files += %w( src/core/lib/iomgr/error.cc )
  s.files += %w( src/core/lib/iomgr/ev_epoll1_linux.cc )
  s.files += %w( src/core/lib/iomgr/ev_epollex_linux.cc )
  s.files += %w( src/core/lib/iomgr/ev_epollsig_linux.cc )
  s.files += %w( src/core/lib/iomgr/ev_poll_posix.cc )
  s.files += %w( src/core/lib/iomgr/ev_posix.cc )
  s.files += %w( src/core/lib/iomgr/ev_windows.cc )
  s.files += %w( src/core/lib/iomgr/exec_ctx.cc )
  s.files += %w( src/core/lib/iomgr/executor.cc )
  s.files += %w( src/core/lib/iomgr/fork_posix.cc )
  s.files += %w( src/core/lib/iomgr/fork_windows.cc )
  s.files += %w( src/core/lib/iomgr/gethostname_fallback.cc )
  s.files += %w( src/core/lib/iomgr/gethostname_host_name_max.cc )
  s.files += %w( src/core/lib/iomgr/gethostname_sysconf.cc )
  s.files += %w( src/core/lib/iomgr/iocp_windows.cc )
  s.files += %w( src/core/lib/iomgr/iomgr.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_posix.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_uv.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_windows.cc )
  s.files += %w( src/core/lib/iomgr/is_epollexclusive_available.cc )
  s.files += %w( src/core/lib/iomgr/load_file.cc )
  s.files += %w( src/core/lib/iomgr/lockfree_event.cc )
  s.files += %w( src/core/lib/iomgr/network_status_tracker.cc )
  s.files += %w( src/core/lib/iomgr/polling_entity.cc )
  s.files += %w( src/core/lib/iomgr/pollset_set_uv.cc )
  s.files += %w( src/core/lib/iomgr/pollset_set_windows.cc )
  s.files += %w( src/core/lib/iomgr/pollset_uv.cc )
  s.files += %w( src/core/lib/iomgr/pollset_windows.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address_posix.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address_uv.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address_windows.cc )
  s.files += %w( src/core/lib/iomgr/resource_quota.cc )
  s.files += %w( src/core/lib/iomgr/sockaddr_utils.cc )
  s.files += %w( src/core/lib/iomgr/socket_factory_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_mutator.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_common_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_linux.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_uv.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_windows.cc )
  s.files += %w( src/core/lib/iomgr/socket_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client_uv.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_common.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_uv.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_uv.cc )
  s.files += %w( src/core/lib/iomgr/tcp_windows.cc )
  s.files += %w( src/core/lib/iomgr/time_averaged_stats.cc )
  s.files += %w( src/core/lib/iomgr/timer_generic.cc )
  s.files += %w( src/core/lib/iomgr/timer_heap.cc )
  s.files += %w( src/core/lib/iomgr/timer_manager.cc )
  s.files += %w( src/core/lib/iomgr/timer_uv.cc )
  s.files += %w( src/core/lib/iomgr/udp_server.cc )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix.cc )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix_noop.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_cv.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_eventfd.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_nospecial.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_pipe.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_posix.cc )
  s.files += %w( src/core/lib/json/json.cc )
  s.files += %w( src/core/lib/json/json_reader.cc )
  s.files += %w( src/core/lib/json/json_string.cc )
  s.files += %w( src/core/lib/json/json_writer.cc )
  s.files += %w( src/core/lib/slice/b64.cc )
  s.files += %w( src/core/lib/slice/percent_encoding.cc )
  s.files += %w( src/core/lib/slice/slice.cc )
  s.files += %w( src/core/lib/slice/slice_buffer.cc )
  s.files += %w( src/core/lib/slice/slice_hash_table.cc )
  s.files += %w( src/core/lib/slice/slice_intern.cc )
  s.files += %w( src/core/lib/slice/slice_string_helpers.cc )
  s.files += %w( src/core/lib/surface/alarm.cc )
  s.files += %w( src/core/lib/surface/api_trace.cc )
  s.files += %w( src/core/lib/surface/byte_buffer.cc )
  s.files += %w( src/core/lib/surface/byte_buffer_reader.cc )
  s.files += %w( src/core/lib/surface/call.cc )
  s.files += %w( src/core/lib/surface/call_details.cc )
  s.files += %w( src/core/lib/surface/call_log_batch.cc )
  s.files += %w( src/core/lib/surface/channel.cc )
  s.files += %w( src/core/lib/surface/channel_init.cc )
  s.files += %w( src/core/lib/surface/channel_ping.cc )
  s.files += %w( src/core/lib/surface/channel_stack_type.cc )
  s.files += %w( src/core/lib/surface/completion_queue.cc )
  s.files += %w( src/core/lib/surface/completion_queue_factory.cc )
  s.files += %w( src/core/lib/surface/event_string.cc )
  s.files += %w( src/core/lib/surface/lame_client.cc )
  s.files += %w( src/core/lib/surface/metadata_array.cc )
  s.files += %w( src/core/lib/surface/server.cc )
  s.files += %w( src/core/lib/surface/validate_metadata.cc )
  s.files += %w( src/core/lib/surface/version.cc )
  s.files += %w( src/core/lib/transport/bdp_estimator.cc )
  s.files += %w( src/core/lib/transport/byte_stream.cc )
  s.files += %w( src/core/lib/transport/connectivity_state.cc )
  s.files += %w( src/core/lib/transport/error_utils.cc )
  s.files += %w( src/core/lib/transport/metadata.cc )
  s.files += %w( src/core/lib/transport/metadata_batch.cc )
  s.files += %w( src/core/lib/transport/pid_controller.cc )
  s.files += %w( src/core/lib/transport/service_config.cc )
  s.files += %w( src/core/lib/transport/static_metadata.cc )
  s.files += %w( src/core/lib/transport/status_conversion.cc )
  s.files += %w( src/core/lib/transport/timeout_encoding.cc )
  s.files += %w( src/core/lib/transport/transport.cc )
  s.files += %w( src/core/lib/transport/transport_op_string.cc )
  s.files += %w( src/core/lib/debug/trace.cc )
  s.files += %w( src/core/ext/transport/chttp2/server/secure/server_secure_chttp2.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_decoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_encoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_plugin.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_transport.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/flow_control.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_data.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_goaway.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_ping.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_rst_stream.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_settings.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_window_update.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_table.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/huffsyms.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/incoming_metadata.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/parsing.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_lists.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_map.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/varint.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/writing.cc )
  s.files += %w( src/core/ext/transport/chttp2/alpn/alpn.cc )
  s.files += %w( src/core/ext/filters/http/client/http_client_filter.cc )
  s.files += %w( src/core/ext/filters/http/http_filters_plugin.cc )
  s.files += %w( src/core/ext/filters/http/message_compress/message_compress_filter.cc )
  s.files += %w( src/core/ext/filters/http/server/http_server_filter.cc )
  s.files += %w( src/core/lib/http/httpcli_security_connector.cc )
  s.files += %w( src/core/lib/security/context/security_context.cc )
  s.files += %w( src/core/lib/security/credentials/composite/composite_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/credentials.cc )
  s.files += %w( src/core/lib/security/credentials/credentials_metadata.cc )
  s.files += %w( src/core/lib/security/credentials/fake/fake_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/google_default/credentials_generic.cc )
  s.files += %w( src/core/lib/security/credentials/google_default/google_default_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/iam/iam_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/jwt/json_token.cc )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_verifier.cc )
  s.files += %w( src/core/lib/security/credentials/oauth2/oauth2_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/plugin/plugin_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/ssl/ssl_credentials.cc )
  s.files += %w( src/core/lib/security/transport/client_auth_filter.cc )
  s.files += %w( src/core/lib/security/transport/lb_targets_info.cc )
  s.files += %w( src/core/lib/security/transport/secure_endpoint.cc )
  s.files += %w( src/core/lib/security/transport/security_connector.cc )
  s.files += %w( src/core/lib/security/transport/security_handshaker.cc )
  s.files += %w( src/core/lib/security/transport/server_auth_filter.cc )
  s.files += %w( src/core/lib/security/transport/tsi_error.cc )
  s.files += %w( src/core/lib/security/util/json_util.cc )
  s.files += %w( src/core/lib/surface/init_secure.cc )
  s.files += %w( src/core/tsi/fake_transport_security.cc )
  s.files += %w( src/core/tsi/gts_transport_security.cc )
  s.files += %w( src/core/tsi/ssl_transport_security.cc )
  s.files += %w( src/core/tsi/transport_security_grpc.cc )
  s.files += %w( src/core/tsi/transport_security.cc )
  s.files += %w( src/core/tsi/transport_security_adapter.cc )
  s.files += %w( src/core/ext/transport/chttp2/server/chttp2_server.cc )
  s.files += %w( src/core/ext/transport/chttp2/client/secure/secure_channel_create.cc )
  s.files += %w( src/core/ext/filters/client_channel/backup_poller.cc )
  s.files += %w( src/core/ext/filters/client_channel/channel_connectivity.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_factory.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_plugin.cc )
  s.files += %w( src/core/ext/filters/client_channel/connector.cc )
  s.files += %w( src/core/ext/filters/client_channel/http_connect_handshaker.cc )
  s.files += %w( src/core/ext/filters/client_channel/http_proxy.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy_factory.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy_registry.cc )
  s.files += %w( src/core/ext/filters/client_channel/parse_address.cc )
  s.files += %w( src/core/ext/filters/client_channel/proxy_mapper.cc )
  s.files += %w( src/core/ext/filters/client_channel/proxy_mapper_registry.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver_factory.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver_registry.cc )
  s.files += %w( src/core/ext/filters/client_channel/retry_throttle.cc )
  s.files += %w( src/core/ext/filters/client_channel/subchannel.cc )
  s.files += %w( src/core/ext/filters/client_channel/subchannel_index.cc )
  s.files += %w( src/core/ext/filters/client_channel/uri_parser.cc )
  s.files += %w( src/core/ext/filters/deadline/deadline_filter.cc )
  s.files += %w( src/core/ext/transport/chttp2/client/chttp2_connector.cc )
  s.files += %w( src/core/ext/transport/chttp2/server/insecure/server_chttp2.cc )
  s.files += %w( src/core/ext/transport/chttp2/server/insecure/server_chttp2_posix.cc )
  s.files += %w( src/core/ext/transport/chttp2/client/insecure/channel_create.cc )
  s.files += %w( src/core/ext/transport/chttp2/client/insecure/channel_create_posix.cc )
  s.files += %w( src/core/ext/transport/inproc/inproc_plugin.cc )
  s.files += %w( src/core/ext/transport/inproc/inproc_transport.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_channel_secure.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/proto/grpc/lb/v1/load_balancer.pb.c )
  s.files += %w( third_party/nanopb/pb_common.c )
  s.files += %w( third_party/nanopb/pb_decode.c )
  s.files += %w( third_party/nanopb/pb_encode.c )
  s.files += %w( src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/pick_first/pick_first.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/subchannel_list.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/round_robin/round_robin.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/dns_resolver_ares.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_fallback.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/native/dns_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/sockaddr/sockaddr_resolver.cc )
  s.files += %w( src/core/ext/filters/load_reporting/server_load_reporting_filter.cc )
  s.files += %w( src/core/ext/filters/load_reporting/server_load_reporting_plugin.cc )
  s.files += %w( src/core/ext/census/grpc_context.cc )
  s.files += %w( src/core/ext/filters/max_age/max_age_filter.cc )
  s.files += %w( src/core/ext/filters/message_size/message_size_filter.cc )
  s.files += %w( src/core/ext/filters/workarounds/workaround_cronet_compression_filter.cc )
  s.files += %w( src/core/ext/filters/workarounds/workaround_utils.cc )
  s.files += %w( src/core/plugin_registry/grpc_plugin_registry.cc )
  s.files += %w( third_party/boringssl/crypto/aes/internal.h )
  s.files += %w( third_party/boringssl/crypto/asn1/asn1_locl.h )
  s.files += %w( third_party/boringssl/crypto/bio/internal.h )
  s.files += %w( third_party/boringssl/crypto/bn/internal.h )
  s.files += %w( third_party/boringssl/crypto/bn/rsaz_exp.h )
  s.files += %w( third_party/boringssl/crypto/bytestring/internal.h )
  s.files += %w( third_party/boringssl/crypto/cipher/internal.h )
  s.files += %w( third_party/boringssl/crypto/conf/conf_def.h )
  s.files += %w( third_party/boringssl/crypto/conf/internal.h )
  s.files += %w( third_party/boringssl/crypto/curve25519/internal.h )
  s.files += %w( third_party/boringssl/crypto/des/internal.h )
  s.files += %w( third_party/boringssl/crypto/digest/internal.h )
  s.files += %w( third_party/boringssl/crypto/digest/md32_common.h )
  s.files += %w( third_party/boringssl/crypto/ec/internal.h )
  s.files += %w( third_party/boringssl/crypto/ec/p256-x86_64-table.h )
  s.files += %w( third_party/boringssl/crypto/ec/p256-x86_64.h )
  s.files += %w( third_party/boringssl/crypto/evp/internal.h )
  s.files += %w( third_party/boringssl/crypto/internal.h )
  s.files += %w( third_party/boringssl/crypto/modes/internal.h )
  s.files += %w( third_party/boringssl/crypto/obj/obj_dat.h )
  s.files += %w( third_party/boringssl/crypto/pkcs8/internal.h )
  s.files += %w( third_party/boringssl/crypto/poly1305/internal.h )
  s.files += %w( third_party/boringssl/crypto/pool/internal.h )
  s.files += %w( third_party/boringssl/crypto/rand/internal.h )
  s.files += %w( third_party/boringssl/crypto/rsa/internal.h )
  s.files += %w( third_party/boringssl/crypto/x509/charmap.h )
  s.files += %w( third_party/boringssl/crypto/x509/internal.h )
  s.files += %w( third_party/boringssl/crypto/x509/vpm_int.h )
  s.files += %w( third_party/boringssl/crypto/x509v3/ext_dat.h )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_int.h )
  s.files += %w( third_party/boringssl/include/openssl/aead.h )
  s.files += %w( third_party/boringssl/include/openssl/aes.h )
  s.files += %w( third_party/boringssl/include/openssl/arm_arch.h )
  s.files += %w( third_party/boringssl/include/openssl/asn1.h )
  s.files += %w( third_party/boringssl/include/openssl/asn1_mac.h )
  s.files += %w( third_party/boringssl/include/openssl/asn1t.h )
  s.files += %w( third_party/boringssl/include/openssl/base.h )
  s.files += %w( third_party/boringssl/include/openssl/base64.h )
  s.files += %w( third_party/boringssl/include/openssl/bio.h )
  s.files += %w( third_party/boringssl/include/openssl/blowfish.h )
  s.files += %w( third_party/boringssl/include/openssl/bn.h )
  s.files += %w( third_party/boringssl/include/openssl/buf.h )
  s.files += %w( third_party/boringssl/include/openssl/buffer.h )
  s.files += %w( third_party/boringssl/include/openssl/bytestring.h )
  s.files += %w( third_party/boringssl/include/openssl/cast.h )
  s.files += %w( third_party/boringssl/include/openssl/chacha.h )
  s.files += %w( third_party/boringssl/include/openssl/cipher.h )
  s.files += %w( third_party/boringssl/include/openssl/cmac.h )
  s.files += %w( third_party/boringssl/include/openssl/conf.h )
  s.files += %w( third_party/boringssl/include/openssl/cpu.h )
  s.files += %w( third_party/boringssl/include/openssl/crypto.h )
  s.files += %w( third_party/boringssl/include/openssl/curve25519.h )
  s.files += %w( third_party/boringssl/include/openssl/des.h )
  s.files += %w( third_party/boringssl/include/openssl/dh.h )
  s.files += %w( third_party/boringssl/include/openssl/digest.h )
  s.files += %w( third_party/boringssl/include/openssl/dsa.h )
  s.files += %w( third_party/boringssl/include/openssl/dtls1.h )
  s.files += %w( third_party/boringssl/include/openssl/ec.h )
  s.files += %w( third_party/boringssl/include/openssl/ec_key.h )
  s.files += %w( third_party/boringssl/include/openssl/ecdh.h )
  s.files += %w( third_party/boringssl/include/openssl/ecdsa.h )
  s.files += %w( third_party/boringssl/include/openssl/engine.h )
  s.files += %w( third_party/boringssl/include/openssl/err.h )
  s.files += %w( third_party/boringssl/include/openssl/evp.h )
  s.files += %w( third_party/boringssl/include/openssl/ex_data.h )
  s.files += %w( third_party/boringssl/include/openssl/hkdf.h )
  s.files += %w( third_party/boringssl/include/openssl/hmac.h )
  s.files += %w( third_party/boringssl/include/openssl/lhash.h )
  s.files += %w( third_party/boringssl/include/openssl/lhash_macros.h )
  s.files += %w( third_party/boringssl/include/openssl/md4.h )
  s.files += %w( third_party/boringssl/include/openssl/md5.h )
  s.files += %w( third_party/boringssl/include/openssl/mem.h )
  s.files += %w( third_party/boringssl/include/openssl/nid.h )
  s.files += %w( third_party/boringssl/include/openssl/obj.h )
  s.files += %w( third_party/boringssl/include/openssl/obj_mac.h )
  s.files += %w( third_party/boringssl/include/openssl/objects.h )
  s.files += %w( third_party/boringssl/include/openssl/opensslconf.h )
  s.files += %w( third_party/boringssl/include/openssl/opensslv.h )
  s.files += %w( third_party/boringssl/include/openssl/ossl_typ.h )
  s.files += %w( third_party/boringssl/include/openssl/pem.h )
  s.files += %w( third_party/boringssl/include/openssl/pkcs12.h )
  s.files += %w( third_party/boringssl/include/openssl/pkcs7.h )
  s.files += %w( third_party/boringssl/include/openssl/pkcs8.h )
  s.files += %w( third_party/boringssl/include/openssl/poly1305.h )
  s.files += %w( third_party/boringssl/include/openssl/pool.h )
  s.files += %w( third_party/boringssl/include/openssl/rand.h )
  s.files += %w( third_party/boringssl/include/openssl/rc4.h )
  s.files += %w( third_party/boringssl/include/openssl/ripemd.h )
  s.files += %w( third_party/boringssl/include/openssl/rsa.h )
  s.files += %w( third_party/boringssl/include/openssl/safestack.h )
  s.files += %w( third_party/boringssl/include/openssl/sha.h )
  s.files += %w( third_party/boringssl/include/openssl/srtp.h )
  s.files += %w( third_party/boringssl/include/openssl/ssl.h )
  s.files += %w( third_party/boringssl/include/openssl/ssl3.h )
  s.files += %w( third_party/boringssl/include/openssl/stack.h )
  s.files += %w( third_party/boringssl/include/openssl/stack_macros.h )
  s.files += %w( third_party/boringssl/include/openssl/thread.h )
  s.files += %w( third_party/boringssl/include/openssl/tls1.h )
  s.files += %w( third_party/boringssl/include/openssl/type_check.h )
  s.files += %w( third_party/boringssl/include/openssl/x509.h )
  s.files += %w( third_party/boringssl/include/openssl/x509_vfy.h )
  s.files += %w( third_party/boringssl/include/openssl/x509v3.h )
  s.files += %w( third_party/boringssl/ssl/internal.h )
  s.files += %w( src/boringssl/err_data.c )
  s.files += %w( third_party/boringssl/crypto/aes/aes.c )
  s.files += %w( third_party/boringssl/crypto/aes/key_wrap.c )
  s.files += %w( third_party/boringssl/crypto/aes/mode_wrappers.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_bitstr.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_bool.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_d2i_fp.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_dup.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_enum.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_gentm.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_i2d_fp.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_int.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_mbstr.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_object.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_octet.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_print.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_strnid.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_time.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_type.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_utctm.c )
  s.files += %w( third_party/boringssl/crypto/asn1/a_utf8.c )
  s.files += %w( third_party/boringssl/crypto/asn1/asn1_lib.c )
  s.files += %w( third_party/boringssl/crypto/asn1/asn1_par.c )
  s.files += %w( third_party/boringssl/crypto/asn1/asn_pack.c )
  s.files += %w( third_party/boringssl/crypto/asn1/f_enum.c )
  s.files += %w( third_party/boringssl/crypto/asn1/f_int.c )
  s.files += %w( third_party/boringssl/crypto/asn1/f_string.c )
  s.files += %w( third_party/boringssl/crypto/asn1/t_bitst.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_dec.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_enc.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_fre.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_new.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_typ.c )
  s.files += %w( third_party/boringssl/crypto/asn1/tasn_utl.c )
  s.files += %w( third_party/boringssl/crypto/asn1/time_support.c )
  s.files += %w( third_party/boringssl/crypto/asn1/x_bignum.c )
  s.files += %w( third_party/boringssl/crypto/asn1/x_long.c )
  s.files += %w( third_party/boringssl/crypto/base64/base64.c )
  s.files += %w( third_party/boringssl/crypto/bio/bio.c )
  s.files += %w( third_party/boringssl/crypto/bio/bio_mem.c )
  s.files += %w( third_party/boringssl/crypto/bio/connect.c )
  s.files += %w( third_party/boringssl/crypto/bio/fd.c )
  s.files += %w( third_party/boringssl/crypto/bio/file.c )
  s.files += %w( third_party/boringssl/crypto/bio/hexdump.c )
  s.files += %w( third_party/boringssl/crypto/bio/pair.c )
  s.files += %w( third_party/boringssl/crypto/bio/printf.c )
  s.files += %w( third_party/boringssl/crypto/bio/socket.c )
  s.files += %w( third_party/boringssl/crypto/bio/socket_helper.c )
  s.files += %w( third_party/boringssl/crypto/bn/add.c )
  s.files += %w( third_party/boringssl/crypto/bn/asm/x86_64-gcc.c )
  s.files += %w( third_party/boringssl/crypto/bn/bn.c )
  s.files += %w( third_party/boringssl/crypto/bn/bn_asn1.c )
  s.files += %w( third_party/boringssl/crypto/bn/cmp.c )
  s.files += %w( third_party/boringssl/crypto/bn/convert.c )
  s.files += %w( third_party/boringssl/crypto/bn/ctx.c )
  s.files += %w( third_party/boringssl/crypto/bn/div.c )
  s.files += %w( third_party/boringssl/crypto/bn/exponentiation.c )
  s.files += %w( third_party/boringssl/crypto/bn/gcd.c )
  s.files += %w( third_party/boringssl/crypto/bn/generic.c )
  s.files += %w( third_party/boringssl/crypto/bn/kronecker.c )
  s.files += %w( third_party/boringssl/crypto/bn/montgomery.c )
  s.files += %w( third_party/boringssl/crypto/bn/montgomery_inv.c )
  s.files += %w( third_party/boringssl/crypto/bn/mul.c )
  s.files += %w( third_party/boringssl/crypto/bn/prime.c )
  s.files += %w( third_party/boringssl/crypto/bn/random.c )
  s.files += %w( third_party/boringssl/crypto/bn/rsaz_exp.c )
  s.files += %w( third_party/boringssl/crypto/bn/shift.c )
  s.files += %w( third_party/boringssl/crypto/bn/sqrt.c )
  s.files += %w( third_party/boringssl/crypto/buf/buf.c )
  s.files += %w( third_party/boringssl/crypto/bytestring/asn1_compat.c )
  s.files += %w( third_party/boringssl/crypto/bytestring/ber.c )
  s.files += %w( third_party/boringssl/crypto/bytestring/cbb.c )
  s.files += %w( third_party/boringssl/crypto/bytestring/cbs.c )
  s.files += %w( third_party/boringssl/crypto/chacha/chacha.c )
  s.files += %w( third_party/boringssl/crypto/cipher/aead.c )
  s.files += %w( third_party/boringssl/crypto/cipher/cipher.c )
  s.files += %w( third_party/boringssl/crypto/cipher/derive_key.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_aes.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_chacha20poly1305.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_des.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_null.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_rc2.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_rc4.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_ssl3.c )
  s.files += %w( third_party/boringssl/crypto/cipher/e_tls.c )
  s.files += %w( third_party/boringssl/crypto/cipher/tls_cbc.c )
  s.files += %w( third_party/boringssl/crypto/cmac/cmac.c )
  s.files += %w( third_party/boringssl/crypto/conf/conf.c )
  s.files += %w( third_party/boringssl/crypto/cpu-aarch64-linux.c )
  s.files += %w( third_party/boringssl/crypto/cpu-arm-linux.c )
  s.files += %w( third_party/boringssl/crypto/cpu-arm.c )
  s.files += %w( third_party/boringssl/crypto/cpu-intel.c )
  s.files += %w( third_party/boringssl/crypto/cpu-ppc64le.c )
  s.files += %w( third_party/boringssl/crypto/crypto.c )
  s.files += %w( third_party/boringssl/crypto/curve25519/curve25519.c )
  s.files += %w( third_party/boringssl/crypto/curve25519/spake25519.c )
  s.files += %w( third_party/boringssl/crypto/curve25519/x25519-x86_64.c )
  s.files += %w( third_party/boringssl/crypto/des/des.c )
  s.files += %w( third_party/boringssl/crypto/dh/check.c )
  s.files += %w( third_party/boringssl/crypto/dh/dh.c )
  s.files += %w( third_party/boringssl/crypto/dh/dh_asn1.c )
  s.files += %w( third_party/boringssl/crypto/dh/params.c )
  s.files += %w( third_party/boringssl/crypto/digest/digest.c )
  s.files += %w( third_party/boringssl/crypto/digest/digests.c )
  s.files += %w( third_party/boringssl/crypto/dsa/dsa.c )
  s.files += %w( third_party/boringssl/crypto/dsa/dsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/ec/ec.c )
  s.files += %w( third_party/boringssl/crypto/ec/ec_asn1.c )
  s.files += %w( third_party/boringssl/crypto/ec/ec_key.c )
  s.files += %w( third_party/boringssl/crypto/ec/ec_montgomery.c )
  s.files += %w( third_party/boringssl/crypto/ec/oct.c )
  s.files += %w( third_party/boringssl/crypto/ec/p224-64.c )
  s.files += %w( third_party/boringssl/crypto/ec/p256-64.c )
  s.files += %w( third_party/boringssl/crypto/ec/p256-x86_64.c )
  s.files += %w( third_party/boringssl/crypto/ec/simple.c )
  s.files += %w( third_party/boringssl/crypto/ec/util-64.c )
  s.files += %w( third_party/boringssl/crypto/ec/wnaf.c )
  s.files += %w( third_party/boringssl/crypto/ecdh/ecdh.c )
  s.files += %w( third_party/boringssl/crypto/ecdsa/ecdsa.c )
  s.files += %w( third_party/boringssl/crypto/ecdsa/ecdsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/engine/engine.c )
  s.files += %w( third_party/boringssl/crypto/err/err.c )
  s.files += %w( third_party/boringssl/crypto/evp/digestsign.c )
  s.files += %w( third_party/boringssl/crypto/evp/evp.c )
  s.files += %w( third_party/boringssl/crypto/evp/evp_asn1.c )
  s.files += %w( third_party/boringssl/crypto/evp/evp_ctx.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_dsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_ec.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_ec_asn1.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_rsa.c )
  s.files += %w( third_party/boringssl/crypto/evp/p_rsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/evp/pbkdf.c )
  s.files += %w( third_party/boringssl/crypto/evp/print.c )
  s.files += %w( third_party/boringssl/crypto/evp/sign.c )
  s.files += %w( third_party/boringssl/crypto/ex_data.c )
  s.files += %w( third_party/boringssl/crypto/hkdf/hkdf.c )
  s.files += %w( third_party/boringssl/crypto/hmac/hmac.c )
  s.files += %w( third_party/boringssl/crypto/lhash/lhash.c )
  s.files += %w( third_party/boringssl/crypto/md4/md4.c )
  s.files += %w( third_party/boringssl/crypto/md5/md5.c )
  s.files += %w( third_party/boringssl/crypto/mem.c )
  s.files += %w( third_party/boringssl/crypto/modes/cbc.c )
  s.files += %w( third_party/boringssl/crypto/modes/cfb.c )
  s.files += %w( third_party/boringssl/crypto/modes/ctr.c )
  s.files += %w( third_party/boringssl/crypto/modes/gcm.c )
  s.files += %w( third_party/boringssl/crypto/modes/ofb.c )
  s.files += %w( third_party/boringssl/crypto/modes/polyval.c )
  s.files += %w( third_party/boringssl/crypto/obj/obj.c )
  s.files += %w( third_party/boringssl/crypto/obj/obj_xref.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_all.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_info.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_lib.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_oth.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_pk8.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_pkey.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_x509.c )
  s.files += %w( third_party/boringssl/crypto/pem/pem_xaux.c )
  s.files += %w( third_party/boringssl/crypto/pkcs8/p5_pbev2.c )
  s.files += %w( third_party/boringssl/crypto/pkcs8/p8_pkey.c )
  s.files += %w( third_party/boringssl/crypto/pkcs8/pkcs8.c )
  s.files += %w( third_party/boringssl/crypto/poly1305/poly1305.c )
  s.files += %w( third_party/boringssl/crypto/poly1305/poly1305_arm.c )
  s.files += %w( third_party/boringssl/crypto/poly1305/poly1305_vec.c )
  s.files += %w( third_party/boringssl/crypto/pool/pool.c )
  s.files += %w( third_party/boringssl/crypto/rand/deterministic.c )
  s.files += %w( third_party/boringssl/crypto/rand/fuchsia.c )
  s.files += %w( third_party/boringssl/crypto/rand/rand.c )
  s.files += %w( third_party/boringssl/crypto/rand/urandom.c )
  s.files += %w( third_party/boringssl/crypto/rand/windows.c )
  s.files += %w( third_party/boringssl/crypto/rc4/rc4.c )
  s.files += %w( third_party/boringssl/crypto/refcount_c11.c )
  s.files += %w( third_party/boringssl/crypto/refcount_lock.c )
  s.files += %w( third_party/boringssl/crypto/rsa/blinding.c )
  s.files += %w( third_party/boringssl/crypto/rsa/padding.c )
  s.files += %w( third_party/boringssl/crypto/rsa/rsa.c )
  s.files += %w( third_party/boringssl/crypto/rsa/rsa_asn1.c )
  s.files += %w( third_party/boringssl/crypto/rsa/rsa_impl.c )
  s.files += %w( third_party/boringssl/crypto/sha/sha1-altivec.c )
  s.files += %w( third_party/boringssl/crypto/sha/sha1.c )
  s.files += %w( third_party/boringssl/crypto/sha/sha256.c )
  s.files += %w( third_party/boringssl/crypto/sha/sha512.c )
  s.files += %w( third_party/boringssl/crypto/stack/stack.c )
  s.files += %w( third_party/boringssl/crypto/thread.c )
  s.files += %w( third_party/boringssl/crypto/thread_none.c )
  s.files += %w( third_party/boringssl/crypto/thread_pthread.c )
  s.files += %w( third_party/boringssl/crypto/thread_win.c )
  s.files += %w( third_party/boringssl/crypto/x509/a_digest.c )
  s.files += %w( third_party/boringssl/crypto/x509/a_sign.c )
  s.files += %w( third_party/boringssl/crypto/x509/a_strex.c )
  s.files += %w( third_party/boringssl/crypto/x509/a_verify.c )
  s.files += %w( third_party/boringssl/crypto/x509/algorithm.c )
  s.files += %w( third_party/boringssl/crypto/x509/asn1_gen.c )
  s.files += %w( third_party/boringssl/crypto/x509/by_dir.c )
  s.files += %w( third_party/boringssl/crypto/x509/by_file.c )
  s.files += %w( third_party/boringssl/crypto/x509/i2d_pr.c )
  s.files += %w( third_party/boringssl/crypto/x509/pkcs7.c )
  s.files += %w( third_party/boringssl/crypto/x509/rsa_pss.c )
  s.files += %w( third_party/boringssl/crypto/x509/t_crl.c )
  s.files += %w( third_party/boringssl/crypto/x509/t_req.c )
  s.files += %w( third_party/boringssl/crypto/x509/t_x509.c )
  s.files += %w( third_party/boringssl/crypto/x509/t_x509a.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_att.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_cmp.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_d2.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_def.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_ext.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_lu.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_obj.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_r2x.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_req.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_set.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_trs.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_txt.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_v3.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_vfy.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509_vpm.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509cset.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509name.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509rset.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509spki.c )
  s.files += %w( third_party/boringssl/crypto/x509/x509type.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_algor.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_all.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_attrib.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_crl.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_exten.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_info.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_name.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_pkey.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_pubkey.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_req.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_sig.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_spki.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_val.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_x509.c )
  s.files += %w( third_party/boringssl/crypto/x509/x_x509a.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_cache.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_data.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_lib.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_map.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_node.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/pcy_tree.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_akey.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_akeya.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_alt.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_bcons.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_bitst.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_conf.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_cpols.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_crld.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_enum.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_extku.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_genn.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_ia5.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_info.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_int.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_lib.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_ncons.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pci.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pcia.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pcons.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pku.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_pmaps.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_prn.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_purp.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_skey.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_sxnet.c )
  s.files += %w( third_party/boringssl/crypto/x509v3/v3_utl.c )
  s.files += %w( third_party/boringssl/ssl/bio_ssl.c )
  s.files += %w( third_party/boringssl/ssl/custom_extensions.c )
  s.files += %w( third_party/boringssl/ssl/d1_both.c )
  s.files += %w( third_party/boringssl/ssl/d1_lib.c )
  s.files += %w( third_party/boringssl/ssl/d1_pkt.c )
  s.files += %w( third_party/boringssl/ssl/d1_srtp.c )
  s.files += %w( third_party/boringssl/ssl/dtls_method.c )
  s.files += %w( third_party/boringssl/ssl/dtls_record.c )
  s.files += %w( third_party/boringssl/ssl/handshake_client.c )
  s.files += %w( third_party/boringssl/ssl/handshake_server.c )
  s.files += %w( third_party/boringssl/ssl/s3_both.c )
  s.files += %w( third_party/boringssl/ssl/s3_lib.c )
  s.files += %w( third_party/boringssl/ssl/s3_pkt.c )
  s.files += %w( third_party/boringssl/ssl/ssl_aead_ctx.c )
  s.files += %w( third_party/boringssl/ssl/ssl_asn1.c )
  s.files += %w( third_party/boringssl/ssl/ssl_buffer.c )
  s.files += %w( third_party/boringssl/ssl/ssl_cert.c )
  s.files += %w( third_party/boringssl/ssl/ssl_cipher.c )
  s.files += %w( third_party/boringssl/ssl/ssl_ecdh.c )
  s.files += %w( third_party/boringssl/ssl/ssl_file.c )
  s.files += %w( third_party/boringssl/ssl/ssl_lib.c )
  s.files += %w( third_party/boringssl/ssl/ssl_privkey.c )
  s.files += %w( third_party/boringssl/ssl/ssl_privkey_cc.cc )
  s.files += %w( third_party/boringssl/ssl/ssl_session.c )
  s.files += %w( third_party/boringssl/ssl/ssl_stat.c )
  s.files += %w( third_party/boringssl/ssl/ssl_transcript.c )
  s.files += %w( third_party/boringssl/ssl/ssl_x509.c )
  s.files += %w( third_party/boringssl/ssl/t1_enc.c )
  s.files += %w( third_party/boringssl/ssl/t1_lib.c )
  s.files += %w( third_party/boringssl/ssl/tls13_both.c )
  s.files += %w( third_party/boringssl/ssl/tls13_client.c )
  s.files += %w( third_party/boringssl/ssl/tls13_enc.c )
  s.files += %w( third_party/boringssl/ssl/tls13_server.c )
  s.files += %w( third_party/boringssl/ssl/tls_method.c )
  s.files += %w( third_party/boringssl/ssl/tls_record.c )
  s.files += %w( third_party/zlib/crc32.h )
  s.files += %w( third_party/zlib/deflate.h )
  s.files += %w( third_party/zlib/gzguts.h )
  s.files += %w( third_party/zlib/inffast.h )
  s.files += %w( third_party/zlib/inffixed.h )
  s.files += %w( third_party/zlib/inflate.h )
  s.files += %w( third_party/zlib/inftrees.h )
  s.files += %w( third_party/zlib/trees.h )
  s.files += %w( third_party/zlib/zconf.h )
  s.files += %w( third_party/zlib/zlib.h )
  s.files += %w( third_party/zlib/zutil.h )
  s.files += %w( third_party/zlib/adler32.c )
  s.files += %w( third_party/zlib/compress.c )
  s.files += %w( third_party/zlib/crc32.c )
  s.files += %w( third_party/zlib/deflate.c )
  s.files += %w( third_party/zlib/gzclose.c )
  s.files += %w( third_party/zlib/gzlib.c )
  s.files += %w( third_party/zlib/gzread.c )
  s.files += %w( third_party/zlib/gzwrite.c )
  s.files += %w( third_party/zlib/infback.c )
  s.files += %w( third_party/zlib/inffast.c )
  s.files += %w( third_party/zlib/inflate.c )
  s.files += %w( third_party/zlib/inftrees.c )
  s.files += %w( third_party/zlib/trees.c )
  s.files += %w( third_party/zlib/uncompr.c )
  s.files += %w( third_party/zlib/zutil.c )
  s.files += %w( third_party/cares/cares/ares.h )
  s.files += %w( third_party/cares/cares/ares_data.h )
  s.files += %w( third_party/cares/cares/ares_dns.h )
  s.files += %w( third_party/cares/cares/ares_getenv.h )
  s.files += %w( third_party/cares/cares/ares_getopt.h )
  s.files += %w( third_party/cares/cares/ares_inet_net_pton.h )
  s.files += %w( third_party/cares/cares/ares_iphlpapi.h )
  s.files += %w( third_party/cares/cares/ares_ipv6.h )
  s.files += %w( third_party/cares/cares/ares_library_init.h )
  s.files += %w( third_party/cares/cares/ares_llist.h )
  s.files += %w( third_party/cares/cares/ares_nowarn.h )
  s.files += %w( third_party/cares/cares/ares_platform.h )
  s.files += %w( third_party/cares/cares/ares_private.h )
  s.files += %w( third_party/cares/cares/ares_rules.h )
  s.files += %w( third_party/cares/cares/ares_setup.h )
  s.files += %w( third_party/cares/cares/ares_strcasecmp.h )
  s.files += %w( third_party/cares/cares/ares_strdup.h )
  s.files += %w( third_party/cares/cares/ares_version.h )
  s.files += %w( third_party/cares/cares/bitncmp.h )
  s.files += %w( third_party/cares/cares/config-win32.h )
  s.files += %w( third_party/cares/cares/setup_once.h )
  s.files += %w( third_party/cares/ares_build.h )
  s.files += %w( third_party/cares/config_darwin/ares_config.h )
  s.files += %w( third_party/cares/config_freebsd/ares_config.h )
  s.files += %w( third_party/cares/config_linux/ares_config.h )
  s.files += %w( third_party/cares/config_openbsd/ares_config.h )
  s.files += %w( third_party/cares/cares/ares__close_sockets.c )
  s.files += %w( third_party/cares/cares/ares__get_hostent.c )
  s.files += %w( third_party/cares/cares/ares__read_line.c )
  s.files += %w( third_party/cares/cares/ares__timeval.c )
  s.files += %w( third_party/cares/cares/ares_cancel.c )
  s.files += %w( third_party/cares/cares/ares_create_query.c )
  s.files += %w( third_party/cares/cares/ares_data.c )
  s.files += %w( third_party/cares/cares/ares_destroy.c )
  s.files += %w( third_party/cares/cares/ares_expand_name.c )
  s.files += %w( third_party/cares/cares/ares_expand_string.c )
  s.files += %w( third_party/cares/cares/ares_fds.c )
  s.files += %w( third_party/cares/cares/ares_free_hostent.c )
  s.files += %w( third_party/cares/cares/ares_free_string.c )
  s.files += %w( third_party/cares/cares/ares_getenv.c )
  s.files += %w( third_party/cares/cares/ares_gethostbyaddr.c )
  s.files += %w( third_party/cares/cares/ares_gethostbyname.c )
  s.files += %w( third_party/cares/cares/ares_getnameinfo.c )
  s.files += %w( third_party/cares/cares/ares_getopt.c )
  s.files += %w( third_party/cares/cares/ares_getsock.c )
  s.files += %w( third_party/cares/cares/ares_init.c )
  s.files += %w( third_party/cares/cares/ares_library_init.c )
  s.files += %w( third_party/cares/cares/ares_llist.c )
  s.files += %w( third_party/cares/cares/ares_mkquery.c )
  s.files += %w( third_party/cares/cares/ares_nowarn.c )
  s.files += %w( third_party/cares/cares/ares_options.c )
  s.files += %w( third_party/cares/cares/ares_parse_a_reply.c )
  s.files += %w( third_party/cares/cares/ares_parse_aaaa_reply.c )
  s.files += %w( third_party/cares/cares/ares_parse_mx_reply.c )
  s.files += %w( third_party/cares/cares/ares_parse_naptr_reply.c )
  s.files += %w( third_party/cares/cares/ares_parse_ns_reply.c )
  s.files += %w( third_party/cares/cares/ares_parse_ptr_reply.c )
  s.files += %w( third_party/cares/cares/ares_parse_soa_reply.c )
  s.files += %w( third_party/cares/cares/ares_parse_srv_reply.c )
  s.files += %w( third_party/cares/cares/ares_parse_txt_reply.c )
  s.files += %w( third_party/cares/cares/ares_platform.c )
  s.files += %w( third_party/cares/cares/ares_process.c )
  s.files += %w( third_party/cares/cares/ares_query.c )
  s.files += %w( third_party/cares/cares/ares_search.c )
  s.files += %w( third_party/cares/cares/ares_send.c )
  s.files += %w( third_party/cares/cares/ares_strcasecmp.c )
  s.files += %w( third_party/cares/cares/ares_strdup.c )
  s.files += %w( third_party/cares/cares/ares_strerror.c )
  s.files += %w( third_party/cares/cares/ares_timeout.c )
  s.files += %w( third_party/cares/cares/ares_version.c )
  s.files += %w( third_party/cares/cares/ares_writev.c )
  s.files += %w( third_party/cares/cares/bitncmp.c )
  s.files += %w( third_party/cares/cares/inet_net_pton.c )
  s.files += %w( third_party/cares/cares/inet_ntop.c )
  s.files += %w( third_party/cares/cares/windows_port.c )
end
